/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.language.replacer;

import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.ComponentLike;
import com.github.sirblobman.api.shaded.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;

public final class TranslatableReplacer
extends Replacer {
    private final String translationKey;
    private final ComponentLike[] args;

    public TranslatableReplacer(@NotNull String target, @NotNull String translationKey, ComponentLike ... args) {
        super(target);
        this.translationKey = translationKey;
        this.args = args;
    }

    @Override
    @NotNull
    public Component getReplacement() {
        return Component.translatable(this.translationKey, this.args);
    }

    @Override
    @NotNull
    public String getReplacementString() {
        Component replacement = this.getReplacement();
        PlainTextComponentSerializer serializer = PlainTextComponentSerializer.plainText();
        return serializer.serialize(replacement);
    }
}

