/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.language.replacer;

import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.TextReplacementConfig;
import org.jetbrains.annotations.NotNull;

public abstract class Replacer {
    private final String target;

    public Replacer(@NotNull String target) {
        this.target = target;
    }

    @NotNull
    public String getTarget() {
        return this.target;
    }

    @NotNull
    public abstract Component getReplacement();

    @NotNull
    public abstract String getReplacementString();

    @NotNull
    public final String replaceString(@NotNull String original) {
        String target = this.getTarget();
        String replacement = this.getReplacementString();
        return original.replace(target, replacement);
    }

    @NotNull
    public final TextReplacementConfig asReplacementConfig() {
        String target = this.getTarget();
        Component replacement = this.getReplacement();
        TextReplacementConfig.Builder builder = TextReplacementConfig.builder();
        return (TextReplacementConfig)builder.matchLiteral(target).replacement(replacement).build();
    }
}

