/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.language;

import com.github.sirblobman.api.configuration.ConfigurationManager;
import com.github.sirblobman.api.configuration.IResourceHolder;
import com.github.sirblobman.api.configuration.WrapperPluginResourceHolder;
import com.github.sirblobman.api.language.ComponentBungeeConverter;
import com.github.sirblobman.api.language.Language;
import com.github.sirblobman.api.language.LanguageConfiguration;
import com.github.sirblobman.api.language.LanguageConfigurationComparator;
import com.github.sirblobman.api.language.custom.ModifiableMessage;
import com.github.sirblobman.api.language.custom.ModifiableMessageType;
import com.github.sirblobman.api.language.custom.PlayerListInfo;
import com.github.sirblobman.api.language.listener.LanguageListener;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.shaded.adventure.audience.Audience;
import com.github.sirblobman.api.shaded.adventure.platform.AudienceProvider;
import com.github.sirblobman.api.shaded.adventure.platform.bukkit.BukkitAudiences;
import com.github.sirblobman.api.shaded.adventure.sound.Sound;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.ComponentLike;
import com.github.sirblobman.api.shaded.adventure.text.TextComponent;
import com.github.sirblobman.api.shaded.adventure.text.TextReplacementConfig;
import com.github.sirblobman.api.shaded.adventure.text.minimessage.MiniMessage;
import com.github.sirblobman.api.shaded.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.github.sirblobman.api.shaded.adventure.title.Title;
import com.github.sirblobman.api.utility.Validate;
import com.github.sirblobman.api.utility.VersionUtility;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageManager {
    private static final String[] KNOWN_LANGUAGE_ARRAY = new String[]{"af_za", "ar_sa", "ast_es", "az_az", "ba_ru", "bar", "be_by", "bg_bg", "br_fr", "brb", "bs_ba", "ca_es", "cs_cz", "cy_gb", "da_dk", "de_at", "de_ch", "de_de", "el_gr", "en_au", "en_ca", "en_gb", "en_nz", "en_pt", "en_ud", "en_us", "enp", "enws", "eo_uy", "es_ar", "es_cl", "es_ec", "es_es", "es_mx", "es_uy", "es_ve", "esan", "et_ee", "eu_es", "fa_ir", "fi_fi", "fil_ph", "fo_fo", "fr_ca", "fr_fr", "fra_de", "fy_nl", "ga_ie", "gd_gb", "gl_es", "got_de", "gv_im", "haw_us", "he_il", "hi_in", "hr_hr", "hu_hu", "hy_am", "id_id", "ig_ng", "io_en", "is_is", "isv", "it_it", "ja_jp", "jbo_en", "ka_ge", "kab_kab", "kk_kz", "kn_in", "ko_kr", "ksh", "kw_gb", "la_la", "lb_lu", "li_li", "lol_us", "lt_lt", "lv_lv", "mi_nz", "mk_mk", "mn_mn", "moh_ca", "ms_my", "mt_mt", "nds_de", "nl_be", "nl_nl", "nn_no", "no_no", "nb_no", "nuk", "oc_fr", "oj_ca", "ovd", "pl_pl", "pt_br", "pt_pt", "qya_aa", "ro_ro", "rpr", "ru_ru", "scn", "se_no", "sk_sk", "sl_si", "so_so", "sq_al", "sr_sp", "sv_se", "swg", "sxu", "szl", "ta_in", "th_th", "tl_ph", "tlh_aa", "tr_tr", "tt_ru", "tzl_tzl", "uk_ua", "val_es", "vec_it", "vi_vn", "yi_de", "yo_ng", "zh_cn", "zh_hk", "zh_tw"};
    private final IResourceHolder plugin;
    private final ConfigurationManager configurationManager;
    private final Map<UUID, String> localeMap;
    private final Map<String, Language> languageMap;
    private final MiniMessage miniMessage;
    private String defaultLanguageName;
    private String consoleLanguageName;
    private boolean forceDefaultLanguage;
    private boolean usePlaceholderAPI;
    private boolean debugLanguage;
    private AudienceProvider audienceProvider;
    private Language defaultLanguage;
    private Language consoleLanguage;

    public LanguageManager(@NotNull ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        this.plugin = configurationManager.getResourceHolder();
        this.localeMap = new HashMap<UUID, String>();
        this.languageMap = new HashMap<String, Language>();
        MiniMessage.Builder builder = MiniMessage.builder();
        builder.strict(false);
        builder.debug(this::printMiniMessageDebug);
        this.miniMessage = builder.build();
    }

    @NotNull
    public IResourceHolder getPlugin() {
        return this.plugin;
    }

    @NotNull
    public Logger getLogger() {
        IResourceHolder plugin = this.getPlugin();
        return plugin.getLogger();
    }

    @NotNull
    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    @NotNull
    public String getCachedLocale(@NotNull OfflinePlayer player) {
        UUID playerId = player.getUniqueId();
        return this.localeMap.get(playerId);
    }

    public void setLocale(@NotNull Player player, @NotNull String locale) {
        this.printDebug("Detected setLocale for player '" + player.getName() + "' and locale '" + locale + "'.");
        UUID playerId = player.getUniqueId();
        this.localeMap.put(playerId, locale);
    }

    public void removeLocale(@NotNull Player player) {
        this.printDebug("Detected removeLocale for player '" + player.getName() + "'.");
        UUID playerId = player.getUniqueId();
        this.localeMap.remove(playerId);
    }

    @Nullable
    public Language getDefaultLanguage() {
        if (this.defaultLanguage != null) {
            return this.defaultLanguage;
        }
        if (this.defaultLanguageName == null) {
            Logger logger = this.getLogger();
            logger.warning("The default language name is not properly defined.");
            return null;
        }
        this.defaultLanguage = this.languageMap.get(this.defaultLanguageName);
        return this.defaultLanguage;
    }

    @Nullable
    public Language getConsoleLanguage() {
        if (this.forceDefaultLanguage) {
            return this.getDefaultLanguage();
        }
        if (this.consoleLanguage != null) {
            return this.consoleLanguage;
        }
        Logger logger = this.getLogger();
        if (this.consoleLanguageName == null) {
            logger.warning("The console language name is not properly defined, using default.");
            return this.getDefaultLanguage();
        }
        this.consoleLanguage = this.getLanguage(this.consoleLanguageName);
        if (this.consoleLanguage == null) {
            logger.warning("The console language name '" + this.consoleLanguageName + "' is not valid, using default.");
            return this.getDefaultLanguage();
        }
        return this.consoleLanguage;
    }

    @Nullable
    public Language getLanguage(@Nullable String name) {
        this.printDebug("Detected getLanguage for name '" + name + "'...");
        Language defaultLanguage = this.getDefaultLanguage();
        if (name == null || name.isEmpty() || name.equals("default")) {
            this.printDebug("Name is not valid, using default language.");
            return defaultLanguage;
        }
        this.printDebug("Getting name from language map.");
        return this.languageMap.getOrDefault(name, defaultLanguage);
    }

    @Nullable
    private Language getPlayerLanguage(@NotNull Player player) {
        this.printDebug("Detected getPlayerLanguage for player '" + player.getName() + "'.");
        String cachedLocale = this.getCachedLocale((OfflinePlayer)player);
        this.printDebug("Cached Locale Name: " + cachedLocale);
        return this.getLanguage(cachedLocale);
    }

    @Nullable
    public Language getLanguage(@Nullable CommandSender sender) {
        if (this.forceDefaultLanguage) {
            return this.getDefaultLanguage();
        }
        if (sender == null || sender instanceof ConsoleCommandSender) {
            return this.getConsoleLanguage();
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return this.getPlayerLanguage(player);
        }
        return this.getDefaultLanguage();
    }

    public void onPluginEnable() {
        this.printDebug("Detected onPluginEnable...");
        IResourceHolder resourceHolder = this.getPlugin();
        if (resourceHolder instanceof WrapperPluginResourceHolder) {
            this.printDebug("Plugin is a resource holder.");
            WrapperPluginResourceHolder wrapper = (WrapperPluginResourceHolder)resourceHolder;
            Plugin plugin = wrapper.getPlugin();
            int minorVersion = VersionUtility.getMinorVersion();
            if (minorVersion >= 12) {
                this.printDebug("Version is 1.12 or greater, registering language listener...");
                new LanguageListener(plugin, this).register();
            }
            this.audienceProvider = BukkitAudiences.create(plugin);
            this.printDebug("Successfully created BukkitAudiences instance.");
        }
    }

    public void saveDefaultLanguageFiles() {
        FilenameFilter languageOnly;
        File[] files;
        ConfigurationManager configurationManager = this.getConfigurationManager();
        configurationManager.saveDefault("language.yml");
        File dataFolder = configurationManager.getBaseFolder();
        File languageFolder = new File(dataFolder, "language");
        if (languageFolder.exists() && (files = languageFolder.listFiles(languageOnly = (folder, fileName) -> fileName.endsWith(".lang.yml"))) != null && files.length > 0) {
            return;
        }
        boolean makeFolder = languageFolder.mkdirs();
        if (!makeFolder) {
            throw new IllegalStateException("Failed to create language folder at path '" + String.valueOf(languageFolder) + "'.");
        }
        for (String languageName : KNOWN_LANGUAGE_ARRAY) {
            String languageFileName = String.format(Locale.US, "language/%s.lang.yml", languageName);
            YamlConfiguration jarConfiguration = configurationManager.getInternal(languageFileName);
            if (jarConfiguration == null) continue;
            configurationManager.saveDefault(languageFileName);
        }
    }

    public void printDebug(@NotNull String message) {
        if (!this.debugLanguage) {
            return;
        }
        Logger logger = this.getLogger();
        logger.info("[Debug] [Language] " + message);
    }

    public void printMiniMessageDebug(@NotNull String message) {
        this.printDebug("[MiniMessage] " + message);
    }

    public void reloadLanguages() {
        this.reloadLanguageSettings();
        this.reloadLanguageFiles();
        int languageCount = this.languageMap.size();
        Logger logger = this.getLogger();
        logger.info("Successfully loaded " + languageCount + " language(s).");
    }

    private void reloadLanguageSettings() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        configurationManager.reload("language.yml");
        YamlConfiguration configuration = configurationManager.get("language.yml");
        this.defaultLanguageName = configuration.getString("default-locale", "en_us");
        this.consoleLanguageName = configuration.getString("console-locale", "en_us");
        this.forceDefaultLanguage = configuration.getBoolean("enforce-default-locale", false);
        this.debugLanguage = configuration.getBoolean("debug-mode", false);
        PluginManager pluginManager = Bukkit.getPluginManager();
        boolean configPlaceholderAPI = configuration.getBoolean("use-placeholder-api", false);
        boolean realPlaceholderAPI = pluginManager.isPluginEnabled("PlaceholderAPI");
        this.usePlaceholderAPI = configPlaceholderAPI && realPlaceholderAPI;
    }

    /*
     * WARNING - void declaration
     */
    private void reloadLanguageFiles() {
        void var8_10;
        this.defaultLanguage = null;
        this.consoleLanguage = null;
        this.languageMap.clear();
        File dataFolder = this.configurationManager.getBaseFolder();
        File languageFolder = new File(dataFolder, "language");
        if (!languageFolder.exists() || !languageFolder.isDirectory()) {
            return;
        }
        FilenameFilter filenameFilter = (folder, fileName) -> fileName.endsWith(".lang.yml");
        File[] fileArray = languageFolder.listFiles(filenameFilter);
        if (fileArray == null || fileArray.length < 1) {
            return;
        }
        ArrayList<Object> configurationList = new ArrayList<Object>();
        File[] fileArray2 = fileArray;
        int n = fileArray2.length;
        boolean bl = false;
        while (var8_10 < n) {
            File languageFile = fileArray2[var8_10];
            YamlConfiguration configuration = this.reloadLanguageFile(languageFile);
            if (configuration != null) {
                configurationList.add(configuration);
            }
            ++var8_10;
        }
        LanguageConfigurationComparator comparator = new LanguageConfigurationComparator();
        configurationList.sort(comparator);
        for (YamlConfiguration yamlConfiguration : configurationList) {
            LanguageConfiguration languageConfiguration = this.reloadLanguage(yamlConfiguration);
            String languageName = yamlConfiguration.getString("language-name");
            Language language = new Language(languageName, languageConfiguration);
            this.languageMap.put(languageName, language);
        }
    }

    @Nullable
    private YamlConfiguration reloadLanguageFile(@NotNull File file) {
        String languageFileName = file.getName();
        String languageName = languageFileName.replace(".lang.yml", "");
        try {
            YamlConfiguration configuration = new YamlConfiguration();
            configuration.load(file);
            configuration.set("language-name", (Object)languageName);
            return configuration;
        }
        catch (IOException | InvalidConfigurationException ex) {
            Logger logger = this.getLogger();
            logger.log(Level.WARNING, "An error occurred while loading a language file:", ex);
            return null;
        }
    }

    @NotNull
    private LanguageConfiguration reloadLanguage(@NotNull YamlConfiguration configuration) {
        String decimalFormatString;
        Language defaultLanguage;
        String languageName;
        Language language;
        MiniMessage miniMessage = this.getMiniMessage();
        LanguageConfiguration languageConfiguration = new LanguageConfiguration(configuration, miniMessage);
        String parentName = configuration.getString("parent");
        if (parentName != null && (language = this.getLanguage(parentName)) != null) {
            LanguageConfiguration parent = language.getConfiguration();
            languageConfiguration.setParent(parent);
        }
        if (!(languageName = configuration.getString("language-name")).equals(this.defaultLanguageName) && !languageConfiguration.getParent().isPresent() && (defaultLanguage = this.getDefaultLanguage()) != null) {
            LanguageConfiguration defaultLanguageConfiguration = defaultLanguage.getConfiguration();
            languageConfiguration.setParent(defaultLanguageConfiguration);
        }
        if ((decimalFormatString = configuration.getString("decimal-format")) != null && !decimalFormatString.isEmpty()) {
            DecimalFormat decimalFormat = new DecimalFormat(decimalFormatString);
            languageConfiguration.setDecimalFormat(decimalFormat);
        }
        return languageConfiguration;
    }

    @NotNull
    private String replacePlaceholderAPI(@Nullable CommandSender audience, @NotNull String message) {
        if (message.isEmpty()) {
            return "";
        }
        if (!(audience instanceof OfflinePlayer)) {
            return message;
        }
        OfflinePlayer player = (OfflinePlayer)audience;
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)message);
    }

    @NotNull
    private Component replacePlaceholderAPI(@Nullable CommandSender audience, @NotNull Component message) {
        if (!(audience instanceof OfflinePlayer)) {
            return message;
        }
        OfflinePlayer player = (OfflinePlayer)audience;
        TextReplacementConfig.Builder builder = TextReplacementConfig.builder();
        builder.match(PlaceholderAPI.getPlaceholderPattern());
        builder.replacement((matchResult, builderCopy) -> this.replacePlaceholderAPI(player, (MatchResult)matchResult));
        TextReplacementConfig textReplacementConfig = (TextReplacementConfig)builder.build();
        return message.replaceText(textReplacementConfig);
    }

    @NotNull
    private ComponentLike replacePlaceholderAPI(@NotNull OfflinePlayer player, @NotNull MatchResult matchResult) {
        String match = matchResult.group();
        String replaced = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)match);
        if (replaced.contains("\u00a7")) {
            LegacyComponentSerializer serializer = LegacyComponentSerializer.legacySection();
            return serializer.deserialize(replaced);
        }
        MiniMessage miniMessage = this.getMiniMessage();
        return miniMessage.deserialize(replaced);
    }

    @NotNull
    public String getMessageRaw(@Nullable CommandSender audience, @NotNull String key) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            return String.format(Locale.US, "{%s}", key);
        }
        LanguageConfiguration configuration = language.getConfiguration();
        return configuration.getRawMessage(key);
    }

    @NotNull
    public String getMessageString(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        String message = this.getMessageRaw(audience, key);
        if (this.usePlaceholderAPI) {
            message = this.replacePlaceholderAPI(audience, message);
        }
        for (Replacer replacer : replacerArray) {
            String target = replacer.getTarget();
            String replacement = replacer.getReplacementString();
            message = message.replace(target, replacement);
        }
        return message;
    }

    @NotNull
    public List<Component> getMessageList(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            return Collections.emptyList();
        }
        LanguageConfiguration configuration = language.getConfiguration();
        List<Component> messages = configuration.getMessageList(key);
        if (this.usePlaceholderAPI) {
            ArrayList<Component> newMessages = new ArrayList<Component>();
            for (Component message : messages) {
                message = this.replacePlaceholderAPI(audience, message);
                newMessages.add(message);
            }
            messages = newMessages;
        }
        for (Replacer replacer : replacerArray) {
            ArrayList<Component> newMessages = new ArrayList<Component>();
            TextReplacementConfig replacementConfig = replacer.asReplacementConfig();
            for (Component message : messages) {
                message = message.replaceText(replacementConfig);
                newMessages.add(message);
            }
            messages = newMessages;
        }
        return messages;
    }

    @NotNull
    public Component getMessage(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            return Component.text(String.format(Locale.US, "{%s}", key));
        }
        LanguageConfiguration configuration = language.getConfiguration();
        Component message = configuration.getMessage(key);
        if (this.usePlaceholderAPI) {
            message = this.replacePlaceholderAPI(audience, message);
        }
        for (Replacer replacer : replacerArray) {
            TextReplacementConfig replacementConfig = replacer.asReplacementConfig();
            message = message.replaceText(replacementConfig);
        }
        return message;
    }

    @NotNull
    public Component getMessageWithPrefix(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Component message = this.getMessage(audience, key, replacerArray);
        if (Component.empty().equals(message)) {
            return Component.empty();
        }
        Component prefix = this.getMessage(audience, "prefix", replacerArray);
        if (!Component.empty().equals(prefix)) {
            TextComponent.Builder builder = Component.text();
            builder.append(prefix);
            builder.append((Component)Component.space());
            builder.append(message);
            return builder.build();
        }
        return message;
    }

    @NotNull
    public ModifiableMessage getMessageModifiable(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            ModifiableMessage modifiableMessage = new ModifiableMessage();
            modifiableMessage.setMessage(Component.text(String.format(Locale.US, "{%s}", key)));
            modifiableMessage.setType(ModifiableMessageType.CHAT);
            return modifiableMessage;
        }
        LanguageConfiguration configuration = language.getConfiguration();
        ModifiableMessage modifiable = configuration.getModifiableMessage(key);
        Component message = modifiable.getMessage();
        if (this.usePlaceholderAPI) {
            message = this.replacePlaceholderAPI(audience, message);
        }
        for (Replacer replacer : replacerArray) {
            TextReplacementConfig replacementConfig = replacer.asReplacementConfig();
            message = message.replaceText(replacementConfig);
        }
        ModifiableMessage newModifiable = new ModifiableMessage();
        newModifiable.setType(modifiable.getType());
        newModifiable.setMessage(message);
        return newModifiable;
    }

    @NotNull
    public Title getTitle(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            return Title.title(Component.empty(), Component.empty());
        }
        LanguageConfiguration configuration = language.getConfiguration();
        Title title = configuration.getTitle(key);
        Component titleMessage = title.title();
        Component subtitleMessage = title.subtitle();
        if (this.usePlaceholderAPI) {
            titleMessage = this.replacePlaceholderAPI(audience, titleMessage);
            subtitleMessage = this.replacePlaceholderAPI(audience, subtitleMessage);
        }
        for (Replacer replacer : replacerArray) {
            TextReplacementConfig replacementConfig = replacer.asReplacementConfig();
            titleMessage = titleMessage.replaceText(replacementConfig);
            subtitleMessage = subtitleMessage.replaceText(replacementConfig);
        }
        Title.Times times = title.times();
        return Title.title(titleMessage, subtitleMessage, times);
    }

    @NotNull
    public PlayerListInfo getPlayerListInfo(@Nullable CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            return new PlayerListInfo();
        }
        LanguageConfiguration configuration = language.getConfiguration();
        PlayerListInfo playerListInfo = configuration.getPlayerListInfo(key);
        Component headerMessage = playerListInfo.getHeader();
        Component footerMessage = playerListInfo.getFooter();
        if (this.usePlaceholderAPI) {
            headerMessage = this.replacePlaceholderAPI(audience, headerMessage);
            footerMessage = this.replacePlaceholderAPI(audience, footerMessage);
        }
        for (Replacer replacer : replacerArray) {
            TextReplacementConfig replacementConfig = replacer.asReplacementConfig();
            headerMessage = headerMessage.replaceText(replacementConfig);
            footerMessage = footerMessage.replaceText(replacementConfig);
        }
        PlayerListInfo newPlayerListInfo = new PlayerListInfo();
        newPlayerListInfo.setHeader(headerMessage);
        newPlayerListInfo.setFooter(footerMessage);
        return newPlayerListInfo;
    }

    @Nullable
    public Sound getSound(@Nullable CommandSender audience, @NotNull String key) {
        Validate.notEmpty(key, "key must not be empty!");
        Language language = this.getLanguage(audience);
        if (language == null) {
            Logger logger = this.getLogger();
            logger.warning("There are no languages available.");
            return null;
        }
        LanguageConfiguration configuration = language.getConfiguration();
        return configuration.getSound(key);
    }

    @Nullable
    public Audience getAudience(CommandSender sender) {
        if (this.audienceProvider == null) {
            return null;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            UUID playerId = player.getUniqueId();
            return this.audienceProvider.player(playerId);
        }
        return this.audienceProvider.console();
    }

    private void sendNoAudience(@NotNull CommandSender sender, @NotNull Component message) {
        BaseComponent[] bungeeComponents = ComponentBungeeConverter.toBungee(message);
        CommandSender.Spigot spigot = sender.spigot();
        spigot.sendMessage(bungeeComponents);
    }

    public void sendMessage(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Component message = this.getMessage(audience, key, replacerArray);
        this.sendMessage(audience, message);
    }

    public void sendMessage(@NotNull CommandSender audience, @NotNull Component message) {
        if (Component.empty().equals(message)) {
            return;
        }
        Audience realAudience = this.getAudience(audience);
        if (realAudience == null) {
            this.sendNoAudience(audience, message);
            return;
        }
        realAudience.sendMessage(message);
    }

    public void sendMessageWithPrefix(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Component message = this.getMessageWithPrefix(audience, key, replacerArray);
        this.sendMessage(audience, message);
    }

    public void sendActionBar(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Component message = this.getMessage(audience, key, replacerArray);
        this.sendActionBar(audience, message);
    }

    public void sendActionBar(@NotNull CommandSender audience, @NotNull Component message) {
        if (Component.empty().equals(message)) {
            return;
        }
        Audience realAudience = this.getAudience(audience);
        if (realAudience == null) {
            return;
        }
        realAudience.sendActionBar(message);
    }

    public void sendModifiableMessage(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        ModifiableMessage modifiable = this.getMessageModifiable(audience, key, replacerArray);
        Component message = modifiable.getMessage();
        if (Component.empty().equals(message)) {
            return;
        }
        ModifiableMessageType type = modifiable.getType();
        switch (type) {
            case CHAT: {
                this.sendMessage(audience, message);
                break;
            }
            case ACTION_BAR: {
                this.sendActionBar(audience, message);
                break;
            }
        }
    }

    public void sendModifiableMessageWithPrefix(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        ModifiableMessage modifiable = this.getMessageModifiable(audience, key, replacerArray);
        Object message = modifiable.getMessage();
        if (Component.empty().equals(message)) {
            return;
        }
        ModifiableMessageType type = modifiable.getType();
        if (type == ModifiableMessageType.CHAT) {
            Component prefix = this.getMessage(audience, "prefix", new Replacer[0]);
            if (!Component.empty().equals(prefix)) {
                TextComponent.Builder builder = Component.text();
                builder.append(prefix);
                builder.append((Component)Component.space());
                builder.append((Component)message);
                message = builder.build();
            }
        }
        switch (type) {
            case CHAT: {
                this.sendMessage(audience, (Component)message);
                break;
            }
            case ACTION_BAR: {
                this.sendActionBar(audience, (Component)message);
                break;
            }
        }
    }

    public void sendTitle(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        Title title = this.getTitle(audience, key, replacerArray);
        this.sendTitle(audience, title);
    }

    public void sendTitle(@NotNull CommandSender audience, @NotNull Title title) {
        if (Component.empty().equals(title.title()) && Component.empty().equals(title.subtitle())) {
            return;
        }
        Audience realAudience = this.getAudience(audience);
        if (realAudience == null) {
            return;
        }
        realAudience.showTitle(title);
    }

    public void sendPlayerListInfo(@NotNull CommandSender audience, @NotNull String key, Replacer ... replacerArray) {
        PlayerListInfo playerListInfo = this.getPlayerListInfo(audience, key, replacerArray);
        this.sendPlayerListInfo(audience, playerListInfo);
    }

    public void sendPlayerListInfo(@NotNull CommandSender audience, @NotNull PlayerListInfo info) {
        Audience realAudience = this.getAudience(audience);
        if (realAudience == null) {
            return;
        }
        Component header = info.getHeader();
        Component footer = info.getFooter();
        realAudience.sendPlayerListHeaderAndFooter(header, footer);
    }

    public void sendSound(@NotNull CommandSender audience, @NotNull String key) {
        Sound sound = this.getSound(audience, key);
        if (sound == null) {
            return;
        }
        this.sendSound(audience, sound);
    }

    public void sendSound(@NotNull CommandSender audience, @NotNull Sound sound) {
        Audience realAudience = this.getAudience(audience);
        if (realAudience == null) {
            return;
        }
        realAudience.playSound(sound);
    }

    public void broadcastMessage(@NotNull String key, @Nullable String permission, Replacer ... replacerArray) {
        Collection onlinePlayerCollection = Bukkit.getOnlinePlayers();
        this.broadcastMessage(onlinePlayerCollection, key, permission, replacerArray);
    }

    public void broadcastMessage(@NotNull Iterable<? extends Player> players, @NotNull String key, @Nullable String permission, Replacer ... replacerArray) {
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        this.sendMessage((CommandSender)console, key, replacerArray);
        for (Player player : players) {
            if (!this.hasPermission(player, permission)) continue;
            this.sendMessage((CommandSender)player, key, replacerArray);
        }
    }

    private boolean hasPermission(@NotNull Player player, @Nullable String permission) {
        if (permission == null || permission.isEmpty()) {
            return true;
        }
        return player.hasPermission(permission);
    }

    @NotNull
    public DecimalFormat getDecimalFormat(@Nullable CommandSender sender) {
        Language language = this.getLanguage(sender);
        if (language == null) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.US);
            return new DecimalFormat("0.00", symbols);
        }
        LanguageConfiguration configuration = language.getConfiguration();
        return configuration.getDecimalFormat();
    }
}

