/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.language;

import com.github.sirblobman.api.language.custom.ModifiableMessage;
import com.github.sirblobman.api.language.custom.ModifiableMessageType;
import com.github.sirblobman.api.language.custom.PlayerListInfo;
import com.github.sirblobman.api.shaded.adventure.key.Key;
import com.github.sirblobman.api.shaded.adventure.sound.Sound;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.minimessage.MiniMessage;
import com.github.sirblobman.api.shaded.adventure.title.Title;
import com.github.sirblobman.api.shaded.adventure.util.Ticks;
import com.github.sirblobman.api.utility.ConfigurationHelper;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageConfiguration {
    private final YamlConfiguration configuration;
    private final MiniMessage miniMessage;
    private final Map<String, String> rawMessageMap;
    private final Map<String, Component> messageMap;
    private final Map<String, List<Component>> messageListMap;
    private final Map<String, ModifiableMessage> modifiableMessageMap;
    private final Map<String, Sound> soundMap;
    private final Map<String, Title> titleMap;
    private final Map<String, PlayerListInfo> playerListInfoMap;
    private LanguageConfiguration parent = null;
    private DecimalFormat decimalFormat;

    public LanguageConfiguration(@NotNull YamlConfiguration configuration, @NotNull MiniMessage miniMessage) {
        this.configuration = configuration;
        this.miniMessage = miniMessage;
        this.rawMessageMap = new ConcurrentHashMap<String, String>();
        this.messageMap = new ConcurrentHashMap<String, Component>();
        this.messageListMap = new ConcurrentHashMap<String, List<Component>>();
        this.modifiableMessageMap = new ConcurrentHashMap<String, ModifiableMessage>();
        this.soundMap = new ConcurrentHashMap<String, Sound>();
        this.titleMap = new ConcurrentHashMap<String, Title>();
        this.playerListInfoMap = new ConcurrentHashMap<String, PlayerListInfo>();
    }

    @NotNull
    public Optional<LanguageConfiguration> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public void setParent(@Nullable LanguageConfiguration parent) {
        this.parent = parent;
    }

    @NotNull
    public YamlConfiguration getOriginalConfiguration() {
        return this.configuration;
    }

    @NotNull
    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    @NotNull
    public String getRawMessage(@NotNull String path) {
        return this.rawMessageMap.computeIfAbsent(path, this::fetchRawMessage);
    }

    @NotNull
    private String fetchRawMessage(@NotNull String path) {
        YamlConfiguration originalConfiguration = this.getOriginalConfiguration();
        if (originalConfiguration.isList(path)) {
            List messageList = originalConfiguration.getStringList(path);
            return String.join((CharSequence)"\n", messageList);
        }
        String message = originalConfiguration.getString(path);
        if (message != null) {
            return message;
        }
        Optional<LanguageConfiguration> optionalParent = this.getParent();
        if (optionalParent.isPresent()) {
            LanguageConfiguration parent = optionalParent.get();
            return parent.getRawMessage(path);
        }
        return String.format(Locale.US, "{%s}", path);
    }

    @NotNull
    public Component getMessage(@NotNull String path) {
        return this.messageMap.computeIfAbsent(path, this::fetchMessage);
    }

    @NotNull
    private Component fetchMessage(@NotNull String path) {
        String rawMessage = this.getRawMessage(path);
        MiniMessage miniMessage = this.getMiniMessage();
        return miniMessage.deserialize(rawMessage);
    }

    @NotNull
    public List<Component> getMessageList(@NotNull String path) {
        return this.messageListMap.computeIfAbsent(path, this::fetchMessageList);
    }

    @NotNull
    private List<Component> fetchMessageList(@NotNull String path) {
        String baseMessage = this.getRawMessage(path);
        String[] rawMessages = baseMessage.split(Pattern.quote("\n"));
        ArrayList<Component> messages = new ArrayList<Component>();
        MiniMessage miniMessage = this.getMiniMessage();
        for (String rawMessage : rawMessages) {
            Object component = miniMessage.deserialize(rawMessage);
            messages.add((Component)component);
        }
        return messages;
    }

    @NotNull
    public ModifiableMessage getModifiableMessage(@NotNull String path) {
        return this.modifiableMessageMap.computeIfAbsent(path, this::fetchModifiableMessage);
    }

    @NotNull
    private ModifiableMessage fetchModifiableMessage(@NotNull String path) {
        YamlConfiguration originalConfiguration = this.getOriginalConfiguration();
        if (originalConfiguration.isConfigurationSection(path)) {
            Component message = this.getMessage(path + ".content");
            ModifiableMessage modifiableMessage = new ModifiableMessage();
            modifiableMessage.setMessage(message);
            String messageTypeName = originalConfiguration.getString(path + ".type");
            ModifiableMessageType messageType = ConfigurationHelper.parseEnum(ModifiableMessageType.class, messageTypeName, ModifiableMessageType.CHAT);
            modifiableMessage.setType(messageType);
            return modifiableMessage;
        }
        Optional<LanguageConfiguration> optionalParent = this.getParent();
        if (optionalParent.isPresent()) {
            LanguageConfiguration parent = optionalParent.get();
            return parent.getModifiableMessage(path);
        }
        Component message = this.getMessage(path);
        ModifiableMessage modifiableMessage = new ModifiableMessage();
        modifiableMessage.setMessage(message);
        return modifiableMessage;
    }

    @Nullable
    public Sound getSound(@NotNull String path) {
        return this.soundMap.computeIfAbsent(path, this::fetchSound);
    }

    @Nullable
    private Sound fetchSound(@NotNull String path) {
        YamlConfiguration originalConfiguration = this.getOriginalConfiguration();
        ConfigurationSection section = originalConfiguration.getConfigurationSection(path);
        if (section == null) {
            Optional<LanguageConfiguration> optionalParent = this.getParent();
            if (optionalParent.isPresent()) {
                LanguageConfiguration parent = optionalParent.get();
                return parent.getSound(path);
            }
            return null;
        }
        String soundKeyString = section.getString("sound");
        if (soundKeyString == null || soundKeyString.isEmpty()) {
            Optional<LanguageConfiguration> optionalParent = this.getParent();
            if (optionalParent.isPresent()) {
                LanguageConfiguration parent = optionalParent.get();
                return parent.getSound(path);
            }
            return null;
        }
        String categoryName = section.getString("category", "master");
        Sound.Source category = Sound.Source.valueOf(categoryName.toUpperCase(Locale.US));
        Key soundKey = Key.key(soundKeyString);
        float volume = (float)section.getDouble("volume", 1.0);
        float pitch = (float)section.getDouble("pitch", 1.0);
        Sound.Builder builder = Sound.sound();
        builder.type(soundKey);
        builder.source(category);
        builder.volume(volume);
        builder.pitch(pitch);
        return (Sound)builder.build();
    }

    @NotNull
    public Title getTitle(@NotNull String path) {
        return this.titleMap.computeIfAbsent(path, this::fetchTitle);
    }

    @NotNull
    private Title fetchTitle(@NotNull String path) {
        YamlConfiguration originalConfiguration = this.getOriginalConfiguration();
        ConfigurationSection section = originalConfiguration.getConfigurationSection(path);
        if (section == null) {
            Optional<LanguageConfiguration> optionalParent = this.getParent();
            if (optionalParent.isPresent()) {
                LanguageConfiguration parent = optionalParent.get();
                return parent.getTitle(path);
            }
            return Title.title(Component.empty(), Component.empty());
        }
        int fadeInTicks = section.getInt("fade-in", 10);
        int stayTicks = section.getInt("stay", 70);
        int fadeOutTicks = section.getInt("fade-out", 20);
        Title.Times times = Title.Times.times(this.ticks(fadeInTicks), this.ticks(stayTicks), this.ticks(fadeOutTicks));
        Component titleMessage = this.getMessage(path + ".title");
        Component subtitleMessage = this.getMessage(path + ".subtitle");
        return Title.title(titleMessage, subtitleMessage, times);
    }

    @NotNull
    private Duration ticks(int ticks) {
        return Ticks.duration(ticks);
    }

    @NotNull
    public PlayerListInfo getPlayerListInfo(@NotNull String path) {
        return this.playerListInfoMap.computeIfAbsent(path, this::fetchPlayerListInfo);
    }

    @NotNull
    private PlayerListInfo fetchPlayerListInfo(@NotNull String path) {
        YamlConfiguration originalConfiguration = this.getOriginalConfiguration();
        ConfigurationSection section = originalConfiguration.getConfigurationSection(path);
        if (section == null) {
            Optional<LanguageConfiguration> optionalParent = this.getParent();
            if (optionalParent.isPresent()) {
                LanguageConfiguration parent = optionalParent.get();
                return parent.getPlayerListInfo(path);
            }
            return new PlayerListInfo();
        }
        PlayerListInfo playerListHeader = new PlayerListInfo();
        Component header = this.getMessage(path + ".header");
        Component footer = this.getMessage(path + ".footer");
        playerListHeader.setHeader(header);
        playerListHeader.setFooter(footer);
        return playerListHeader;
    }

    @NotNull
    public DecimalFormat getDecimalFormat() {
        if (this.decimalFormat != null) {
            return this.decimalFormat;
        }
        Optional<LanguageConfiguration> optionalParent = this.getParent();
        if (optionalParent.isPresent()) {
            LanguageConfiguration parent = optionalParent.get();
            return parent.getDecimalFormat();
        }
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.US);
        this.decimalFormat = new DecimalFormat("0.00", symbols);
        return this.decimalFormat;
    }

    public void setDecimalFormat(@NotNull DecimalFormat format) {
        this.decimalFormat = format;
    }
}

