/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.language;

import com.github.sirblobman.api.language.LanguageConfiguration;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public final class Language {
    private final String languageName;
    private final LanguageConfiguration configuration;
    private final Locale javaLocale;

    public Language(@NotNull String languageName, @NotNull LanguageConfiguration configuration) {
        this.languageName = languageName;
        this.configuration = configuration;
        Locale javaLocale = Locale.forLanguageTag(languageName);
        this.javaLocale = javaLocale == null ? Locale.US : javaLocale;
    }

    @NotNull
    public String getLanguageName() {
        return this.languageName;
    }

    @NotNull
    public LanguageConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public Locale getJavaLocale() {
        return this.javaLocale;
    }
}

