/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.language;

import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.TextComponent;
import com.github.sirblobman.api.shaded.adventure.text.format.TextDecoration;
import com.github.sirblobman.api.shaded.adventure.text.serializer.gson.GsonComponentSerializer;
import com.github.sirblobman.api.shaded.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.github.sirblobman.api.shaded.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.github.sirblobman.api.utility.MessageUtility;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ComponentHelper {
    @NotNull
    public static LegacyComponentSerializer getLegacySerializer() {
        return LegacyComponentSerializer.legacySection();
    }

    @NotNull
    public static PlainTextComponentSerializer getPlainSerializer() {
        return PlainTextComponentSerializer.plainText();
    }

    @NotNull
    public static GsonComponentSerializer getGsonSerializer() {
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 16) {
            return GsonComponentSerializer.colorDownsamplingGson();
        }
        return GsonComponentSerializer.gson();
    }

    @NotNull
    public static Component toComponent(@NotNull String legacy) {
        String colored = MessageUtility.color(legacy);
        LegacyComponentSerializer serializer = ComponentHelper.getLegacySerializer();
        return serializer.deserialize(colored);
    }

    @NotNull
    public static String toLegacy(@NotNull Component component) {
        LegacyComponentSerializer serializer = ComponentHelper.getLegacySerializer();
        return serializer.serialize(component);
    }

    @NotNull
    public static String toPlain(@NotNull Component component) {
        PlainTextComponentSerializer serializer = ComponentHelper.getPlainSerializer();
        return serializer.serialize(component);
    }

    @NotNull
    public static String toGson(@NotNull Component component) {
        GsonComponentSerializer serializer = ComponentHelper.getGsonSerializer();
        return (String)serializer.serialize(component);
    }

    @NotNull
    public static Component wrapNoItalics(@NotNull Component component) {
        TextComponent.Builder builder = Component.text();
        builder.decoration(TextDecoration.ITALIC, false);
        builder.append(component);
        return builder.build();
    }

    @NotNull
    public static List<Component> wrapNoItalics(@NotNull Iterable<Component> components) {
        ArrayList<Component> newList = new ArrayList<Component>();
        for (Component component : components) {
            Component noItalics = ComponentHelper.wrapNoItalics(component);
            newList.add(noItalics);
        }
        return newList;
    }
}

