/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.item;

import com.github.sirblobman.api.item.ItemBuilder;
import com.github.sirblobman.api.nms.HeadHandler;
import com.github.sirblobman.api.utility.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class SkullBuilder {
    private final HeadHandler headHandler;

    public SkullBuilder(HeadHandler headHandler) {
        this.headHandler = Validate.notNull(headHandler, "headHandler must not be null!");
    }

    @NotNull
    public HeadHandler getHeadHandler() {
        return this.headHandler;
    }

    public ItemBuilder withTextureUrl(@NotNull String url) {
        HeadHandler headHandler = this.getHeadHandler();
        ItemStack playerHead = headHandler.getTextureHead(url);
        return new ItemBuilder(playerHead);
    }

    public ItemBuilder withTextureBase64(@NotNull String base64) {
        HeadHandler headHandler = this.getHeadHandler();
        ItemStack playerHead = headHandler.getBase64Head(base64);
        return new ItemBuilder(playerHead);
    }

    public ItemBuilder withOwner(@NotNull String playerName) {
        HeadHandler headHandler = this.getHeadHandler();
        ItemStack playerHead = headHandler.getPlayerHead(playerName);
        return new ItemBuilder(playerHead);
    }

    public ItemBuilder withOwner(@NotNull OfflinePlayer player) {
        HeadHandler headHandler = this.getHeadHandler();
        ItemStack playerHead = headHandler.getPlayerHead(player);
        return new ItemBuilder(playerHead);
    }
}

