/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.item;

import com.github.sirblobman.api.item.BottleType;
import com.github.sirblobman.api.item.ItemBuilder;
import org.bukkit.Color;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public final class PotionBuilder
extends ItemBuilder {
    public PotionBuilder(@NotNull BottleType bottleType) {
        super(bottleType.getMaterial());
    }

    @NotNull
    public PotionBuilder withMainEffect(@NotNull PotionType potionType, boolean extended, boolean upgraded) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        PotionData potionData = new PotionData(potionType, extended, upgraded);
        potionMeta.setBasePotionData(potionData);
        return (PotionBuilder)this.withItemMeta((ItemMeta)potionMeta);
    }

    @NotNull
    public PotionBuilder withExtraEffect(@NotNull PotionEffect potionEffect) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.addCustomEffect(potionEffect, true);
        return (PotionBuilder)this.withItemMeta((ItemMeta)potionMeta);
    }

    @NotNull
    public PotionBuilder withColor(@NotNull Color color) {
        ItemMeta itemMeta = this.getItemMeta();
        if (!(itemMeta instanceof PotionMeta)) {
            return this;
        }
        PotionMeta potionMeta = (PotionMeta)itemMeta;
        potionMeta.setColor(color);
        return (PotionBuilder)this.withItemMeta((ItemMeta)potionMeta);
    }

    @NotNull
    public PotionBuilder withColor(int red, int green, int blue) {
        Color color = Color.fromRGB((int)red, (int)green, (int)blue);
        return this.withColor(color);
    }

    @NotNull
    public PotionBuilder withColor(int rgb) {
        Color color = Color.fromRGB((int)rgb);
        return this.withColor(color);
    }
}

