/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.item;

import com.github.sirblobman.api.item.ArmorMaterialType;
import com.github.sirblobman.api.item.ArmorType;
import com.github.sirblobman.api.item.ItemBuilder;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;

public final class LeatherArmorBuilder
extends ItemBuilder {
    public LeatherArmorBuilder(@NotNull ArmorType armorType) {
        super(armorType.getArmorMaterial(ArmorMaterialType.LEATHER));
    }

    @NotNull
    public LeatherArmorBuilder withColor(@NotNull Color color) {
        ItemStack finalItem = this.getFinalItem();
        ItemMeta itemMeta = finalItem.getItemMeta();
        if (!(itemMeta instanceof LeatherArmorMeta)) {
            return this;
        }
        LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
        leatherArmorMeta.setColor(color);
        return (LeatherArmorBuilder)this.withItemMeta(itemMeta);
    }

    @NotNull
    public LeatherArmorBuilder withColor(int red, int green, int blue) {
        Color color = Color.fromRGB((int)red, (int)green, (int)blue);
        return this.withColor(color);
    }

    @NotNull
    public LeatherArmorBuilder withColor(int rgb) {
        Color color = Color.fromRGB((int)rgb);
        return this.withColor(color);
    }
}

