/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.item;

import com.github.sirblobman.api.item.ArmorType;
import com.github.sirblobman.api.item.BottleType;
import com.github.sirblobman.api.item.ItemBuilder;
import com.github.sirblobman.api.item.LeatherArmorBuilder;
import com.github.sirblobman.api.item.PotionBuilder;
import com.github.sirblobman.api.item.SkullBuilder;
import com.github.sirblobman.api.nms.HeadHandler;
import com.github.sirblobman.api.nms.MultiVersionHandler;
import com.github.sirblobman.api.plugin.IMultiVersionPlugin;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import com.github.sirblobman.api.utility.ConfigurationHelper;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemLoader {
    @Nullable
    public static ItemStack loadItemStack(@NotNull IMultiVersionPlugin plugin, @NotNull ConfigurationSection section, @NotNull String path) {
        if (section.isItemStack(path)) {
            return section.getItemStack(path);
        }
        ConfigurationSection subSection = section.getConfigurationSection(path);
        if (subSection == null) {
            return null;
        }
        return ItemLoader.loadItemStack(plugin, subSection);
    }

    @Nullable
    public static ItemStack loadItemStack(@NotNull IMultiVersionPlugin plugin, @NotNull ConfigurationSection section) {
        String materialName = section.getString("material");
        if (materialName == null) {
            return null;
        }
        Optional<XMaterial> optionalMaterial = XMaterial.matchXMaterial(materialName);
        XMaterial material = optionalMaterial.orElse(XMaterial.BARRIER);
        ItemBuilder builder = new ItemBuilder(material);
        builder = ItemLoader.checkPotion(material, builder, section);
        builder = ItemLoader.checkLeatherArmor(material, builder, section);
        builder = ItemLoader.checkSkull(plugin, material, builder, section);
        ItemLoader.checkNameAndLore(plugin, builder, section);
        builder = ItemLoader.checkEnchantments(builder, section);
        int amount = section.getInt("quantity", 1);
        builder = builder.withAmount(amount);
        int damage = section.getInt("damage", 0);
        builder = builder.withDamage(damage);
        if (section.isSet("model")) {
            int model = section.getInt("model");
            builder = builder.withModel(model);
        }
        if (section.getBoolean("glowing", false)) {
            builder = builder.withGlowing();
        }
        return builder.build();
    }

    @NotNull
    private static ItemBuilder checkPotion(@NotNull XMaterial material, @NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        Color color;
        ConfigurationSection extraEffects;
        BottleType bottleType = BottleType.getByMaterial(material);
        if (bottleType == null) {
            return builder;
        }
        ConfigurationSection sectionPotionData = section.getConfigurationSection("potion-data");
        if (sectionPotionData == null) {
            return builder;
        }
        PotionBuilder potionBuilder = new PotionBuilder(bottleType);
        ConfigurationSection basePotion = sectionPotionData.getConfigurationSection("base-potion");
        if (basePotion != null) {
            String potionTypeName = basePotion.getString("type");
            if (potionTypeName == null) {
                potionTypeName = "WATER";
            }
            PotionType potionType = ConfigurationHelper.parseEnum(PotionType.class, potionTypeName, PotionType.WATER);
            boolean extended = basePotion.getBoolean("extended", false);
            boolean upgraded = basePotion.getBoolean("upgraded", false);
            potionBuilder = potionBuilder.withMainEffect(potionType, extended, upgraded);
        }
        if ((extraEffects = sectionPotionData.getConfigurationSection("extra-effects")) != null) {
            List<PotionEffect> potionEffectList = ItemLoader.parsePotionEffects(extraEffects);
            for (PotionEffect effect : potionEffectList) {
                potionBuilder = potionBuilder.withExtraEffect(effect);
            }
        }
        if ((color = ItemLoader.parseColor(section)) != null) {
            potionBuilder = potionBuilder.withColor(color);
        }
        return potionBuilder;
    }

    @NotNull
    private static ItemBuilder checkLeatherArmor(@NotNull XMaterial material, @NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        ArmorType armorType = material == XMaterial.LEATHER_HELMET ? ArmorType.HELMET : (material == XMaterial.LEATHER_CHESTPLATE ? ArmorType.CHESTPLATE : (material == XMaterial.LEATHER_LEGGINGS ? ArmorType.LEGGINGS : (material == XMaterial.LEATHER_BOOTS ? ArmorType.BOOTS : null)));
        if (armorType == null) {
            return builder;
        }
        LeatherArmorBuilder leatherArmorBuilder = new LeatherArmorBuilder(armorType);
        Color color = ItemLoader.parseColor(section);
        if (color != null) {
            leatherArmorBuilder = leatherArmorBuilder.withColor(color);
        }
        return leatherArmorBuilder;
    }

    @NotNull
    private static ItemBuilder checkSkull(@NotNull IMultiVersionPlugin plugin, @NotNull XMaterial material, @NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        if (material != XMaterial.PLAYER_HEAD) {
            return builder;
        }
        MultiVersionHandler multiVersionHandler = plugin.getMultiVersionHandler();
        HeadHandler headHandler = multiVersionHandler.getHeadHandler();
        SkullBuilder skullBuilder = new SkullBuilder(headHandler);
        String texture = section.getString("texture");
        if (texture != null) {
            return skullBuilder.withTextureBase64(texture);
        }
        String textureUrl = section.getString("texture-url");
        if (textureUrl != null) {
            return skullBuilder.withTextureUrl(textureUrl);
        }
        String username = section.getString("skull-owner");
        if (username != null) {
            return skullBuilder.withOwner(username);
        }
        return builder;
    }

    @NotNull
    private static ItemBuilder checkNameAndLore(@NotNull IMultiVersionPlugin plugin, @NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        ItemLoader.checkDisplayName(plugin, builder, section);
        ItemLoader.checkLore(plugin, builder, section);
        return builder;
    }

    @NotNull
    private static ItemBuilder checkDisplayName(@NotNull IMultiVersionPlugin plugin, @NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        return builder;
    }

    @NotNull
    private static ItemBuilder checkLore(@NotNull IMultiVersionPlugin plugin, @NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        return builder;
    }

    @NotNull
    private static ItemBuilder checkEnchantments(@NotNull ItemBuilder builder, @NotNull ConfigurationSection section) {
        ConfigurationSection sectionEnchantments = section.getConfigurationSection("enchantments");
        if (sectionEnchantments == null) {
            return builder;
        }
        Set enchantmentNameSet = sectionEnchantments.getKeys(false);
        for (String enchantmentName : enchantmentNameSet) {
            Enchantment enchantment = Enchantment.getByName((String)enchantmentName);
            if (enchantment == null) continue;
            int level = sectionEnchantments.getInt(enchantmentName, 1);
            builder = builder.withEnchantment(enchantment, level);
        }
        return builder;
    }

    @NotNull
    private static List<PotionEffect> parsePotionEffects(@NotNull ConfigurationSection section) {
        ArrayList<PotionEffect> potionEffectList = new ArrayList<PotionEffect>();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            PotionEffect effect;
            ConfigurationSection subSection = section.getConfigurationSection(key);
            if (subSection == null || (effect = ItemLoader.parsePotionEffect(subSection)) == null) continue;
            potionEffectList.add(effect);
        }
        return Collections.unmodifiableList(potionEffectList);
    }

    @Nullable
    private static PotionEffect parsePotionEffect(@NotNull ConfigurationSection section) {
        String typeName = section.getString("type");
        if (typeName == null) {
            return null;
        }
        PotionEffectType type = PotionEffectType.getByName((String)typeName);
        if (type == null) {
            return null;
        }
        int duration = section.getInt("duration", 10);
        int amplifier = section.getInt("amplifier", 0);
        boolean ambient = section.getBoolean("ambient", false);
        boolean particles = section.getBoolean("particles", true);
        boolean icon = section.getBoolean("icon", true);
        int minorVersion = VersionUtility.getMinorVersion();
        PotionEffect effect = minorVersion < 13 ? new PotionEffect(type, duration, amplifier, ambient, particles) : new PotionEffect(type, duration, amplifier, ambient, particles, icon);
        return effect;
    }

    @Nullable
    private static Color parseColor(@NotNull ConfigurationSection section) {
        if (section.isConfigurationSection("color")) {
            ConfigurationSection color = section.getConfigurationSection("color");
            if (color == null) {
                return null;
            }
            int red = color.getInt("red", 0);
            int green = color.getInt("green", 0);
            int blue = color.getInt("blue", 0);
            return Color.fromRGB((int)red, (int)green, (int)blue);
        }
        if (section.isInt("color")) {
            int color = section.getInt("color");
            return Color.fromRGB((int)color);
        }
        if (section.isString("color")) {
            String colorString = section.getString("color");
            if (colorString == null || !colorString.startsWith("#") || colorString.length() != 7) {
                return null;
            }
            String sub = colorString.substring(1);
            try {
                int color = Integer.parseInt(sub, 16);
                return Color.fromRGB((int)color);
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }
}

