/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.item;

import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.xseries.XEnchantment;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import com.github.sirblobman.api.utility.Validate;
import com.github.sirblobman.api.utility.VersionUtility;
import com.github.sirblobman.api.utility.paper.PaperChecker;
import com.github.sirblobman.api.utility.paper.PaperHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    protected ItemStack finalItem;

    public ItemBuilder(@NotNull ItemStack item) {
        this.finalItem = item.clone();
    }

    public ItemBuilder(@NotNull Material material) {
        this(new ItemStack(material, 1));
    }

    public ItemBuilder(@NotNull XMaterial material) {
        this(Validate.notNull(material.parseItem(), "material has an invalid item!"));
    }

    @NotNull
    protected final ItemStack getFinalItem() {
        return this.finalItem;
    }

    @NotNull
    public ItemStack build() {
        ItemStack finalItem = this.getFinalItem();
        return finalItem.clone();
    }

    @NotNull
    public ItemBuilder withMaterial(@NotNull Material material) {
        this.finalItem.setType(material);
        return this;
    }

    @NotNull
    public ItemBuilder withMaterial(@NotNull XMaterial material) {
        Material bukkitMaterial = material.get();
        return bukkitMaterial == null ? this : this.withMaterial(bukkitMaterial);
    }

    @NotNull
    public ItemBuilder withAmount(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("amount cannot be less than 0!");
        }
        int maxStackSize = this.finalItem.getMaxStackSize();
        if (maxStackSize != -1 && amount > maxStackSize) {
            XMaterial material = XMaterial.matchXMaterial(this.finalItem);
            String messageFormat = "Tried to set amount to %s on material %s with max amount %s.";
            throw new IllegalArgumentException(String.format(messageFormat, amount, material, maxStackSize));
        }
        this.finalItem.setAmount(amount);
        return this;
    }

    @NotNull
    public ItemBuilder withMaxAmount() {
        int maxAmount = this.finalItem.getMaxStackSize();
        if (maxAmount == -1) {
            maxAmount = 64;
        }
        return this.withAmount(maxAmount);
    }

    @Nullable
    public ItemMeta getItemMeta() {
        return this.finalItem.getItemMeta();
    }

    @NotNull
    public ItemBuilder withItemMeta(@Nullable ItemMeta itemMeta) {
        this.finalItem.setItemMeta(itemMeta);
        return this;
    }

    @NotNull
    public ItemBuilder withDamage(int damage) {
        int minorVersion = VersionUtility.getMinorVersion();
        return minorVersion < 13 ? this.withLegacyDamage((short)damage) : this.withModernDurability(damage);
    }

    @NotNull
    private ItemBuilder withLegacyDamage(short damage) {
        this.finalItem.setDurability(damage);
        return this;
    }

    @NotNull
    private ItemBuilder withModernDurability(int damage) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta instanceof Damageable) {
            ((Damageable)itemMeta).setDamage(damage);
            return this.withItemMeta(itemMeta);
        }
        return this;
    }

    @NotNull
    public ItemBuilder withModel(@Nullable Integer model) {
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 14) {
            return this;
        }
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            return this;
        }
        itemMeta.setCustomModelData(model);
        return this.withItemMeta(itemMeta);
    }

    @NotNull
    public ItemBuilder withName(@Nullable String name) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            return this;
        }
        itemMeta.setDisplayName(name);
        return this.withItemMeta(itemMeta);
    }

    @NotNull
    public ItemBuilder withName(@NotNull ItemHandler itemHandler, @Nullable Component name) {
        if (name == null) {
            return this.withName(null);
        }
        if (PaperChecker.hasNativeComponentSupport()) {
            PaperHelper.setDisplayName(this.finalItem, name);
        } else {
            this.finalItem = itemHandler.setDisplayName(this.finalItem, name);
        }
        return this;
    }

    @NotNull
    public ItemBuilder withLore(@Nullable List<String> loreList) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            return this;
        }
        itemMeta.setLore(loreList);
        return this.withItemMeta(itemMeta);
    }

    @NotNull
    public ItemBuilder withLore(String ... loreArray) {
        ArrayList<String> loreList = new ArrayList<String>();
        Collections.addAll(loreList, loreArray);
        return this.withLore(loreList);
    }

    @NotNull
    public ItemBuilder withLore(@NotNull ItemHandler itemHandler, @Nullable List<Component> lore) {
        if (lore == null) {
            return this.withLore((List<String>)null);
        }
        if (PaperChecker.hasNativeComponentSupport()) {
            PaperHelper.setLore(this.finalItem, lore);
        } else {
            this.finalItem = itemHandler.setLore(this.finalItem, lore);
        }
        return this;
    }

    @NotNull
    public ItemBuilder withLore(@NotNull ItemHandler itemHandler, Component ... lines) {
        ArrayList<Component> lore = new ArrayList<Component>();
        Collections.addAll(lore, lines);
        return this.withLore(itemHandler, lore);
    }

    @NotNull
    public ItemBuilder appendLore(@NotNull String line) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null || !itemMeta.hasLore()) {
            return this.withLore(line);
        }
        List oldLore = itemMeta.getLore();
        ArrayList<String> newLore = oldLore == null ? new ArrayList<String>() : new ArrayList(oldLore);
        newLore.add(line);
        itemMeta.setLore(newLore);
        return this.withItemMeta(itemMeta);
    }

    @NotNull
    public ItemBuilder appendLore(@NotNull ItemHandler itemHandler, @NotNull Component line) {
        boolean paper = PaperChecker.hasNativeComponentSupport();
        return paper ? this.appendLorePaper(line) : this.appendLoreSpigot(itemHandler, line);
    }

    @NotNull
    private ItemBuilder appendLorePaper(@NotNull Component line) {
        List<Component> lore = PaperHelper.getLore(this.finalItem);
        lore = lore == null ? new ArrayList<Component>() : new ArrayList<Component>(lore);
        lore.add(line);
        PaperHelper.setLore(this.finalItem, lore);
        return this;
    }

    @NotNull
    private ItemBuilder appendLoreSpigot(@NotNull ItemHandler itemHandler, @NotNull Component line) {
        List<Component> lore = itemHandler.getLore(this.finalItem);
        lore = lore == null ? new ArrayList<Component>() : new ArrayList<Component>(lore);
        lore.add(line);
        this.finalItem = itemHandler.setLore(this.finalItem, lore);
        return this;
    }

    @NotNull
    public ItemBuilder withEnchantment(@NotNull Enchantment enchantment, int level) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            return this;
        }
        itemMeta.addEnchant(enchantment, level, true);
        return this.withItemMeta(itemMeta);
    }

    @NotNull
    public ItemBuilder withFlags(ItemFlag ... flagArray) {
        ItemMeta itemMeta = this.getItemMeta();
        if (itemMeta == null) {
            return this;
        }
        itemMeta.addItemFlags(flagArray);
        return this.withItemMeta(itemMeta);
    }

    @NotNull
    public ItemBuilder withGlowing() {
        Enchantment enchantment = (Enchantment)XEnchantment.LUCK_OF_THE_SEA.get();
        if (enchantment == null) {
            throw new IllegalStateException("The enchantment 'Luck of the Sea' does not exist.");
        }
        return this.withEnchantment(enchantment, 1).withFlags(ItemFlag.HIDE_ENCHANTS);
    }
}

