/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.item;

import com.github.sirblobman.api.item.ArmorType;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArmorMaterialType
extends Enum<ArmorMaterialType> {
    public static final /* enum */ ArmorMaterialType LEATHER;
    public static final /* enum */ ArmorMaterialType IRON;
    public static final /* enum */ ArmorMaterialType GOLDEN;
    public static final /* enum */ ArmorMaterialType CHAINMAIL;
    public static final /* enum */ ArmorMaterialType DIAMOND;
    public static final /* enum */ ArmorMaterialType NETHERITE;
    private static final Map<XMaterial, ArmorMaterialType> BY_MATERIAL;
    private final XMaterial helmet;
    private final XMaterial chestplate;
    private final XMaterial leggings;
    private final XMaterial boots;
    private static final /* synthetic */ ArmorMaterialType[] $VALUES;

    public static ArmorMaterialType[] values() {
        return (ArmorMaterialType[])$VALUES.clone();
    }

    public static ArmorMaterialType valueOf(String name) {
        return Enum.valueOf(ArmorMaterialType.class, name);
    }

    @Nullable
    public static ArmorMaterialType getByMaterial(@NotNull XMaterial material) {
        return BY_MATERIAL.get(material);
    }

    private ArmorMaterialType(@NotNull XMaterial helmet, @NotNull XMaterial chestplate, XMaterial leggings, XMaterial boots) {
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
    }

    @NotNull
    public XMaterial getHelmet() {
        return this.helmet;
    }

    @NotNull
    public XMaterial getChestplate() {
        return this.chestplate;
    }

    @NotNull
    public XMaterial getLeggings() {
        return this.leggings;
    }

    @NotNull
    public XMaterial getBoots() {
        return this.boots;
    }

    @NotNull
    public XMaterial getArmorMaterial(@NotNull ArmorType armorType) {
        switch (armorType) {
            case HELMET: {
                return this.getHelmet();
            }
            case CHESTPLATE: {
                return this.getChestplate();
            }
            case LEGGINGS: {
                return this.getLeggings();
            }
            case BOOTS: {
                return this.getBoots();
            }
        }
        throw new IllegalStateException("Unknown armorType '" + String.valueOf((Object)armorType) + "'.");
    }

    private static /* synthetic */ ArmorMaterialType[] $values() {
        return new ArmorMaterialType[]{LEATHER, IRON, GOLDEN, CHAINMAIL, DIAMOND, NETHERITE};
    }

    static {
        ArmorMaterialType[] values;
        LEATHER = new ArmorMaterialType(XMaterial.LEATHER_HELMET, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS);
        IRON = new ArmorMaterialType(XMaterial.IRON_HELMET, XMaterial.IRON_CHESTPLATE, XMaterial.IRON_LEGGINGS, XMaterial.IRON_BOOTS);
        GOLDEN = new ArmorMaterialType(XMaterial.GOLDEN_HELMET, XMaterial.GOLDEN_CHESTPLATE, XMaterial.GOLDEN_LEGGINGS, XMaterial.GOLDEN_BOOTS);
        CHAINMAIL = new ArmorMaterialType(XMaterial.CHAINMAIL_HELMET, XMaterial.CHAINMAIL_CHESTPLATE, XMaterial.CHAINMAIL_LEGGINGS, XMaterial.CHAINMAIL_BOOTS);
        DIAMOND = new ArmorMaterialType(XMaterial.DIAMOND_HELMET, XMaterial.DIAMOND_CHESTPLATE, XMaterial.DIAMOND_LEGGINGS, XMaterial.DIAMOND_BOOTS);
        NETHERITE = new ArmorMaterialType(XMaterial.NETHERITE_HELMET, XMaterial.NETHERITE_CHESTPLATE, XMaterial.NETHERITE_LEGGINGS, XMaterial.NETHERITE_BOOTS);
        $VALUES = ArmorMaterialType.$values();
        BY_MATERIAL = new EnumMap<XMaterial, ArmorMaterialType>(XMaterial.class);
        for (ArmorMaterialType type : values = ArmorMaterialType.values()) {
            XMaterial helmet = type.getHelmet();
            XMaterial chestplate = type.getChestplate();
            XMaterial leggings = type.getLeggings();
            XMaterial boots = type.getBoots();
            BY_MATERIAL.put(helmet, type);
            BY_MATERIAL.put(chestplate, type);
            BY_MATERIAL.put(leggings, type);
            BY_MATERIAL.put(boots, type);
        }
    }
}

