/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.folia.task;

import com.github.sirblobman.api.folia.task.WrappedTask;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public final class WrappedBukkitTask
extends WrappedTask {
    private static final boolean LEGACY_CANCEL;
    private final BukkitTask task;

    public WrappedBukkitTask(@NotNull BukkitTask task) {
        super(task.getOwner());
        this.task = task;
    }

    @NotNull
    private BukkitTask getTask() {
        return this.task;
    }

    @Override
    public void cancel() {
        if (LEGACY_CANCEL) {
            this.cancelLegacy();
        } else {
            this.getTask().cancel();
        }
    }

    @Override
    public boolean isCancelled() {
        if (LEGACY_CANCEL) {
            return this.isCancelledLegacy();
        }
        return this.getTask().isCancelled();
    }

    private boolean isCancelledLegacy() {
        int taskId = this.getTask().getTaskId();
        BukkitScheduler scheduler = Bukkit.getScheduler();
        return !scheduler.isQueued(taskId) && !scheduler.isCurrentlyRunning(taskId);
    }

    private void cancelLegacy() {
        int taskId = this.getTask().getTaskId();
        BukkitScheduler scheduler = Bukkit.getScheduler();
        scheduler.cancelTask(taskId);
    }

    static {
        boolean legacy;
        try {
            Class<?> class_BukkitTask = Class.forName("org.bukkit.scheduler.BukkitTask");
            class_BukkitTask.getMethod("isCancelled", new Class[0]);
            class_BukkitTask.getMethod("cancel", new Class[0]);
            legacy = false;
        }
        catch (ReflectiveOperationException ex) {
            legacy = true;
        }
        LEGACY_CANCEL = legacy;
    }
}

