/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.folia.scheduler;

import com.github.sirblobman.api.folia.details.AbstractTaskDetails;
import com.github.sirblobman.api.folia.details.EntityTaskDetails;
import com.github.sirblobman.api.folia.details.LocationTaskDetails;
import com.github.sirblobman.api.folia.details.TaskDetails;
import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.folia.task.WrappedFoliaTask;
import com.github.sirblobman.api.folia.task.WrappedTask;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FoliaTaskScheduler
extends TaskScheduler {
    public FoliaTaskScheduler(@NotNull Plugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public WrappedTask scheduleTask(@NotNull TaskDetails details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimer(details, realDelay, (long)period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayed(details, (long)delay);
        }
        return this.scheduleTaskSingle(details);
    }

    @Override
    @NotNull
    public WrappedTask scheduleAsyncTask(@NotNull TaskDetails details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimerAsync(details, realDelay, period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayedAsync(details, delay);
        }
        return this.scheduleTaskSingleAsync(details);
    }

    @Override
    @NotNull
    public <E extends Entity> WrappedTask scheduleEntityTask(EntityTaskDetails<E> details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimer(details, realDelay, (long)period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayed(details, (long)delay);
        }
        return this.scheduleTaskSingle(details);
    }

    @Override
    @NotNull
    public WrappedTask scheduleLocationTask(LocationTaskDetails details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimer(details, realDelay, (long)period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayed(details, (long)delay);
        }
        return this.scheduleTaskSingle(details);
    }

    @NotNull
    private Server getServer() {
        Plugin plugin = this.getPlugin();
        return plugin.getServer();
    }

    @NotNull
    private GlobalRegionScheduler getGlobalRegionScheduler() {
        Server server = this.getServer();
        return server.getGlobalRegionScheduler();
    }

    @NotNull
    private AsyncScheduler getAsyncScheduler() {
        Server server = this.getServer();
        return server.getAsyncScheduler();
    }

    @NotNull
    private RegionScheduler getRegionScheduler() {
        Server server = this.getServer();
        return server.getRegionScheduler();
    }

    @NotNull
    private <E extends Entity> EntityScheduler getEntityScheduler(@NotNull E entity) {
        return entity.getScheduler();
    }

    @NotNull
    private WrappedTask wrap(@NotNull AbstractTaskDetails details, @NotNull ScheduledTask task) {
        WrappedFoliaTask wrapped = new WrappedFoliaTask(task);
        details.setTask(wrapped);
        return wrapped;
    }

    @NotNull
    private WrappedTask scheduleTaskTimer(@NotNull TaskDetails details, long delay, long period) {
        Plugin plugin = this.getPlugin();
        GlobalRegionScheduler scheduler = this.getGlobalRegionScheduler();
        ScheduledTask scheduled = scheduler.runAtFixedRate(plugin, unused -> details.run(), delay, period);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskDelayed(@NotNull TaskDetails details, long delay) {
        Plugin plugin = this.getPlugin();
        GlobalRegionScheduler scheduler = this.getGlobalRegionScheduler();
        ScheduledTask scheduled = scheduler.runDelayed(plugin, unused -> details.run(), delay);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskSingle(@NotNull TaskDetails details) {
        Plugin plugin = this.getPlugin();
        GlobalRegionScheduler scheduler = this.getGlobalRegionScheduler();
        ScheduledTask scheduled = scheduler.run(plugin, unused -> details.run());
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskTimerAsync(@NotNull TaskDetails details, long delay, long period) {
        Plugin plugin = this.getPlugin();
        AsyncScheduler scheduler = this.getAsyncScheduler();
        long delayMillis = delay * 50L;
        long periodMillis = period * 50L;
        ScheduledTask scheduled = scheduler.runAtFixedRate(plugin, unused -> details.run(), delayMillis, periodMillis, TimeUnit.MILLISECONDS);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskDelayedAsync(@NotNull TaskDetails details, long delay) {
        Plugin plugin = this.getPlugin();
        AsyncScheduler scheduler = this.getAsyncScheduler();
        long delayMillis = delay * 50L;
        ScheduledTask scheduled = scheduler.runDelayed(plugin, unused -> details.run(), delayMillis, TimeUnit.MILLISECONDS);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskSingleAsync(@NotNull TaskDetails details) {
        Plugin plugin = this.getPlugin();
        AsyncScheduler scheduler = this.getAsyncScheduler();
        ScheduledTask scheduled = scheduler.runNow(plugin, unused -> details.run());
        return this.wrap(details, scheduled);
    }

    @NotNull
    private <E extends Entity> WrappedTask scheduleTaskTimer(@NotNull EntityTaskDetails<E> details, long delay, long period) {
        Plugin plugin = this.getPlugin();
        E entity = details.getEntity();
        if (entity == null) {
            throw new IllegalStateException("The entity for this task has already been removed.");
        }
        EntityScheduler scheduler = this.getEntityScheduler(entity);
        ScheduledTask scheduled = scheduler.runAtFixedRate(plugin, unused -> details.run(), null, delay, period);
        if (scheduled == null) {
            throw new IllegalStateException("The entity for this task has already been removed.");
        }
        return this.wrap(details, scheduled);
    }

    @NotNull
    private <E extends Entity> WrappedTask scheduleTaskDelayed(@NotNull EntityTaskDetails<E> details, long delay) {
        Plugin plugin = this.getPlugin();
        E entity = details.getEntity();
        if (entity == null) {
            throw new IllegalStateException("The entity for this task has already been removed.");
        }
        EntityScheduler scheduler = this.getEntityScheduler(entity);
        ScheduledTask scheduled = scheduler.runDelayed(plugin, unused -> details.run(), null, delay);
        if (scheduled == null) {
            throw new IllegalStateException("The entity for this task has already been removed.");
        }
        return this.wrap(details, scheduled);
    }

    @NotNull
    private <E extends Entity> WrappedTask scheduleTaskSingle(@NotNull EntityTaskDetails<E> details) {
        Plugin plugin = this.getPlugin();
        E entity = details.getEntity();
        if (entity == null) {
            throw new IllegalStateException("The entity for this task has already been removed.");
        }
        EntityScheduler scheduler = this.getEntityScheduler(entity);
        ScheduledTask scheduled = scheduler.run(plugin, unused -> details.run(), null);
        if (scheduled == null) {
            throw new IllegalStateException("The entity for this task has already been removed.");
        }
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskTimer(@NotNull LocationTaskDetails details, long delay, long period) {
        Plugin plugin = this.getPlugin();
        Location location = details.getLocation();
        RegionScheduler scheduler = this.getRegionScheduler();
        ScheduledTask scheduled = scheduler.runAtFixedRate(plugin, location, unused -> details.run(), delay, period);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskDelayed(@NotNull LocationTaskDetails details, long delay) {
        Plugin plugin = this.getPlugin();
        Location location = details.getLocation();
        RegionScheduler scheduler = this.getRegionScheduler();
        ScheduledTask scheduled = scheduler.runDelayed(plugin, location, unused -> details.run(), delay);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskSingle(@NotNull LocationTaskDetails details) {
        Plugin plugin = this.getPlugin();
        Location location = details.getLocation();
        RegionScheduler scheduler = this.getRegionScheduler();
        ScheduledTask scheduled = scheduler.run(plugin, location, unused -> details.run());
        return this.wrap(details, scheduled);
    }
}

