/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.folia.scheduler;

import com.github.sirblobman.api.folia.details.AbstractTaskDetails;
import com.github.sirblobman.api.folia.details.EntityTaskDetails;
import com.github.sirblobman.api.folia.details.LocationTaskDetails;
import com.github.sirblobman.api.folia.details.TaskDetails;
import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.folia.task.WrappedBukkitTask;
import com.github.sirblobman.api.folia.task.WrappedTask;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class BukkitTaskScheduler
extends TaskScheduler {
    public BukkitTaskScheduler(@NotNull Plugin plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public WrappedTask scheduleTask(@NotNull TaskDetails details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimer(details, realDelay, period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayed(details, delay);
        }
        return this.scheduleTaskSingle(details);
    }

    @Override
    @NotNull
    public WrappedTask scheduleAsyncTask(@NotNull TaskDetails details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimerAsync(details, realDelay, period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayedAsync(details, delay);
        }
        return this.scheduleTaskSingleAsync(details);
    }

    @Override
    @NotNull
    public <E extends Entity> WrappedTask scheduleEntityTask(EntityTaskDetails<E> details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimer(details, realDelay, period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayed(details, delay);
        }
        return this.scheduleTaskSingle(details);
    }

    @Override
    @NotNull
    public WrappedTask scheduleLocationTask(LocationTaskDetails details) {
        Long delay = details.getDelay();
        Long period = details.getPeriod();
        if (period != null) {
            long realDelay = delay == null ? 1L : delay;
            return this.scheduleTaskTimer(details, realDelay, period);
        }
        if (delay != null) {
            return this.scheduleTaskDelayed(details, delay);
        }
        return this.scheduleTaskSingle(details);
    }

    @NotNull
    private Server getServer() {
        Plugin plugin = this.getPlugin();
        return plugin.getServer();
    }

    @NotNull
    private BukkitScheduler getScheduler() {
        Server server = this.getServer();
        return server.getScheduler();
    }

    @NotNull
    private WrappedTask wrap(@NotNull AbstractTaskDetails details, @NotNull BukkitTask task) {
        WrappedBukkitTask wrapped = new WrappedBukkitTask(task);
        details.setTask(wrapped);
        return wrapped;
    }

    @NotNull
    private WrappedTask scheduleTaskTimer(@NotNull AbstractTaskDetails details, long delay, long period) {
        Plugin plugin = this.getPlugin();
        BukkitScheduler scheduler = this.getScheduler();
        BukkitTask scheduled = scheduler.runTaskTimer(plugin, details::run, delay, period);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskTimerAsync(@NotNull AbstractTaskDetails details, long delay, long period) {
        Plugin plugin = this.getPlugin();
        BukkitScheduler scheduler = this.getScheduler();
        BukkitTask scheduled = scheduler.runTaskTimerAsynchronously(plugin, details::run, delay, period);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskDelayed(@NotNull AbstractTaskDetails details, long delay) {
        Plugin plugin = this.getPlugin();
        BukkitScheduler scheduler = this.getScheduler();
        BukkitTask scheduled = scheduler.runTaskLater(plugin, details::run, delay);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskDelayedAsync(@NotNull AbstractTaskDetails details, long delay) {
        Plugin plugin = this.getPlugin();
        BukkitScheduler scheduler = this.getScheduler();
        BukkitTask scheduled = scheduler.runTaskLaterAsynchronously(plugin, details::run, delay);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskSingle(@NotNull AbstractTaskDetails details) {
        Plugin plugin = this.getPlugin();
        BukkitScheduler scheduler = this.getScheduler();
        BukkitTask scheduled = scheduler.runTask(plugin, details::run);
        return this.wrap(details, scheduled);
    }

    @NotNull
    private WrappedTask scheduleTaskSingleAsync(@NotNull AbstractTaskDetails details) {
        Plugin plugin = this.getPlugin();
        BukkitScheduler scheduler = this.getScheduler();
        BukkitTask scheduled = scheduler.runTaskAsynchronously(plugin, details::run);
        return this.wrap(details, scheduled);
    }
}

