/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.folia.details;

import com.github.sirblobman.api.folia.task.WrappedTask;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTaskDetails {
    private final Plugin plugin;
    private Long delay;
    private Long period;
    private WrappedTask task;

    public AbstractTaskDetails(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.delay = null;
        this.period = null;
        this.task = null;
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @Nullable
    public final Long getDelay() {
        return this.delay;
    }

    public final void setDelay(@Nullable Long delay) {
        this.delay = delay;
    }

    @Nullable
    public final Long getPeriod() {
        return this.period;
    }

    public final void setPeriod(@Nullable Long period) {
        this.period = period;
    }

    @Nullable
    private WrappedTask getTask() {
        return this.task;
    }

    public final void setTask(@NotNull WrappedTask task) {
        if (this.task != null) {
            throw new IllegalStateException("Already scheduled!");
        }
        this.task = task;
    }

    public final boolean isCancelled() {
        WrappedTask task = this.getTask();
        if (task == null) {
            return false;
        }
        return task.isCancelled();
    }

    public final void cancel() throws IllegalStateException {
        WrappedTask task = this.getTask();
        if (task == null) {
            throw new IllegalStateException("Not scheduled yet!");
        }
        task.cancel();
    }

    public abstract void run();
}

