/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.folia;

import com.github.sirblobman.api.folia.scheduler.TaskScheduler;
import com.github.sirblobman.api.folia.teleport.TeleportHandler;
import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class FoliaHelper {
    private final Plugin plugin;
    private Boolean foliaSupported;
    private TaskScheduler scheduler;
    private TeleportHandler teleporter;

    public FoliaHelper(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.foliaSupported = null;
        this.scheduler = null;
        this.teleporter = null;
    }

    @NotNull
    private Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    private Logger getLogger() {
        Plugin plugin = this.getPlugin();
        return plugin.getLogger();
    }

    public boolean isFolia() {
        if (this.foliaSupported != null) {
            return this.foliaSupported;
        }
        try {
            String className = "io.papermc.paper.threadedregions.RegionizedServer";
            Class.forName(className);
            Logger logger = this.getLogger();
            logger.info("Detected server as Folia.");
            this.foliaSupported = true;
            return this.foliaSupported;
        }
        catch (ClassNotFoundException ex) {
            Logger logger = this.getLogger();
            logger.info("Detected server as regular SpigotMC/PaperMC (not Folia)");
            this.foliaSupported = false;
            return this.foliaSupported;
        }
    }

    @NotNull
    public TaskScheduler getScheduler() {
        if (this.scheduler != null) {
            return this.scheduler;
        }
        String basePackage = this.getClass().getPackage().getName();
        String schedulerPackage = basePackage + ".scheduler";
        String classSimpleName = this.isFolia() ? "FoliaTaskScheduler" : "BukkitTaskScheduler";
        String className = schedulerPackage + "." + classSimpleName;
        try {
            Class<?> schedulerClass = Class.forName(className);
            Constructor<?> constructor = schedulerClass.getConstructor(Plugin.class);
            Plugin plugin = this.getPlugin();
            Object instance = constructor.newInstance(plugin);
            this.scheduler = (TaskScheduler)instance;
            return this.scheduler;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Missing class '" + className + "'.", ex);
        }
    }

    @NotNull
    public TeleportHandler getTeleporter() {
        if (this.teleporter != null) {
            return this.teleporter;
        }
        String basePackage = this.getClass().getPackage().getName();
        String schedulerPackage = basePackage + ".teleport";
        String classSimpleName = this.isFolia() ? "FoliaTeleportHandler" : "BukkitTeleportHandler";
        String className = schedulerPackage + "." + classSimpleName;
        try {
            Class<?> teleporterClass = Class.forName(className);
            Constructor<?> constructor = teleporterClass.getConstructor(new Class[0]);
            this.teleporter = (TeleportHandler)constructor.newInstance(new Object[0]);
            return this.teleporter;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Missing class '" + className + "'.", ex);
        }
    }
}

