/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.factions.FactionWrapper_UUID4;
import com.github.sirblobman.api.factions.FactionsHandler;
import dev.kitteh.factions.FLocation;
import dev.kitteh.factions.FPlayer;
import dev.kitteh.factions.FPlayers;
import dev.kitteh.factions.Faction;
import dev.kitteh.factions.Participator;
import dev.kitteh.factions.permissible.Relation;
import dev.kitteh.factions.permissible.Role;
import java.util.Locale;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FactionsHandler_UUID4
extends FactionsHandler {
    @Override
    public boolean hasFaction(@NotNull OfflinePlayer player) {
        FPlayer fplayer = this.getFPlayer(player);
        return fplayer.hasFaction();
    }

    @Override
    @Nullable
    public FactionWrapper getFactionFor(@NotNull OfflinePlayer player) {
        if (this.hasFaction(player)) {
            FPlayer fplayer = this.getFPlayer(player);
            return this.wrap(fplayer.faction());
        }
        return null;
    }

    @Override
    @NotNull
    public FactionWrapper getFactionAt(@NotNull Location location) {
        FLocation flocation = new FLocation(location);
        return this.wrap(flocation.faction());
    }

    @Override
    public boolean isAlly(@NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        FPlayer fplayer2;
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return true;
        }
        FPlayer fplayer1 = this.getFPlayer(player1);
        Relation relation = fplayer1.relationTo((Participator)(fplayer2 = this.getFPlayer(player2)));
        return relation.isMember() || relation.isAlly();
    }

    @Override
    public boolean isEnemy(@NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return false;
        }
        FPlayer fplayer1 = this.getFPlayer(player1);
        FPlayer fplayer2 = this.getFPlayer(player2);
        Relation relation = fplayer1.relationTo((Participator)fplayer2);
        return relation.isEnemy();
    }

    @Override
    public boolean hasBypass(@NotNull OfflinePlayer player) {
        FPlayer fplayer = this.getFPlayer(player);
        return fplayer.adminBypass();
    }

    @Override
    public boolean isInEnemyLand(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayer fplayer = this.getFPlayer(player);
        FLocation flocation = new FLocation(location);
        Faction faction = flocation.faction();
        Relation relation = fplayer.relationTo((Participator)faction);
        return relation.isEnemy();
    }

    @Override
    public boolean isInOwnFaction(@NotNull OfflinePlayer player, @NotNull Location location) {
        FactionWrapper faction = this.getFactionAt(location);
        return faction.isMember(player);
    }

    @Override
    @NotNull
    public ChatColor getRelationChatColor(@NotNull OfflinePlayer viewer, @NotNull OfflinePlayer player) {
        FPlayer fviewer = this.getFPlayer(viewer);
        FPlayer fplayer = this.getFPlayer(player);
        Relation relation = fviewer.relationTo((Participator)fplayer);
        TextColor textColor = relation.color();
        NamedTextColor nearestColor = NamedTextColor.nearestTo((TextColor)textColor);
        return ChatColor.valueOf((String)nearestColor.toString().toUpperCase(Locale.US));
    }

    @Override
    @NotNull
    public String getRolePrefix(@NotNull OfflinePlayer player) {
        FPlayer fplayer = this.getFPlayer(player);
        Role role = fplayer.role();
        return role.getPrefix();
    }

    @NotNull
    private FPlayer getFPlayer(@NotNull OfflinePlayer player) {
        return FPlayers.fPlayers().get(player);
    }

    @Nullable
    private FactionWrapper wrap(Faction faction) {
        if (faction == null) {
            return null;
        }
        return new FactionWrapper_UUID4(faction);
    }
}

