/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.factions.FactionWrapper_UUID;
import com.github.sirblobman.api.factions.FactionsHandler;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.perms.Relation;
import com.massivecraft.factions.perms.Role;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FactionsHandler_UUID
extends FactionsHandler {
    @Override
    public boolean hasFaction(@NotNull OfflinePlayer player) {
        FPlayer fplayer = this.getFPlayer(player);
        if (fplayer == null) {
            return false;
        }
        return fplayer.hasFaction();
    }

    @Override
    @Nullable
    public FactionWrapper getFactionFor(@NotNull OfflinePlayer player) {
        if (this.hasFaction(player)) {
            FPlayer fplayer = this.getFPlayer(player);
            if (fplayer == null) {
                return null;
            }
            return this.wrap(fplayer.getFaction());
        }
        return null;
    }

    @Override
    @Nullable
    public FactionWrapper getFactionAt(@NotNull Location location) {
        Board board = Board.getInstance();
        FLocation flocation = new FLocation(location);
        return this.wrap(board.getFactionAt(flocation));
    }

    @Override
    public boolean isAlly(@NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return true;
        }
        FPlayer fplayer1 = this.getFPlayer(player1);
        FPlayer fplayer2 = this.getFPlayer(player2);
        if (fplayer1 == null || fplayer2 == null) {
            return false;
        }
        Relation relation = fplayer1.getRelationTo((RelationParticipator)fplayer2);
        return relation.isMember() || relation.isAlly();
    }

    @Override
    public boolean isEnemy(@NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return false;
        }
        FPlayer fplayer1 = this.getFPlayer(player1);
        FPlayer fplayer2 = this.getFPlayer(player2);
        if (fplayer1 == null || fplayer2 == null) {
            return false;
        }
        Relation relation = fplayer1.getRelationTo((RelationParticipator)fplayer2);
        return relation.isEnemy();
    }

    @Override
    public boolean hasBypass(@NotNull OfflinePlayer player) {
        FPlayer fplayer = this.getFPlayer(player);
        if (fplayer == null) {
            return false;
        }
        return fplayer.isAdminBypassing();
    }

    @Override
    public boolean isInEnemyLand(@NotNull OfflinePlayer player, @NotNull Location location) {
        FLocation flocation;
        FPlayer fplayer = this.getFPlayer(player);
        if (fplayer == null) {
            return false;
        }
        Board board = Board.getInstance();
        Faction faction = board.getFactionAt(flocation = new FLocation(location));
        if (faction == null) {
            return false;
        }
        Relation relation = fplayer.getRelationTo((RelationParticipator)faction);
        return relation.isEnemy();
    }

    @Override
    public boolean isInOwnFaction(@NotNull OfflinePlayer player, @NotNull Location location) {
        FactionWrapper faction = this.getFactionAt(location);
        if (faction == null) {
            return false;
        }
        return faction.isMember(player);
    }

    @Override
    @Nullable
    public ChatColor getRelationChatColor(@NotNull OfflinePlayer viewer, @NotNull OfflinePlayer player) {
        FPlayer fviewer = this.getFPlayer(viewer);
        FPlayer fplayer = this.getFPlayer(player);
        if (fviewer == null || fplayer == null) {
            return null;
        }
        Relation relation = fviewer.getRelationTo((RelationParticipator)fplayer);
        return relation.getColor();
    }

    @Override
    @Nullable
    public String getRolePrefix(@NotNull OfflinePlayer player) {
        FPlayer fplayer = this.getFPlayer(player);
        if (fplayer == null) {
            return null;
        }
        Role role = fplayer.getRole();
        return role.getPrefix();
    }

    @Nullable
    private FPlayer getFPlayer(@NotNull OfflinePlayer player) {
        FPlayers fplayers = FPlayers.getInstance();
        return fplayers.getByOfflinePlayer(player);
    }

    @Nullable
    private FactionWrapper wrap(Faction faction) {
        if (faction == null) {
            return null;
        }
        return new FactionWrapper_UUID(faction);
    }
}

