/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.factions.FactionWrapper_Massive;
import com.github.sirblobman.api.factions.FactionsHandler;
import com.massivecraft.factions.Rel;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.massivecore.ps.PS;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FactionsHandler_Massive
extends FactionsHandler {
    @Override
    public boolean hasFaction(@NotNull OfflinePlayer player) {
        MPlayer mplayer = this.getMPlayer(player);
        if (mplayer == null) {
            return false;
        }
        return mplayer.hasFaction();
    }

    @Override
    @Nullable
    public FactionWrapper getFactionFor(@NotNull OfflinePlayer player) {
        MPlayer mplayer = this.getMPlayer(player);
        if (mplayer == null) {
            return null;
        }
        return this.wrap(mplayer.getFaction());
    }

    @Override
    @Nullable
    public FactionWrapper getFactionAt(@NotNull Location location) {
        BoardColl boardColl = BoardColl.get();
        PS psLocation = PS.valueOf((Location)location);
        return this.wrap(boardColl.getFactionAt(psLocation));
    }

    @Override
    public boolean isAlly(@NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return true;
        }
        MPlayer mplayer1 = this.getMPlayer(player1);
        MPlayer mplayer2 = this.getMPlayer(player2);
        if (mplayer1 == null || mplayer2 == null) {
            return false;
        }
        Rel relation = mplayer1.getRelationTo((RelationParticipator)mplayer2);
        return relation.isAtLeast(Rel.ALLY);
    }

    @Override
    public boolean isEnemy(@NotNull OfflinePlayer player1, @NotNull OfflinePlayer player2) {
        if (player1.getUniqueId().equals(player2.getUniqueId())) {
            return false;
        }
        MPlayer mplayer1 = this.getMPlayer(player1);
        MPlayer mplayer2 = this.getMPlayer(player2);
        if (mplayer1 == null || mplayer2 == null) {
            return false;
        }
        Rel relation = mplayer1.getRelationTo((RelationParticipator)mplayer2);
        return relation == Rel.ENEMY;
    }

    @Override
    public boolean hasBypass(@NotNull OfflinePlayer player) {
        MPlayer mplayer = this.getMPlayer(player);
        if (mplayer == null) {
            return false;
        }
        return mplayer.isOverriding();
    }

    @Override
    public boolean isInEnemyLand(@NotNull OfflinePlayer player, @NotNull Location location) {
        PS psLocation;
        MPlayer mplayer = this.getMPlayer(player);
        if (mplayer == null) {
            return false;
        }
        BoardColl boardColl = BoardColl.get();
        Faction faction = boardColl.getFactionAt(psLocation = PS.valueOf((Location)location));
        if (faction == null) {
            return false;
        }
        Rel relation = mplayer.getRelationTo((RelationParticipator)faction);
        return relation == Rel.ENEMY;
    }

    @Override
    public boolean isInOwnFaction(@NotNull OfflinePlayer player, @NotNull Location location) {
        FactionWrapper faction = this.getFactionAt(location);
        if (faction == null) {
            return false;
        }
        return faction.isMember(player);
    }

    @Override
    @Nullable
    public ChatColor getRelationChatColor(@NotNull OfflinePlayer viewer, @NotNull OfflinePlayer player) {
        MPlayer mviewer = this.getMPlayer(viewer);
        MPlayer mplayer = this.getMPlayer(player);
        if (mviewer == null || mplayer == null) {
            return null;
        }
        Rel relation = mviewer.getRelationTo((RelationParticipator)mplayer);
        return relation.getColor();
    }

    @Override
    @Nullable
    public String getRolePrefix(@NotNull OfflinePlayer player) {
        MPlayer mplayer = this.getMPlayer(player);
        if (mplayer == null) {
            return null;
        }
        Rel role = mplayer.getRole();
        return role.getPrefix();
    }

    @Nullable
    private MPlayer getMPlayer(@NotNull OfflinePlayer player) {
        return MPlayer.get((Object)player);
    }

    @Nullable
    private FactionWrapper wrap(Faction faction) {
        if (faction == null) {
            return null;
        }
        return new FactionWrapper_Massive(faction);
    }
}

