/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.utility.Validate;
import java.util.Set;
import java.util.UUID;
import net.prosavage.factionsx.core.FPlayer;
import net.prosavage.factionsx.core.Faction;
import net.prosavage.factionsx.manager.PlayerManager;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class FactionWrapper_X
extends FactionWrapper {
    private final Faction faction;

    public FactionWrapper_X(Faction faction) {
        this.faction = Validate.notNull(faction, "faction must not be null!");
    }

    @NotNull
    private Faction getFaction() {
        return this.faction;
    }

    @Override
    @NotNull
    public String getFactionId() {
        Faction faction = this.getFaction();
        long factionId = faction.getId();
        return Long.toString(factionId);
    }

    @Override
    @NotNull
    public String getFactionName() {
        Faction faction = this.getFaction();
        return faction.getTag();
    }

    @Override
    public boolean isSafeZone() {
        Faction faction = this.getFaction();
        return faction.isSafezone();
    }

    @Override
    public boolean isWarZone() {
        Faction faction = this.getFaction();
        return faction.isWarzone();
    }

    @Override
    public boolean isWilderness() {
        Faction faction = this.getFaction();
        return faction.isWilderness();
    }

    @Override
    public boolean isLeader(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        FPlayer leader = faction.getLeader();
        if (leader == null) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        UUID leaderId = leader.getUuid();
        return playerId.equals(leaderId);
    }

    @Override
    public boolean isMember(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        Set memberIdSet = faction.getFactionMembers();
        UUID playerId = player.getUniqueId();
        return memberIdSet.contains(playerId);
    }

    @Override
    public boolean canPlaceBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        UUID playerId = player.getUniqueId();
        FPlayer factionPlayer = PlayerManager.INSTANCE.getFPlayer(playerId);
        if (factionPlayer == null) {
            return false;
        }
        return factionPlayer.canBuildAt(location);
    }

    @Override
    public boolean canBreakBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        UUID playerId = player.getUniqueId();
        FPlayer factionPlayer = PlayerManager.INSTANCE.getFPlayer(playerId);
        if (factionPlayer == null) {
            return false;
        }
        return factionPlayer.canBreakAt(location);
    }

    @Override
    @NotNull
    public Set<UUID> getMembers() {
        Faction faction = this.getFaction();
        return faction.getFactionMembers();
    }
}

