/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.utility.Validate;
import dev.kitteh.factions.FLocation;
import dev.kitteh.factions.FPlayer;
import dev.kitteh.factions.FPlayers;
import dev.kitteh.factions.Faction;
import dev.kitteh.factions.permissible.PermissibleAction;
import dev.kitteh.factions.permissible.PermissibleActions;
import dev.kitteh.factions.permissible.Role;
import dev.kitteh.factions.permissible.Selectable;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class FactionWrapper_UUID4
extends FactionWrapper {
    private final Faction faction;

    public FactionWrapper_UUID4(Faction faction) {
        this.faction = Validate.notNull(faction, "faction must not be null!");
    }

    @NotNull
    private Faction getFaction() {
        return this.faction;
    }

    @Override
    @NotNull
    public String getFactionId() {
        Faction faction = this.getFaction();
        return Integer.toString(faction.id());
    }

    @Override
    @NotNull
    public String getFactionName() {
        Faction faction = this.getFaction();
        return faction.tag();
    }

    @Override
    public boolean isSafeZone() {
        Faction faction = this.getFaction();
        return faction.isSafeZone();
    }

    @Override
    public boolean isWarZone() {
        Faction faction = this.getFaction();
        return faction.isWarZone();
    }

    @Override
    public boolean isWilderness() {
        Faction faction = this.getFaction();
        return faction.isWilderness();
    }

    @Override
    public boolean isLeader(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        List fplayerList = faction.members(Role.ADMIN);
        if (fplayerList.isEmpty()) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        for (FPlayer fplayer : fplayerList) {
            UUID adminId = fplayer.uniqueId();
            if (!playerId.equals(adminId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMember(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        Set memberSet = faction.members();
        UUID playerId = player.getUniqueId();
        for (FPlayer member : memberSet) {
            UUID memberId = member.uniqueId();
            if (!playerId.equals(memberId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlaceBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayers fplayers = FPlayers.fPlayers();
        FPlayer fplayer = fplayers.get(player);
        Faction faction = this.getFaction();
        FLocation flocation = new FLocation(location);
        return faction.hasAccess((Selectable)fplayer, (PermissibleAction)PermissibleActions.BUILD, flocation);
    }

    @Override
    public boolean canBreakBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayers fplayers = FPlayers.fPlayers();
        FPlayer fplayer = fplayers.get(player);
        Faction faction = this.getFaction();
        FLocation flocation = new FLocation(location);
        return faction.hasAccess((Selectable)fplayer, (PermissibleAction)PermissibleActions.DESTROY, flocation);
    }

    @Override
    @NotNull
    public Set<UUID> getMembers() {
        Faction faction = this.getFaction();
        Set memberSet = faction.members();
        return memberSet.stream().map(FPlayer::uniqueId).collect(Collectors.toUnmodifiableSet());
    }
}

