/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.utility.Validate;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.struct.Role;
import com.massivecraft.factions.zcore.fperms.Access;
import com.massivecraft.factions.zcore.fperms.PermissableAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class FactionWrapper_Saber
extends FactionWrapper {
    private final Faction faction;

    public FactionWrapper_Saber(Faction faction) {
        this.faction = Validate.notNull(faction, "faction must not be null!");
    }

    @NotNull
    private Faction getFaction() {
        return this.faction;
    }

    @Override
    @NotNull
    public String getFactionId() {
        Faction faction = this.getFaction();
        return faction.getId();
    }

    @Override
    @NotNull
    public String getFactionName() {
        Faction faction = this.getFaction();
        return faction.getTag();
    }

    @Override
    public boolean isSafeZone() {
        Faction faction = this.getFaction();
        return faction.isSafeZone();
    }

    @Override
    public boolean isWarZone() {
        Faction faction = this.getFaction();
        return faction.isWarZone();
    }

    @Override
    public boolean isWilderness() {
        Faction faction = this.getFaction();
        return faction.isWilderness();
    }

    @Override
    public boolean isLeader(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        ArrayList fplayerList = faction.getFPlayersWhereRole(Role.LEADER);
        if (fplayerList.isEmpty()) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        for (FPlayer fplayer : fplayerList) {
            String adminIdString = fplayer.getId();
            UUID adminId = UUID.fromString(adminIdString);
            if (!playerId.equals(adminId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMember(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        Set memberSet = faction.getFPlayers();
        UUID playerId = player.getUniqueId();
        for (FPlayer member : memberSet) {
            String memberIdString = member.getId();
            UUID memberId = UUID.fromString(memberIdString);
            if (!playerId.equals(memberId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlaceBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayers fplayers = FPlayers.getInstance();
        FPlayer fplayer = fplayers.getByOfflinePlayer(player);
        if (fplayer == null) {
            return false;
        }
        Faction faction = this.getFaction();
        Access access = faction.getAccess(fplayer, PermissableAction.BUILD);
        return access == Access.ALLOW;
    }

    @Override
    public boolean canBreakBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayers fplayers = FPlayers.getInstance();
        FPlayer fplayer = fplayers.getByOfflinePlayer(player);
        if (fplayer == null) {
            return false;
        }
        Faction faction = this.getFaction();
        Access access = faction.getAccess(fplayer, PermissableAction.DESTROY);
        return access == Access.ALLOW;
    }

    @Override
    @NotNull
    public Set<UUID> getMembers() {
        Faction faction = this.getFaction();
        Set memberSet = faction.getFPlayers();
        HashSet<UUID> memberIdSet = new HashSet<UUID>();
        for (FPlayer member : memberSet) {
            String memberIdString = member.getId();
            UUID memberId = UUID.fromString(memberIdString);
            memberIdSet.add(memberId);
        }
        return Collections.unmodifiableSet(memberIdSet);
    }
}

