/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.utility.Validate;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.MPerm;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.massivecore.ps.PS;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class FactionWrapper_Massive
extends FactionWrapper {
    private final Faction faction;

    public FactionWrapper_Massive(Faction faction) {
        this.faction = Validate.notNull(faction, "faction must not be null!");
    }

    @NotNull
    private Faction getFaction() {
        return this.faction;
    }

    @Override
    @NotNull
    public String getFactionId() {
        Faction faction = this.getFaction();
        return faction.getId();
    }

    @Override
    @NotNull
    public String getFactionName() {
        Faction faction = this.getFaction();
        return faction.getName();
    }

    @Override
    public boolean isSafeZone() {
        String factionId = this.getFactionId();
        return factionId.equals("safezone");
    }

    @Override
    public boolean isWarZone() {
        String factionId = this.getFactionId();
        return factionId.equals("warzone");
    }

    @Override
    public boolean isWilderness() {
        String factionId = this.getFactionId();
        return factionId.equals("none");
    }

    @Override
    public boolean isLeader(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        MPlayer leader = faction.getLeader();
        if (leader == null) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        UUID leaderId = leader.getUuid();
        return playerId.equals(leaderId);
    }

    @Override
    public boolean isMember(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        List memberList = faction.getMPlayers();
        UUID playerId = player.getUniqueId();
        for (MPlayer member : memberList) {
            UUID memberId = member.getUuid();
            if (!playerId.equals(memberId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canPlaceBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        MPlayer mplayer = MPlayer.get((Object)player);
        if (mplayer == null) {
            return false;
        }
        MPerm buildPermission = MPerm.getPermBuild();
        PS psLocation = PS.valueOf((Location)location);
        return buildPermission.has(mplayer, psLocation, false);
    }

    @Override
    public boolean canBreakBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        return this.canPlaceBlock(player, location);
    }

    @Override
    @NotNull
    public Set<UUID> getMembers() {
        Faction faction = this.getFaction();
        List memberList = faction.getMPlayers();
        HashSet<UUID> memberIdSet = new HashSet<UUID>();
        for (MPlayer member : memberList) {
            UUID memberId = member.getUuid();
            memberIdSet.add(memberId);
        }
        return Collections.unmodifiableSet(memberIdSet);
    }
}

