/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.factions;

import com.github.sirblobman.api.factions.FactionWrapper;
import com.github.sirblobman.api.utility.Validate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.redstoneore.legacyfactions.entity.FPlayer;
import net.redstoneore.legacyfactions.entity.FPlayerColl;
import net.redstoneore.legacyfactions.entity.Faction;
import net.redstoneore.legacyfactions.locality.Locality;
import net.redstoneore.legacyfactions.locality.LocalityOwnership;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public final class FactionWrapper_Legacy
extends FactionWrapper {
    private final Faction faction;

    public FactionWrapper_Legacy(Faction faction) {
        this.faction = Validate.notNull(faction, "faction must not be null!");
    }

    @NotNull
    private Faction getFaction() {
        return this.faction;
    }

    @Override
    @NotNull
    public String getFactionId() {
        Faction faction = this.getFaction();
        return faction.getId();
    }

    @Override
    @NotNull
    public String getFactionName() {
        Faction faction = this.getFaction();
        return faction.getTag();
    }

    @Override
    public boolean isSafeZone() {
        Faction faction = this.getFaction();
        return faction.isSafeZone();
    }

    @Override
    public boolean isWarZone() {
        Faction faction = this.getFaction();
        return faction.isWarZone();
    }

    @Override
    public boolean isWilderness() {
        Faction faction = this.getFaction();
        return faction.isWilderness();
    }

    @Override
    public boolean isLeader(@NotNull OfflinePlayer player) {
        Faction faction = this.getFaction();
        FPlayer owner = faction.getOwner();
        if (owner == null) {
            return false;
        }
        UUID playerId = player.getUniqueId();
        String ownerId = owner.getId();
        return playerId.equals(UUID.fromString(ownerId));
    }

    @Override
    public boolean isMember(@NotNull OfflinePlayer player) {
        Set<UUID> memberSet = this.getMembers();
        UUID playerId = player.getUniqueId();
        return memberSet.contains(playerId);
    }

    @Override
    public boolean canPlaceBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayer fplayer = FPlayerColl.get((Object)player);
        if (fplayer == null) {
            return false;
        }
        Locality locality = Locality.of((Location)location);
        LocalityOwnership ownership = locality.getOwnership();
        return ownership != null && ownership.hasAccess(fplayer);
    }

    @Override
    public boolean canBreakBlock(@NotNull OfflinePlayer player, @NotNull Location location) {
        FPlayer fplayer = FPlayerColl.get((Object)player);
        if (fplayer == null) {
            return false;
        }
        Locality locality = Locality.of((Location)location);
        LocalityOwnership ownership = locality.getOwnership();
        return ownership != null && ownership.hasAccess(fplayer);
    }

    @Override
    @NotNull
    public Set<UUID> getMembers() {
        Faction faction = this.getFaction();
        Set memberSet = faction.getMembers();
        HashSet<UUID> memberIdSet = new HashSet<UUID>();
        for (FPlayer member : memberSet) {
            String memberIdString = member.getId();
            UUID memberId = UUID.fromString(memberIdString);
            memberIdSet.add(memberId);
        }
        return Collections.unmodifiableSet(memberIdSet);
    }
}

