/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.configuration;

import com.github.sirblobman.api.configuration.IConfigurable;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public final class CoreConfiguration
implements IConfigurable {
    private boolean updateCheckerEnabled = true;
    private boolean debugModeEnabled = false;
    private boolean commandLoggerEnabled = false;
    private boolean cacheLanguageOnJoin = true;
    private boolean removeCacheLanguageOnQuit = true;
    private boolean updateCacheLanguageOnChange = true;

    @Override
    public void load(@NotNull ConfigurationSection section) {
        this.setUpdateCheckerEnabled(section.getBoolean("update-checker", true));
        this.setDebugModeEnabled(section.getBoolean("debug-mode", false));
        this.setCommandLoggerEnabled(section.getBoolean("command-logger", false));
        this.setCacheLanguageOnJoin(section.getBoolean("cache-language-on-join", true));
        this.setRemoveCacheLanguageOnQuit(section.getBoolean("cache-language-remove-on-quit", true));
        this.setUpdateCacheLanguageOnChange(section.getBoolean("cache-language-update-on-change", true));
    }

    public boolean isUpdateCheckerEnabled() {
        return this.updateCheckerEnabled;
    }

    public void setUpdateCheckerEnabled(boolean enabled) {
        this.updateCheckerEnabled = enabled;
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public void setDebugModeEnabled(boolean enabled) {
        this.debugModeEnabled = enabled;
    }

    public boolean isCommandLoggerEnabled() {
        return this.commandLoggerEnabled;
    }

    public void setCommandLoggerEnabled(boolean enabled) {
        this.commandLoggerEnabled = enabled;
    }

    public boolean isCacheLanguageOnJoin() {
        return this.cacheLanguageOnJoin;
    }

    public void setCacheLanguageOnJoin(boolean cacheLanguageOnJoin) {
        this.cacheLanguageOnJoin = cacheLanguageOnJoin;
    }

    public boolean isRemoveCacheLanguageOnQuit() {
        return this.removeCacheLanguageOnQuit;
    }

    public void setRemoveCacheLanguageOnQuit(boolean removeCacheLanguageOnQuit) {
        this.removeCacheLanguageOnQuit = removeCacheLanguageOnQuit;
    }

    public boolean isUpdateCacheLanguageOnChange() {
        return this.updateCacheLanguageOnChange;
    }

    public void setUpdateCacheLanguageOnChange(boolean updateCacheLanguageOnChange) {
        this.updateCacheLanguageOnChange = updateCacheLanguageOnChange;
    }
}

