/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command.blueslimecore;

import com.github.sirblobman.api.command.ConsoleCommand;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.TextComponent;
import com.github.sirblobman.api.shaded.adventure.text.format.NamedTextColor;
import com.github.sirblobman.api.shaded.adventure.text.format.TextColor;
import com.github.sirblobman.api.shaded.adventure.text.format.TextDecoration;
import com.github.sirblobman.api.update.HangarUpdateManager;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SubCommandVersion
extends ConsoleCommand {
    private final CorePlugin plugin;

    public SubCommandVersion(@NotNull CorePlugin plugin) {
        super(plugin, "version");
        this.setPermissionName("blue.slime.core.command.blueslimecore.version");
        this.plugin = plugin;
    }

    @Override
    @NotNull
    protected LanguageManager getLanguageManager() {
        CorePlugin plugin = this.getCorePlugin();
        return plugin.getLanguageManager();
    }

    @Override
    @NotNull
    protected List<String> onTabComplete(@NotNull ConsoleCommandSender sender, String @NotNull [] args) {
        return Collections.emptyList();
    }

    @Override
    protected boolean execute(@NotNull ConsoleCommandSender sender, String @NotNull [] args) {
        ArrayList<Component> messageList = new ArrayList<Component>();
        messageList.add(Component.empty());
        this.addJavaVersionInformation(messageList);
        messageList.add(Component.empty());
        this.addServerVersionInformation(messageList);
        messageList.add(Component.empty());
        this.addDependencyInformation(messageList);
        messageList.add(Component.empty());
        this.addPluginVersionInformation(messageList);
        messageList.add(Component.empty());
        LanguageManager languageManager = this.getLanguageManager();
        for (Component message : messageList) {
            languageManager.sendMessage((CommandSender)sender, message);
        }
        return true;
    }

    @NotNull
    private CorePlugin getCorePlugin() {
        return this.plugin;
    }

    @NotNull
    private Component withPrefix(@NotNull String prefix, @Nullable String value) {
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().color(NamedTextColor.WHITE);
        builder.append(Component.text(prefix).decorate(TextDecoration.BOLD));
        builder.append(Component.text(":").decorate(TextDecoration.BOLD));
        builder.appendSpace();
        if (value != null) {
            builder.append((Component)Component.text(value, (TextColor)NamedTextColor.GRAY));
        } else {
            builder.append((Component)Component.text("N/A", (TextColor)NamedTextColor.GRAY));
        }
        return builder.build();
    }

    @NotNull
    private Component listElement(@NotNull String value) {
        TextComponent.Builder builder = (TextComponent.Builder)Component.text().color(NamedTextColor.GRAY);
        builder.append((Component)Component.text(" - ", (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD));
        builder.append((Component)Component.text(value));
        return builder.build();
    }

    private void addJavaVersionInformation(@NotNull List<Component> list) {
        try {
            String javaVersion = System.getProperty("java.version");
            String javaVendor = System.getProperty("java.vendor");
            String javaURL = System.getProperty("java.url");
            list.add(this.withPrefix("Java Version", javaVersion));
            list.add(this.withPrefix("Java Vendor", javaVendor));
            list.add(this.withPrefix("Java URL", javaURL));
        }
        catch (IllegalArgumentException | NullPointerException | SecurityException ignored) {
            list.add(this.withPrefix("Java Version", "Unknown"));
        }
    }

    private void addServerVersionInformation(@NotNull List<Component> list) {
        CorePlugin plugin = this.getCorePlugin();
        Server server = plugin.getServer();
        String version = server.getVersion();
        String bukkitVersion = server.getBukkitVersion();
        String minecraftVersion = VersionUtility.getMinecraftVersion();
        String nmsVersion = VersionUtility.getNetMinecraftServerVersion();
        list.add(this.withPrefix("Server Version", version));
        list.add(this.withPrefix("Bukkit Version", bukkitVersion));
        list.add(this.withPrefix("Minecraft Version", minecraftVersion));
        list.add(this.withPrefix("NMS Version", nmsVersion));
    }

    private void addDependencyInformation(@NotNull List<Component> list) {
        CorePlugin plugin = this.getCorePlugin();
        PluginDescriptionFile description = plugin.getDescription();
        list.add(Component.text("Dependency Information:", (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD));
        List loadBeforeList = description.getLoadBefore();
        List softDependList = description.getSoftDepend();
        List dependList = description.getDepend();
        LinkedHashSet fullDependencySet = new LinkedHashSet(loadBeforeList);
        fullDependencySet.addAll(softDependList);
        fullDependencySet.addAll(dependList);
        if (fullDependencySet.isEmpty()) {
            list.add(this.listElement("None"));
            return;
        }
        TextComponent missingText = Component.text("(not installed)", (TextColor)NamedTextColor.RED);
        PluginManager pluginManager = Bukkit.getPluginManager();
        for (String dependencyName : fullDependencySet) {
            Plugin dependency = pluginManager.getPlugin(dependencyName);
            if (dependency == null) {
                list.add(this.listElement(dependencyName).append(Component.space()).append(missingText));
                continue;
            }
            PluginDescriptionFile dependencyDescription = dependency.getDescription();
            String dependencyFullName = dependencyDescription.getFullName();
            list.add(this.listElement(dependencyFullName));
        }
    }

    private void addPluginVersionInformation(@NotNull List<Component> list) {
        String localVersion = this.getPluginVersion();
        String remoteVersion = this.getRemoteVersion();
        list.add(Component.text("BlueSlimeCore by SirBlobman", (TextColor)NamedTextColor.WHITE, TextDecoration.BOLD));
        list.add(this.withPrefix("Local Version", localVersion));
        list.add(this.withPrefix("Remote Version", remoteVersion));
    }

    @NotNull
    private String getPluginVersion() {
        CorePlugin plugin = this.getCorePlugin();
        PluginDescriptionFile description = plugin.getDescription();
        return description.getVersion();
    }

    @NotNull
    private String getRemoteVersion() {
        CorePlugin plugin = this.getCorePlugin();
        HangarUpdateManager updateManager = plugin.getHangarUpdateManager();
        String remoteVersion = updateManager.getCachedHangarVersion((Plugin)plugin);
        return remoteVersion != null ? remoteVersion : "Not Available";
    }
}

