/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command.blueslimecore;

import com.github.sirblobman.api.command.Command;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.Language;
import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.language.replacer.StringReplacer;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public final class SubCommandLanguageTest
extends Command {
    private final CorePlugin plugin;

    public SubCommandLanguageTest(@NotNull CorePlugin plugin) {
        super(plugin, "language-test");
        this.setPermissionName("blue.slime.core.command.blueslimecore.language-test");
        this.plugin = plugin;
    }

    @Override
    @NotNull
    protected LanguageManager getLanguageManager() {
        CorePlugin plugin = this.getCorePlugin();
        return plugin.getLanguageManager();
    }

    @Override
    @NotNull
    protected List<String> onTabComplete(@NotNull CommandSender sender, String @NotNull [] args) {
        if (args.length == 1) {
            Set<String> valueSet = this.getOnlinePlayerNames();
            return this.getMatching(args[0], valueSet);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean execute(@NotNull CommandSender sender, String @NotNull [] args) {
        String targetName;
        CommandSender target = sender;
        if (args.length > 0 && (target = this.findTarget(sender, targetName = args[0])) == null) {
            return true;
        }
        LanguageManager languageManager = this.getLanguageManager();
        Language language = languageManager.getLanguage(target);
        if (language == null) {
            languageManager.sendMessage(sender, "language-test.invalid-language", new Replacer[0]);
            return true;
        }
        this.sendTests(target, language);
        this.sendMessage(sender, "language-test.complete", new Replacer[0]);
        return true;
    }

    @NotNull
    private CorePlugin getCorePlugin() {
        return this.plugin;
    }

    private void sendTests(@NotNull CommandSender audience, @NotNull Language language) {
        LanguageManager languageManager = this.getLanguageManager();
        String languageCode = language.getLanguageName();
        StringReplacer codeReplacer = new StringReplacer("{language_code}", languageCode);
        languageManager.sendMessage(audience, "language-test.language-code", codeReplacer);
        Locale javaLocale = language.getJavaLocale();
        String javaLocaleTag = javaLocale.toLanguageTag();
        StringReplacer localeReplacer = new StringReplacer("{java_locale}", javaLocaleTag);
        languageManager.sendMessage(audience, "language-test.java-locale", localeReplacer);
        languageManager.sendActionBar(audience, "language-test.action-bar", new Replacer[0]);
        languageManager.sendSound(audience, "language-test.sound");
        languageManager.sendTitle(audience, "language-test.title", new Replacer[0]);
        languageManager.sendMessage(audience, "language-test.message", new Replacer[0]);
        languageManager.broadcastMessage("language-test.broadcast", null, new Replacer[0]);
    }
}

