/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command;

import com.github.sirblobman.api.command.PlayerCommand;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.utility.ItemUtility;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CommandItemToYML
extends PlayerCommand {
    public CommandItemToYML(@NotNull CorePlugin plugin) {
        super(plugin, "item-to-yml");
        this.setPermissionName("blue.slime.core.command.item-to-yml");
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player player, String @NotNull [] args) {
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull Player player, String @NotNull [] args) {
        ItemStack item = this.getHeldItem(player);
        if (ItemUtility.isAir(item)) {
            this.sendMessage((CommandSender)player, "error.invalid-held-item", new Replacer[0]);
            return true;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.set("item", (Object)item);
        String configurationString = configuration.saveToString();
        String[] split = configurationString.split(Pattern.quote("\n"));
        player.sendMessage(split);
        return true;
    }
}

