/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command;

import com.github.sirblobman.api.command.PlayerCommand;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.nms.MultiVersionHandler;
import com.github.sirblobman.api.utility.ItemUtility;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CommandItemToNBT
extends PlayerCommand {
    private final CorePlugin plugin;
    private final Gson prettyGson;

    public CommandItemToNBT(@NotNull CorePlugin plugin) {
        super(plugin, "item-to-nbt");
        this.setPermissionName("blue.slime.core.command.item-to-nbt");
        this.plugin = plugin;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        try {
            gsonBuilder.setLenient();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.prettyGson = gsonBuilder.create();
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player player, String @NotNull [] args) {
        if (args.length == 1) {
            return Collections.singletonList("pretty");
        }
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull Player player, String @NotNull [] args) {
        ItemStack item = this.getHeldItem(player);
        if (ItemUtility.isAir(item)) {
            this.sendMessage((CommandSender)player, "error.invalid-held-item", new Replacer[0]);
            return true;
        }
        CorePlugin plugin = this.getCorePlugin();
        MultiVersionHandler multiVersionHandler = plugin.getMultiVersionHandler();
        ItemHandler itemHandler = multiVersionHandler.getItemHandler();
        String nbtString = itemHandler.toNBT(item);
        if (args.length > 0 && args[0].equalsIgnoreCase("pretty")) {
            nbtString = this.prettyJSON(player, nbtString);
        }
        String[] split = nbtString.split(Pattern.quote("\n"));
        player.sendMessage(split);
        return true;
    }

    @NotNull
    private CorePlugin getCorePlugin() {
        return this.plugin;
    }

    @NotNull
    private Gson getPrettyGson() {
        return this.prettyGson;
    }

    @NotNull
    private String prettyJSON(@NotNull Player player, @NotNull String json) {
        String string;
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        try {
            reader.setLenient(true);
            JsonParser jsonParser = new JsonParser();
            jsonParser.parse(reader);
            JsonElement jsonElement = jsonParser.parse(json);
            Gson prettyGson = this.getPrettyGson();
            string = prettyGson.toJson(jsonElement);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception | NoClassDefFoundError ex) {
                player.sendMessage("Could not parse into pretty JSON, sending normal...");
                return json;
            }
        }
        reader.close();
        return string;
    }
}

