/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command;

import com.github.sirblobman.api.command.PlayerCommand;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.shaded.adventure.text.TextComponent;
import com.github.sirblobman.api.shaded.adventure.text.TranslatableComponent;
import com.github.sirblobman.api.shaded.adventure.text.event.ClickEvent;
import com.github.sirblobman.api.shaded.adventure.text.event.HoverEvent;
import com.github.sirblobman.api.utility.ItemUtility;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CommandItemToBase64
extends PlayerCommand {
    private final CorePlugin plugin;

    public CommandItemToBase64(@NotNull CorePlugin plugin) {
        super(plugin, "item-to-base64");
        this.setPermissionName("blue.slime.core.command.item-to-base64");
        this.plugin = plugin;
    }

    @Override
    @NotNull
    protected List<String> onTabComplete(@NotNull Player player, String @NotNull [] args) {
        return Collections.emptyList();
    }

    @Override
    protected boolean execute(@NotNull Player player, String @NotNull [] args) {
        ItemStack item = this.getHeldItem(player);
        if (ItemUtility.isAir(item)) {
            this.sendMessage((CommandSender)player, "error.invalid-held-item", new Replacer[0]);
            return true;
        }
        String base64 = this.getBase64String(item);
        Component message = this.createCopyable(base64);
        LanguageManager languageManager = this.getLanguageManager();
        if (languageManager != null) {
            languageManager.sendMessage((CommandSender)player, message);
        } else {
            player.sendMessage(base64);
        }
        return true;
    }

    @NotNull
    private CorePlugin getCorePlugin() {
        return this.plugin;
    }

    @NotNull
    private String getBase64String(@NotNull ItemStack stack) {
        ItemHandler itemHandler = this.getCorePlugin().getMultiVersionHandler().getItemHandler();
        return itemHandler.toBase64String(stack);
    }

    @NotNull
    private Component createCopyable(@NotNull String text) {
        TranslatableComponent clickToCopy = Component.translatable("chat.copy.click");
        HoverEvent<Component> hoverEvent = HoverEvent.showText(clickToCopy);
        ClickEvent clickEvent = ClickEvent.copyToClipboard(text);
        return ((TextComponent)Component.text(text).clickEvent(clickEvent)).hoverEvent(hoverEvent);
    }
}

