/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command;

import com.github.sirblobman.api.command.PlayerCommand;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.replacer.IntegerReplacer;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.language.replacer.StringReplacer;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.nms.MultiVersionHandler;
import com.github.sirblobman.api.shaded.xseries.XMaterial;
import com.github.sirblobman.api.utility.ItemUtility;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CommandItemInfo
extends PlayerCommand {
    private final CorePlugin plugin;

    public CommandItemInfo(@NotNull CorePlugin plugin) {
        super(plugin, "item-info");
        this.setPermissionName("blue.slime.core.command.item-info");
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player player, String @NotNull [] args) {
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull Player player, String @NotNull [] args) {
        ItemStack item = this.getHeldItem(player);
        if (ItemUtility.isAir(item)) {
            this.sendMessage((CommandSender)player, "error.invalid-held-item", new Replacer[0]);
            return true;
        }
        String materialNameX = this.getMaterialNameX(item);
        String materialNameBukkit = this.getMaterialNameBukkit(item);
        String vanillaId = this.getVanillaId(item);
        StringReplacer materialReplacer = new StringReplacer("{material}", materialNameBukkit);
        StringReplacer xmaterialReplacer = new StringReplacer("{xmaterial}", materialNameX);
        StringReplacer vanillaIdReplacer = new StringReplacer("{vanilla}", vanillaId);
        this.sendMessage((CommandSender)player, "command.item-info.modern", materialReplacer, xmaterialReplacer, vanillaIdReplacer);
        int minorVersion = VersionUtility.getMinorVersion();
        if (minorVersion < 13) {
            int materialId = this.getMaterialIdLegacy(item);
            short data = item.getDurability();
            IntegerReplacer materialIdReplacer = new IntegerReplacer("{material_id}", materialId);
            IntegerReplacer materialDataReplacer = new IntegerReplacer("{data}", data);
            this.sendMessage((CommandSender)player, "command.item-info.legacy", materialIdReplacer, materialDataReplacer);
        }
        return true;
    }

    @NotNull
    private CorePlugin getCorePlugin() {
        return this.plugin;
    }

    @NotNull
    private String getMaterialNameX(@NotNull ItemStack item) {
        try {
            XMaterial material = XMaterial.matchXMaterial(item);
            return material.name();
        }
        catch (IllegalArgumentException ex) {
            return "N/A";
        }
    }

    @NotNull
    private String getMaterialNameBukkit(@NotNull ItemStack item) {
        Material material = item.getType();
        return material.name();
    }

    @NotNull
    private String getVanillaId(@NotNull ItemStack item) {
        CorePlugin plugin = this.getCorePlugin();
        MultiVersionHandler multiVersionHandler = plugin.getMultiVersionHandler();
        ItemHandler itemHandler = multiVersionHandler.getItemHandler();
        return itemHandler.getKeyString(item);
    }

    private int getMaterialIdLegacy(@NotNull ItemStack item) {
        Material material = item.getType();
        return material.getId();
    }
}

