/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command;

import com.github.sirblobman.api.command.Command;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.replacer.IntegerReplacer;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.language.replacer.StringReplacer;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandGlobalGamerule
extends Command {
    public CommandGlobalGamerule(@NotNull CorePlugin plugin) {
        super(plugin, "global-gamerule");
        this.setPermissionName("blue.slime.core.command.global-gamerule");
    }

    @Override
    @NotNull
    protected List<String> onTabComplete(@NotNull CommandSender sender, String @NotNull [] args) {
        if (args.length == 1) {
            World world = this.getWorld(sender);
            if (world == null) {
                return Collections.emptyList();
            }
            String[] gameRuleArray = world.getGameRules();
            return this.getMatching(args[0], gameRuleArray);
        }
        if (args.length == 2) {
            return this.getMatching(args[1], "true", "false");
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean execute(@NotNull CommandSender sender, String @NotNull [] args) {
        if (args.length < 1) {
            return false;
        }
        World senderWorld = this.getWorld(sender);
        if (senderWorld == null) {
            this.sendMessage(sender, "error.world-required", new Replacer[0]);
            return true;
        }
        String gameRuleString = args[0];
        if (!senderWorld.isGameRule(gameRuleString)) {
            StringReplacer replacer = new StringReplacer("{value}", gameRuleString);
            this.sendMessage(sender, "command.global-gamerule.invalid-gamerule", replacer);
            return true;
        }
        if (args.length < 2) {
            this.showPerWorldValueList(sender, gameRuleString);
            return true;
        }
        this.setGameRule(sender, gameRuleString, args[1]);
        return true;
    }

    @Nullable
    private World getWorld(@NotNull CommandSender sender) {
        Location location = this.getLocation(sender);
        if (location == null) {
            return null;
        }
        return location.getWorld();
    }

    private void showPerWorldValueList(@NotNull CommandSender sender, @NotNull String gameRuleName) {
        StringReplacer ruleReplacer = new StringReplacer("{rule}", gameRuleName);
        this.sendMessage(sender, "command.global-gamerule.list-title", ruleReplacer);
        List worldList = Bukkit.getWorlds();
        for (World world : worldList) {
            String worldName = world.getName();
            String gameRuleValue = world.getGameRuleValue(gameRuleName);
            StringReplacer worldReplacer = new StringReplacer("{world}", worldName);
            StringReplacer valueReplacer = new StringReplacer("{value}", gameRuleValue);
            this.sendMessage(sender, "command.global-gamerule.list-line-format", worldReplacer, valueReplacer);
        }
    }

    private void setGameRule(@NotNull CommandSender sender, @NotNull String gameRuleName, @NotNull String value) {
        IntegerReplacer countReplacer;
        String key;
        int successCount = 0;
        int failureCount = 0;
        List worldList = Bukkit.getWorlds();
        for (World world : worldList) {
            if (world.setGameRuleValue(gameRuleName, value)) {
                ++successCount;
                continue;
            }
            ++failureCount;
        }
        StringReplacer ruleReplacer = new StringReplacer("{rule}", gameRuleName);
        StringReplacer valueReplacer = new StringReplacer("{value}", value);
        if (successCount > 0) {
            key = "command.global-gamerule.success-count";
            countReplacer = new IntegerReplacer("{count}", successCount);
            this.sendMessage(sender, key, countReplacer, ruleReplacer, valueReplacer);
        }
        if (failureCount > 0) {
            key = "command.global-gamerule.failure-count";
            countReplacer = new IntegerReplacer("{count}", failureCount);
            this.sendMessage(sender, key, countReplacer, ruleReplacer, valueReplacer);
        }
    }
}

