/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core.command;

import com.github.sirblobman.api.command.ConsoleCommand;
import com.github.sirblobman.api.core.CorePlugin;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.language.replacer.StringReplacer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandDebugEvent
extends ConsoleCommand {
    public CommandDebugEvent(@NotNull CorePlugin plugin) {
        super(plugin, "debug-event");
        this.setPermissionName("blue.slime.core.command.debug-event");
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull ConsoleCommandSender sender, String @NotNull [] args) {
        if (args.length == 1) {
            Set<String> valueSet = this.getEnumNames(EventPriority.class);
            return this.getMatching(args[0], valueSet);
        }
        if (args.length == 2) {
            Set<String> valueSet = this.getExampleEventClasses();
            return this.getMatching(args[1], valueSet);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean execute(@NotNull ConsoleCommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            return false;
        }
        String eventPriorityName = args[0];
        EventPriority eventPriority = this.matchEnum(EventPriority.class, eventPriorityName);
        if (eventPriority == null) {
            StringReplacer replacer = new StringReplacer("{value}", eventPriorityName);
            this.sendMessage((CommandSender)sender, "command.debug-event.invalid-priority", replacer);
            return true;
        }
        String className = args[1];
        Class<? extends Event> eventClass = this.getEventClass(className);
        if (eventClass == null) {
            StringReplacer replacer = new StringReplacer("{value}", className);
            this.sendMessage((CommandSender)sender, "command.debug-event.invalid-event-class", replacer);
            return true;
        }
        try {
            HandlerList handlerList = this.getHandlerList(eventClass);
            this.logDebugResults(eventClass, handlerList, eventPriority);
            return true;
        }
        catch (ReflectiveOperationException ex) {
            Logger logger = this.getLogger();
            this.sendMessage((CommandSender)sender, "command.debug-event.reflection-error", new Replacer[0]);
            logger.log(Level.WARNING, "Failed to debug an event because an error occurred:", ex);
            return true;
        }
    }

    @Nullable
    private Class<? extends Event> getEventClass(@NotNull String className) {
        try {
            Class<?> namedClass = Class.forName(className);
            return namedClass.asSubclass(Event.class);
        }
        catch (ClassCastException | ReflectiveOperationException ex) {
            return null;
        }
    }

    @NotNull
    private HandlerList getHandlerList(@NotNull Class<? extends Event> eventClass) throws ReflectiveOperationException {
        Method method_getHandlerList = eventClass.getMethod("getHandlerList", new Class[0]);
        method_getHandlerList.setAccessible(true);
        Object object_HandlerList = method_getHandlerList.invoke(null, new Object[0]);
        return (HandlerList)object_HandlerList;
    }

    @NotNull
    private Map<String, Set<String>> getPluginListenerMap(@NotNull HandlerList handlerList, @NotNull EventPriority priority) {
        RegisteredListener[] registeredListenerArray = handlerList.getRegisteredListeners();
        HashMap<String, Set<String>> pluginListenerMap = new HashMap<String, Set<String>>();
        for (RegisteredListener registeredListener : registeredListenerArray) {
            EventPriority listenerPriority = registeredListener.getPriority();
            if (listenerPriority != priority) continue;
            Plugin plugin = registeredListener.getPlugin();
            String pluginName = plugin.getName();
            Set classNameSet = pluginListenerMap.getOrDefault(pluginName, new HashSet());
            Listener listener = registeredListener.getListener();
            Class class_Listener = listener.getClass();
            String className = class_Listener.getName();
            classNameSet.add(className);
            pluginListenerMap.putIfAbsent(pluginName, classNameSet);
        }
        return pluginListenerMap;
    }

    private void logDebugResults(@NotNull Class<?> eventClass, @NotNull HandlerList handlerList, @NotNull EventPriority priority) {
        Map<String, Set<String>> pluginListenerMap = this.getPluginListenerMap(handlerList, priority);
        Set<Map.Entry<String, Set<String>>> entrySet = pluginListenerMap.entrySet();
        String eventClassSimpleName = eventClass.getSimpleName();
        String priorityName = priority.name();
        StringReplacer eventReplacer = new StringReplacer("{event}", eventClassSimpleName);
        StringReplacer priorityReplacer = new StringReplacer("{priority}", priorityName);
        ConsoleCommandSender console = Bukkit.getConsoleSender();
        this.sendMessage((CommandSender)console, "command.debug-event.results-title", eventReplacer, priorityReplacer);
        if (pluginListenerMap.isEmpty()) {
            this.sendMessage((CommandSender)console, "command.debug-event.results-none", eventReplacer, priorityReplacer);
            return;
        }
        for (Map.Entry<String, Set<String>> entry : entrySet) {
            String pluginName = entry.getKey();
            console.sendMessage("  " + pluginName + ":");
            Set<String> listenerClassNameSet = entry.getValue();
            for (String listenerClassName : listenerClassNameSet) {
                console.sendMessage("  - " + listenerClassName);
            }
        }
    }

    @NotNull
    private Set<String> getExampleEventClasses() {
        List<Class> exampleClassList = Arrays.asList(PlayerInteractEvent.class, PlayerDeathEvent.class, PlayerTeleportEvent.class, EntitySpawnEvent.class);
        return exampleClassList.parallelStream().map(Class::getName).collect(Collectors.toSet());
    }
}

