/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.core;

import com.github.sirblobman.api.bossbar.BossBarHandler;
import com.github.sirblobman.api.configuration.ConfigurationManager;
import com.github.sirblobman.api.core.command.CommandDebugEvent;
import com.github.sirblobman.api.core.command.CommandGlobalGamerule;
import com.github.sirblobman.api.core.command.CommandItemInfo;
import com.github.sirblobman.api.core.command.CommandItemToBase64;
import com.github.sirblobman.api.core.command.CommandItemToNBT;
import com.github.sirblobman.api.core.command.CommandItemToYML;
import com.github.sirblobman.api.core.command.blueslimecore.CommandBlueSlimeCore;
import com.github.sirblobman.api.core.configuration.CoreConfiguration;
import com.github.sirblobman.api.core.listener.ListenerCommandLogger;
import com.github.sirblobman.api.language.Language;
import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.nms.EntityHandler;
import com.github.sirblobman.api.nms.HeadHandler;
import com.github.sirblobman.api.nms.ItemHandler;
import com.github.sirblobman.api.nms.MultiVersionHandler;
import com.github.sirblobman.api.nms.PlayerHandler;
import com.github.sirblobman.api.nms.scoreboard.ScoreboardHandler;
import com.github.sirblobman.api.plugin.ConfigurablePlugin;
import com.github.sirblobman.api.shaded.bstats.bukkit.Metrics;
import com.github.sirblobman.api.shaded.bstats.charts.SimplePie;
import com.github.sirblobman.api.update.HangarInfo;
import com.github.sirblobman.api.update.HangarUpdateManager;
import com.github.sirblobman.api.update.SpigotUpdateManager;
import com.github.sirblobman.api.utility.VersionUtility;
import java.util.Locale;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public final class CorePlugin
extends ConfigurablePlugin {
    private final CoreConfiguration coreConfiguration = new CoreConfiguration();
    private final SpigotUpdateManager spigotUpdateManager = new SpigotUpdateManager(this);
    private final HangarUpdateManager hangarUpdateManager = new HangarUpdateManager(this);

    @Override
    public void onLoad() {
        this.saveDefaultConfig();
        LanguageManager languageManager = this.getLanguageManager();
        languageManager.saveDefaultLanguageFiles();
    }

    @Override
    public void onEnable() {
        this.reloadConfiguration();
        LanguageManager languageManager = this.getLanguageManager();
        languageManager.onPluginEnable();
        CoreConfiguration coreConfiguration = this.getCoreConfiguration();
        if (coreConfiguration.isDebugModeEnabled()) {
            this.printMultiVersionInformation();
        }
        this.registerCommands();
        this.registerListeners();
        this.registerUpdateChecker();
        this.register_bStats();
    }

    @Override
    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
    }

    @Override
    protected void reloadConfiguration() {
        ConfigurationManager configurationManager = this.getConfigurationManager();
        configurationManager.reload("config.yml");
        LanguageManager languageManager = this.getLanguageManager();
        languageManager.reloadLanguages();
        this.getCoreConfiguration().load((ConfigurationSection)configurationManager.get("config.yml"));
    }

    @NotNull
    public CoreConfiguration getCoreConfiguration() {
        return this.coreConfiguration;
    }

    @NotNull
    public SpigotUpdateManager getSpigotUpdateManager() {
        return this.spigotUpdateManager;
    }

    @NotNull
    public HangarUpdateManager getHangarUpdateManager() {
        return this.hangarUpdateManager;
    }

    private void printMultiVersionInformation() {
        PluginDescriptionFile description = this.getDescription();
        String pluginVersion = description.getVersion();
        this.printDebug("Plugin Version: " + pluginVersion);
        Server server = this.getServer();
        String serverVersion = server.getVersion();
        String bukkitVersion = server.getBukkitVersion();
        this.printDebug("Server Version: " + serverVersion);
        this.printDebug("Bukkit Version: " + bukkitVersion);
        String minecraftVersion = VersionUtility.getMinecraftVersion();
        String nmsVersion = VersionUtility.getNetMinecraftServerVersion();
        String majorMinorVersion = VersionUtility.getMajorMinorVersion();
        int majorVersion = VersionUtility.getMajorVersion();
        int minorVersion = VersionUtility.getMinorVersion();
        this.printDebug("Minecraft Version: " + minecraftVersion);
        this.printDebug("Major.Minor: " + majorMinorVersion);
        this.printDebug("Major: " + majorVersion);
        this.printDebug("Minor: " + minorVersion);
        this.printDebug("Detected NMS Version: " + nmsVersion);
        MultiVersionHandler multiVersionHandler = this.getMultiVersionHandler();
        this.printDebug("Attempting for find NMS handlers for version '" + nmsVersion + "'...");
        BossBarHandler bossBarHandler = multiVersionHandler.getBossBarHandler();
        EntityHandler entityHandler = multiVersionHandler.getEntityHandler();
        HeadHandler headHandler = multiVersionHandler.getHeadHandler();
        ItemHandler itemHandler = multiVersionHandler.getItemHandler();
        PlayerHandler playerHandler = multiVersionHandler.getPlayerHandler();
        ScoreboardHandler scoreboardHandler = multiVersionHandler.getScoreboardHandler();
        this.printDebug("Successfully linked with the following handlers:");
        this.printClassNames(bossBarHandler, scoreboardHandler, entityHandler, headHandler, itemHandler, playerHandler);
    }

    private void printClassNames(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            this.printClassName(object);
        }
    }

    private void printClassName(@NotNull Object object) {
        Logger logger = this.getLogger();
        String className = this.getClassName(object);
        String message = String.format(Locale.US, " - %s", className);
        logger.info(message);
    }

    @NotNull
    private String getClassName(@NotNull Object object) {
        if (object instanceof Class) {
            Class objectClass = (Class)object;
            return objectClass.getName();
        }
        Class<?> objectClass = object.getClass();
        return this.getClassName(objectClass);
    }

    private void registerCommands() {
        new CommandDebugEvent(this).register();
        new CommandGlobalGamerule(this).register();
        new CommandItemInfo(this).register();
        new CommandItemToBase64(this).register();
        new CommandItemToNBT(this).register();
        new CommandItemToYML(this).register();
        new CommandBlueSlimeCore(this).register();
    }

    private void registerListeners() {
        CoreConfiguration coreConfiguration = this.getCoreConfiguration();
        if (coreConfiguration.isCommandLoggerEnabled()) {
            new ListenerCommandLogger(this).register();
        }
    }

    private void registerUpdateChecker() {
        SpigotUpdateManager updateManager = this.getSpigotUpdateManager();
        updateManager.checkForUpdates();
        HangarInfo hangarInfo = new HangarInfo("SirBlobman", "BlueSlimeCore");
        HangarUpdateManager hangarUpdateManager = this.getHangarUpdateManager();
        hangarUpdateManager.addProject((Plugin)this, hangarInfo);
        hangarUpdateManager.checkForUpdates();
    }

    private void register_bStats() {
        Metrics metrics = new Metrics((Plugin)this, 16089);
        metrics.addCustomChart(new SimplePie("selected_language", this::getDefaultLanguageName));
    }

    @NotNull
    private String getDefaultLanguageName() {
        LanguageManager languageManager = this.getLanguageManager();
        Language defaultLanguage = languageManager.getDefaultLanguage();
        if (defaultLanguage == null) {
            return "none";
        }
        return defaultLanguage.getLanguageName();
    }
}

