/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class PlayerDataManager {
    private final Plugin plugin;
    private final Map<UUID, YamlConfiguration> configurationMap;

    public PlayerDataManager(@NotNull Plugin plugin) {
        this.plugin = plugin;
        this.configurationMap = new HashMap<UUID, YamlConfiguration>();
    }

    @NotNull
    private Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    private Logger getLogger() {
        Plugin plugin = this.getPlugin();
        return plugin.getLogger();
    }

    @NotNull
    public YamlConfiguration get(@NotNull OfflinePlayer player) {
        UUID playerId = player.getUniqueId();
        YamlConfiguration configuration = this.configurationMap.getOrDefault(playerId, null);
        if (configuration != null) {
            return configuration;
        }
        this.reload(player);
        return this.get(player);
    }

    public void save(@NotNull OfflinePlayer player) {
        UUID playerId = player.getUniqueId();
        YamlConfiguration configuration = this.configurationMap.getOrDefault(playerId, null);
        if (configuration == null) {
            return;
        }
        try {
            File file = this.getFile(player);
            configuration.save(file);
        }
        catch (IOException ex) {
            Logger logger = this.getLogger();
            String logMessage = "Failed to save data for player '" + String.valueOf(playerId) + "':";
            logger.log(Level.WARNING, logMessage, ex);
        }
    }

    public void reload(OfflinePlayer player) {
        UUID playerId = player.getUniqueId();
        try {
            YamlConfiguration configuration = this.load(player);
            this.configurationMap.put(playerId, configuration);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Logger logger = this.getLogger();
            String logMessage = "Failed to load data for player '" + String.valueOf(playerId) + "':";
            logger.log(Level.WARNING, logMessage, ex);
        }
    }

    public boolean hasData(@NotNull OfflinePlayer player) {
        File playerFile = this.getFile(player);
        return playerFile.exists();
    }

    private File getFile(@NotNull OfflinePlayer player) {
        Plugin plugin = this.getPlugin();
        File dataFolder = plugin.getDataFolder();
        File playerDataFolder = new File(dataFolder, "playerdata");
        UUID playerId = player.getUniqueId();
        String playerIdString = playerId.toString();
        String fileName = playerIdString + ".data.yml";
        return new File(playerDataFolder, fileName);
    }

    @NotNull
    private YamlConfiguration load(@NotNull OfflinePlayer player) throws IOException, InvalidConfigurationException {
        File playerFile = this.getFile(player);
        if (!playerFile.exists()) {
            return new YamlConfiguration();
        }
        YamlConfiguration configuration = new YamlConfiguration();
        configuration.load(playerFile);
        return configuration;
    }
}

