/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.configuration;

import com.github.sirblobman.api.configuration.IResourceHolder;
import com.github.sirblobman.api.configuration.WrapperPluginResourceHolder;
import com.github.sirblobman.api.utility.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigurationManager {
    private final File baseFolder;
    private final IResourceHolder resourceHolder;
    private final Map<String, YamlConfiguration> configurationMap;

    public ConfigurationManager(@NotNull Plugin plugin) {
        this(new WrapperPluginResourceHolder(plugin));
    }

    public ConfigurationManager(@NotNull IResourceHolder resourceHolder) {
        this.resourceHolder = resourceHolder;
        this.baseFolder = resourceHolder.getDataFolder();
        this.configurationMap = new HashMap<String, YamlConfiguration>();
    }

    @NotNull
    public IResourceHolder getResourceHolder() {
        return this.resourceHolder;
    }

    @NotNull
    public File getBaseFolder() {
        return this.baseFolder;
    }

    public void saveDefault(@NotNull String fileName) {
        File file = this.getFile(fileName);
        this.saveDefault(fileName, file);
    }

    @Nullable
    public YamlConfiguration getInternal(@NotNull String fileName) {
        IResourceHolder resourceHolder = this.getResourceHolder();
        InputStream inputStream = resourceHolder.getResource(fileName);
        if (inputStream == null) {
            return null;
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            YamlConfiguration configuration = new YamlConfiguration();
            configuration.load((Reader)inputStreamReader);
            return configuration;
        }
        catch (IOException | InvalidConfigurationException ex) {
            Logger logger = resourceHolder.getLogger();
            logger.log(Level.WARNING, "Failed to load internal configuration from classpath:", ex);
            return null;
        }
    }

    @NotNull
    public YamlConfiguration get(@NotNull String fileName) {
        YamlConfiguration configuration = this.configurationMap.getOrDefault(fileName, null);
        if (configuration != null) {
            return configuration;
        }
        this.reload(fileName);
        return this.configurationMap.computeIfAbsent(fileName, key -> new YamlConfiguration());
    }

    public void save(@NotNull String fileName) {
        try {
            YamlConfiguration configuration = this.configurationMap.getOrDefault(fileName, null);
            if (configuration == null) {
                return;
            }
            File file = this.getFile(fileName);
            configuration.save(file);
        }
        catch (IOException ex) {
            Logger logger = this.getResourceHolder().getLogger();
            logger.log(Level.WARNING, "An I/O exception occurred while saving a configuration file:", ex);
        }
    }

    public void reload(@NotNull String fileName) {
        File file = this.getFile(fileName);
        IResourceHolder resourceHolder = this.getResourceHolder();
        if (!file.exists() || !file.isFile()) {
            Logger logger = resourceHolder.getLogger();
            logger.warning("'" + fileName + "' could not be reloaded because it is not a file or does not exist!");
            return;
        }
        try {
            YamlConfiguration configuration = new YamlConfiguration();
            YamlConfiguration jarConfiguration = this.getInternal(fileName);
            if (jarConfiguration != null) {
                configuration.setDefaults((Configuration)jarConfiguration);
            }
            this.configurationMap.put(fileName, configuration);
            configuration.load(file);
        }
        catch (IOException | InvalidConfigurationException ex) {
            Logger logger = resourceHolder.getLogger();
            logger.log(Level.WARNING, "An I/O exception occurred while loading a configuration file:", ex);
            logger.log(Level.WARNING, "Using default configuration from jar file instead.");
        }
    }

    private File getFile(@NotNull String fileName) {
        Validate.notEmpty(fileName, "fileName must not be empty!");
        File baseFolder = this.getBaseFolder();
        return new File(baseFolder, fileName);
    }

    private void saveDefault(@NotNull String fileName, @NotNull File realFile) {
        Validate.notEmpty(fileName, "jarName must not be empty!");
        Validate.notNull(realFile, "realFile cannot be null!");
        if (realFile.exists()) {
            return;
        }
        IResourceHolder resourceHolder = this.getResourceHolder();
        InputStream jarStream = resourceHolder.getResource(fileName);
        if (jarStream == null) {
            Logger logger = resourceHolder.getLogger();
            logger.warning("Failed to save default config '" + fileName + "' because it does not exist in the jar.");
            return;
        }
        try {
            File parentFile = realFile.getParentFile();
            if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                Logger logger = resourceHolder.getLogger();
                logger.warning("Failed to save default config '" + fileName + "' because the parent folder could not be created.");
                return;
            }
            if (!realFile.createNewFile()) {
                Logger logger = resourceHolder.getLogger();
                logger.warning("Failed to save default config '" + fileName + "' because the file could not be created.");
                return;
            }
            Path absolutePath = realFile.toPath();
            Files.copy(jarStream, absolutePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            Logger logger = resourceHolder.getLogger();
            logger.log(Level.WARNING, "An I/O exception occurred while saving a default file:", ex);
        }
    }
}

