/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.command;

import com.github.sirblobman.api.language.LanguageManager;
import com.github.sirblobman.api.language.replacer.Replacer;
import com.github.sirblobman.api.language.replacer.StringReplacer;
import com.github.sirblobman.api.plugin.ConfigurablePlugin;
import com.github.sirblobman.api.shaded.adventure.audience.Audience;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.utility.ConfigurationHelper;
import com.github.sirblobman.api.utility.ItemUtility;
import com.github.sirblobman.api.utility.MessageUtility;
import com.github.sirblobman.api.utility.Validate;
import com.github.sirblobman.api.utility.VersionUtility;
import com.github.sirblobman.api.utility.paper.CommandData;
import com.github.sirblobman.api.utility.paper.PaperChecker;
import com.github.sirblobman.api.utility.paper.PaperHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Command
implements TabExecutor {
    private final JavaPlugin plugin;
    private final String commandName;
    private final Map<String, Command> subCommandMap;
    private Permission permission;

    public Command(@NotNull JavaPlugin plugin, @NotNull String commandName) {
        this.plugin = plugin;
        this.commandName = Validate.notEmpty(commandName, "commandName must not be empty!");
        this.subCommandMap = new HashMap<String, Command>();
        this.permission = null;
    }

    @NotNull
    public final String getCommandName() {
        return this.commandName;
    }

    @NotNull
    protected final JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    protected final Logger getLogger() {
        JavaPlugin plugin = this.getPlugin();
        return plugin.getLogger();
    }

    protected final void printDebug(@NotNull String message) {
        JavaPlugin plugin = this.getPlugin();
        FileConfiguration configuration = plugin.getConfig();
        if (configuration.getBoolean("debug-mode", false)) {
            Logger logger = this.getLogger();
            logger.info("[Debug] " + message);
        }
    }

    @Nullable
    protected LanguageManager getLanguageManager() {
        JavaPlugin plugin = this.getPlugin();
        if (!(plugin instanceof ConfigurablePlugin)) {
            return null;
        }
        ConfigurablePlugin configurablePlugin = (ConfigurablePlugin)plugin;
        return configurablePlugin.getLanguageManager();
    }

    public final void register() {
        String commandName = this.getCommandName();
        this.registerCustom(commandName);
    }

    private boolean isPaperPlugin() {
        if (PaperChecker.isPaper() && PaperChecker.hasPaperPluginSupport()) {
            boolean bl;
            block9: {
                JavaPlugin plugin = this.getPlugin();
                InputStream resource = plugin.getResource("paper-plugin.yml");
                try {
                    boolean bl2 = bl = resource != null;
                    if (resource == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (resource != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
                resource.close();
            }
            return bl;
        }
        return false;
    }

    public final void registerCustom(@NotNull String commandName) {
        JavaPlugin plugin = this.getPlugin();
        if (this.isPaperPlugin()) {
            this.printDebug("Detected Paper plugin.");
            this.printDebug("Attempting command map registration...");
            CommandData commandData = new CommandData(commandName, (CommandExecutor)this);
            InputStream resource = plugin.getResource("paper-plugin.yml");
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource));
            YamlConfiguration pluginFile = YamlConfiguration.loadConfiguration((Reader)reader);
            String description = pluginFile.getString("commands." + commandName + ".description", null);
            commandData.setDescription(description);
            String usage = pluginFile.getString("commands." + commandName + ".usage", null);
            commandData.setUsage(usage);
            List aliases = pluginFile.getStringList("commands." + commandName + ".aliases");
            if (!aliases.isEmpty()) {
                commandData.setAliases(aliases);
            }
            String permission = pluginFile.getString("commands." + commandName + ".permission", null);
            commandData.setPermission(permission);
            String permissionMessage = pluginFile.getString("commands." + commandName + ".permission-message", null);
            commandData.setPermissionMessage(permissionMessage);
            PaperHelper.registerCommand((Plugin)plugin, commandData);
            this.printDebug("Registered command '" + commandName + "' command map method.");
        } else {
            this.printDebug("Attempting to register with legacy Spigot method first...");
            PluginCommand pluginCommand = plugin.getCommand(commandName);
            if (pluginCommand == null) {
                this.printDebug("Plugin command '" + commandName + "' is not available.");
                return;
            }
            pluginCommand.setExecutor((CommandExecutor)this);
            pluginCommand.setTabCompleter((TabCompleter)this);
            this.printDebug("Registered command using classic Spigot method.");
        }
    }

    protected final void addSubCommand(@NotNull Command subCommand) {
        String subCommandName = subCommand.getCommandName();
        this.subCommandMap.putIfAbsent(subCommandName, subCommand);
    }

    @NotNull
    protected final Map<String, Command> getSubCommands() {
        return Collections.unmodifiableMap(this.subCommandMap);
    }

    @NotNull
    protected final List<String> getMatching(@NotNull String arg, @NotNull Iterable<String> values) {
        return MessageUtility.getMatches(arg, values);
    }

    @NotNull
    protected final List<String> getMatching(@NotNull String arg, String ... values) {
        List<String> valueList = Arrays.asList(values);
        return this.getMatching(arg, valueList);
    }

    protected final String @NotNull [] getSubArguments(String @NotNull [] original, int start) {
        if (original.length <= start) {
            return new String[0];
        }
        return Arrays.copyOfRange(original, start, original.length);
    }

    @NotNull
    protected final <E extends Enum<E>> Set<String> getEnumNames(@NotNull Class<E> enumClass) {
        return ConfigurationHelper.getEnumNames(enumClass);
    }

    @Nullable
    protected final <E extends Enum<E>> E matchEnum(@NotNull Class<E> enumClass, @NotNull String value) {
        return ConfigurationHelper.parseEnum(enumClass, value, null);
    }

    @NotNull
    protected final Collection<Player> getOnlinePlayers() {
        Collection onlinePlayerCollection = Bukkit.getOnlinePlayers();
        return Collections.unmodifiableCollection(onlinePlayerCollection);
    }

    @NotNull
    protected final Set<String> getOnlinePlayerNames() {
        Collection<Player> onlinePlayerCollection = this.getOnlinePlayers();
        HashSet<String> playerNameSet = new HashSet<String>();
        for (Player player : onlinePlayerCollection) {
            String playerName = player.getName();
            playerNameSet.add(playerName);
        }
        return Collections.unmodifiableSet(playerNameSet);
    }

    @Nullable
    protected final Location getLocation(CommandSender sender) {
        if (sender instanceof Entity) {
            Entity entity = (Entity)sender;
            return entity.getLocation();
        }
        if (sender instanceof BlockCommandSender) {
            BlockCommandSender blockSender = (BlockCommandSender)sender;
            Block block = blockSender.getBlock();
            return block.getLocation();
        }
        return null;
    }

    @NotNull
    protected final Audience getAudience(@NotNull CommandSender commandSender) {
        LanguageManager languageManager = this.getLanguageManager();
        if (languageManager == null) {
            return Audience.empty();
        }
        Audience audience = languageManager.getAudience(commandSender);
        if (audience == null) {
            return Audience.empty();
        }
        return audience;
    }

    @NotNull
    protected final Component getMessage(@Nullable CommandSender sender, @NotNull String key, Replacer ... replacerArray) {
        LanguageManager languageManager = this.getLanguageManager();
        if (languageManager == null) {
            return Component.text(key);
        }
        return languageManager.getMessage(sender, key, replacerArray);
    }

    protected final void sendMessage(@NotNull CommandSender sender, @NotNull String key, Replacer ... replacerArray) {
        LanguageManager languageManager = this.getLanguageManager();
        if (languageManager == null) {
            return;
        }
        languageManager.sendMessage(sender, key, replacerArray);
    }

    protected final void sendMessageWithPrefix(@NotNull CommandSender sender, @NotNull String key, Replacer ... replacerArray) {
        LanguageManager languageManager = this.getLanguageManager();
        if (languageManager == null) {
            return;
        }
        languageManager.sendMessageWithPrefix(sender, key, replacerArray);
    }

    protected final boolean checkPermission(@NotNull Permissible sender, @NotNull String permissionName, boolean sendMessage) {
        if (sender.hasPermission(permissionName)) {
            return true;
        }
        if (sendMessage && sender instanceof CommandSender) {
            CommandSender audience = (CommandSender)sender;
            this.sendNoPermissionMessage(audience, permissionName);
        }
        return false;
    }

    protected final boolean checkPermission(@NotNull Permissible sender, @NotNull Permission permission, boolean sendMessage) {
        if (sender.hasPermission(permission)) {
            return true;
        }
        if (sendMessage && sender instanceof CommandSender) {
            CommandSender audience = (CommandSender)sender;
            String permissionName = permission.getName();
            this.sendNoPermissionMessage(audience, permissionName);
        }
        return false;
    }

    private void sendNoPermissionMessage(@NotNull CommandSender sender, @NotNull String permissionName) {
        StringReplacer replacer = new StringReplacer("{permission}", permissionName);
        this.sendMessage(sender, "error.no-permission", replacer);
    }

    @Nullable
    protected final ItemStack getHeldItem(@NotNull Player player) {
        int minorVersion = VersionUtility.getMinorVersion();
        return minorVersion < 9 ? this.getHeldItemLegacy(player) : this.getHeldItemModern(player);
    }

    @Nullable
    private ItemStack getHeldItemLegacy(@NotNull Player player) {
        return player.getItemInHand();
    }

    @Nullable
    private ItemStack getHeldItemModern(@NotNull Player player) {
        PlayerInventory playerInventory = player.getInventory();
        return playerInventory.getItemInMainHand();
    }

    @Nullable
    protected final BigInteger parseInteger(@NotNull CommandSender sender, @NotNull String value) {
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException ex) {
            StringReplacer replacer = new StringReplacer("{value}", value);
            this.sendMessage(sender, "error.invalid-integer", replacer);
            return null;
        }
    }

    @Nullable
    protected final BigDecimal parseDecimal(@NotNull CommandSender sender, @NotNull String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException ex) {
            StringReplacer replacer = new StringReplacer("{value}", value);
            this.sendMessage(sender, "error.invalid-decimal", replacer);
            return null;
        }
    }

    @Nullable
    protected final Player findTarget(@NotNull CommandSender sender, @NotNull String targetName) {
        Player target = Bukkit.getPlayerExact((String)targetName);
        if (target != null) {
            return target;
        }
        StringReplacer replacer = new StringReplacer("{target}", targetName);
        this.sendMessage(sender, "error.invalid-target", replacer);
        return null;
    }

    protected final void giveItems(@NotNull Player player, ItemStack ... itemArray) {
        PlayerInventory playerInventory = player.getInventory();
        HashMap leftover = playerInventory.addItem(itemArray);
        if (leftover.isEmpty()) {
            return;
        }
        this.sendMessage((CommandSender)player, "error.inventory-full", new Replacer[0]);
        Collection<ItemStack> drops = leftover.values();
        Location location = player.getLocation();
        this.dropItems(location, drops);
    }

    protected final void dropItems(@NotNull Location location, @NotNull Iterable<ItemStack> drops) {
        World world = location.getWorld();
        Validate.notNull(world, "location must have a valid world!");
        for (ItemStack drop : drops) {
            if (ItemUtility.isAir(drop)) continue;
            world.dropItemNaturally(location, drop);
        }
    }

    @NotNull
    public final List<String> onTabComplete(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String label, String @NotNull [] args) {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> tabCompletionList = new ArrayList<String>();
        if (args.length == 1) {
            Map<String, Command> subCommandMap = this.getSubCommands();
            Set<Map.Entry<String, Command>> subCommandEntrySet = subCommandMap.entrySet();
            for (Map.Entry<String, Command> subCommandEntry : subCommandEntrySet) {
                String subCommandName = subCommandEntry.getKey();
                Command subCommand = subCommandEntry.getValue();
                Permission permission = subCommand.getPermission();
                if (permission != null && !this.checkPermission((Permissible)sender, permission, false)) continue;
                tabCompletionList.add(subCommandName);
            }
        }
        if (args.length > 1) {
            Permission permission;
            String subCommandName = args[0].toLowerCase(Locale.US);
            Map<String, Command> subCommandMap = this.getSubCommands();
            Command subCommand = subCommandMap.getOrDefault(subCommandName, null);
            if (subCommand != null && ((permission = subCommand.getPermission()) == null || this.checkPermission((Permissible)sender, permission, false))) {
                String[] newArgs = this.getSubArguments(args, 1);
                tabCompletionList.addAll(subCommand.onTabComplete(sender, command, label, newArgs));
            }
        }
        tabCompletionList.addAll(this.onTabComplete(sender, args));
        String currentArg = args[args.length - 1];
        return this.getMatching(currentArg, tabCompletionList);
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull org.bukkit.command.Command command, @NotNull String label, String @NotNull [] args) {
        Permission permission;
        if (args.length >= 1) {
            String subCommandName = args[0].toLowerCase(Locale.US);
            Map<String, Command> subCommandMap = this.getSubCommands();
            Command subCommand = subCommandMap.getOrDefault(subCommandName, null);
            if (subCommand != null) {
                String[] newArgs = this.getSubArguments(args, 1);
                return subCommand.onCommand(sender, command, label, newArgs);
            }
        }
        if ((permission = this.getPermission()) != null && !this.checkPermission((Permissible)sender, permission, true)) {
            return true;
        }
        return this.execute(sender, args);
    }

    @NotNull
    protected abstract List<String> onTabComplete(@NotNull CommandSender var1, String @NotNull [] var2);

    protected abstract boolean execute(@NotNull CommandSender var1, String @NotNull [] var2);

    @Nullable
    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(@Nullable Permission permission) {
        this.permission = permission;
    }

    public void setPermissionName(@Nullable String permissionName) {
        if (permissionName == null || permissionName.isEmpty()) {
            this.setPermission(null);
            return;
        }
        JavaPlugin plugin = this.getPlugin();
        PluginDescriptionFile pluginDescription = plugin.getDescription();
        List permissionList = pluginDescription.getPermissions();
        for (Permission loopPermission : permissionList) {
            String loopPermissionName = loopPermission.getName();
            if (!permissionName.equals(loopPermissionName)) continue;
            this.setPermission(loopPermission);
            return;
        }
        String pluginName = plugin.getName();
        String commandName = this.getCommandName();
        String description = "Permission for plugin '" + pluginName + "' command '/" + commandName + "'.";
        Permission permission = new Permission(permissionName, description, PermissionDefault.OP);
        this.setPermission(permission);
    }
}

