/*
 * Decompiled with CFR 0.152.
 */
package com.github.sirblobman.api.bossbar;

import com.github.sirblobman.api.shaded.adventure.audience.Audience;
import com.github.sirblobman.api.shaded.adventure.bossbar.BossBar;
import com.github.sirblobman.api.shaded.adventure.key.Key;
import com.github.sirblobman.api.shaded.adventure.platform.bukkit.BukkitAudiences;
import com.github.sirblobman.api.shaded.adventure.text.Component;
import com.github.sirblobman.api.utility.Validate;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.intellij.lang.annotations.Subst;
import org.jetbrains.annotations.NotNull;

public final class BossBarHandler {
    private final JavaPlugin plugin;
    private final BukkitAudiences audiences;
    private final Map<Key, BossBar> bossBarMap;
    private final Map<UUID, Audience> audienceMap;
    private final Component defaultTitle;

    public BossBarHandler(@NotNull JavaPlugin plugin) {
        this.plugin = plugin;
        this.audiences = BukkitAudiences.create((Plugin)plugin);
        this.bossBarMap = new ConcurrentHashMap<Key, BossBar>();
        this.audienceMap = new ConcurrentHashMap<UUID, Audience>();
        this.defaultTitle = Component.text("Default Title");
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public Component getDefaultTitle() {
        return this.defaultTitle;
    }

    @NotNull
    public Key getKey(@NotNull @Subst(value="key") String key) {
        JavaPlugin plugin = this.getPlugin();
        String pluginName = plugin.getName();
        String pluginNameKey = pluginName.toLowerCase(Locale.US);
        return Key.key(pluginNameKey, key);
    }

    @NotNull
    public Audience getAudience(@NotNull Player player) {
        Validate.notNull(player, "player must not be null!");
        UUID playerId = player.getUniqueId();
        return this.audienceMap.computeIfAbsent(playerId, key -> this.audiences.player(player));
    }

    @NotNull
    public BossBar getBossBar(@NotNull String key) {
        Key adventureKey = this.getKey(key);
        BossBar bossBar = this.bossBarMap.get(adventureKey);
        if (bossBar != null) {
            return bossBar;
        }
        Component defaultTitle = this.getDefaultTitle();
        BossBar newBossBar = BossBar.bossBar(defaultTitle, 1.0f, BossBar.Color.PURPLE, BossBar.Overlay.PROGRESS);
        this.bossBarMap.put(adventureKey, newBossBar);
        return newBossBar;
    }

    public void removeBossBar(@NotNull String key) {
        Key adventureKey = this.getKey(key);
        BossBar bossBar = this.bossBarMap.get(adventureKey);
        if (bossBar == null) {
            return;
        }
        Collection<Audience> audienceCollection = this.audienceMap.values();
        for (Audience audience : audienceCollection) {
            audience.hideBossBar(bossBar);
        }
        this.bossBarMap.remove(adventureKey);
    }

    public void showBossBar(@NotNull Player player, @NotNull String key) {
        BossBar bossBar = this.getBossBar(key);
        Audience audience = this.getAudience(player);
        audience.showBossBar(bossBar);
    }

    public void updateBossBar(@NotNull String key, @NotNull Component title, float progress, @NotNull BossBar.Color color, @NotNull BossBar.Overlay style) {
        BossBar bossBar = this.getBossBar(key);
        bossBar.name(title);
        bossBar.progress(progress);
        bossBar.color(color);
        bossBar.overlay(style);
    }

    public void addFlag(@NotNull String key, BossBar.Flag ... flags) {
        BossBar bossBar = this.getBossBar(key);
        bossBar.addFlags(flags);
    }

    public void removeFlag(@NotNull String key, BossBar.Flag ... flags) {
        BossBar bossBar = this.getBossBar(key);
        bossBar.removeFlags(flags);
    }
}

