/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import de.simonspeedy.friends.config.ConfigManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;

public class DatabaseManager {
    private final Logger logger;
    private final ConfigManager config;
    private HikariDataSource dataSource;
    private String tablePrefix;

    public DatabaseManager(ConfigManager config, Logger logger) {
        this.logger = logger;
        this.config = config;
    }

    public boolean connect() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            String host = this.config.getMySQLSetting("host", "localhost");
            int port = this.config.getMySQLSetting("port", 3306);
            String database = this.config.getMySQLSetting("database", "friends");
            String username = this.config.getMySQLSetting("username", "root");
            String password = this.config.getMySQLSetting("password", "password");
            int poolSize = this.config.getMySQLSetting("pool_size", 10);
            this.tablePrefix = this.config.getMySQLSetting("table_prefix", "friends_");
            HikariConfig hikariConfig = new HikariConfig();
            hikariConfig.setJdbcUrl("jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=false&allowPublicKeyRetrieval=true");
            hikariConfig.setUsername(username);
            hikariConfig.setPassword(password);
            hikariConfig.setMaximumPoolSize(poolSize);
            hikariConfig.setConnectionTimeout(30000L);
            hikariConfig.setLeakDetectionThreshold(60000L);
            hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            this.dataSource = new HikariDataSource(hikariConfig);
            this.logger.info("Successfully connected to MySQL database");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.logger.error("MySQL driver not found. Please ensure mysql-connector-j is in the classpath.", e);
            return false;
        }
        catch (Exception e) {
            this.logger.error("Failed to connect to MySQL database: " + e.getMessage());
            this.logger.error("Stack trace:", e);
            return false;
        }
    }

    public void createTables() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();){
            String friendshipsTable = "CREATE TABLE IF NOT EXISTS " + this.tablePrefix + "friendships (id INT AUTO_INCREMENT PRIMARY KEY,player_uuid VARCHAR(36) NOT NULL,friend_uuid VARCHAR(36) NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,UNIQUE KEY unique_friendship (player_uuid, friend_uuid),INDEX idx_player (player_uuid),INDEX idx_friend (friend_uuid))";
            String requestsTable = "CREATE TABLE IF NOT EXISTS " + this.tablePrefix + "pending_requests (id INT AUTO_INCREMENT PRIMARY KEY,sender_uuid VARCHAR(36) NOT NULL,receiver_uuid VARCHAR(36) NOT NULL,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,UNIQUE KEY unique_request (sender_uuid, receiver_uuid),INDEX idx_receiver (receiver_uuid))";
            String settingsTable = "CREATE TABLE IF NOT EXISTS " + this.tablePrefix + "player_settings (player_uuid VARCHAR(36) PRIMARY KEY,requests_enabled BOOLEAN DEFAULT TRUE,notifications_enabled BOOLEAN DEFAULT TRUE,messages_enabled BOOLEAN DEFAULT TRUE,status_message VARCHAR(255) DEFAULT NULL,updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)";
            String namesTable = "CREATE TABLE IF NOT EXISTS " + this.tablePrefix + "player_names (player_uuid VARCHAR(36) PRIMARY KEY,username VARCHAR(16) NOT NULL,last_seen TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP)";
            try (Statement stmt = conn.createStatement();){
                stmt.execute(friendshipsTable);
                stmt.execute(requestsTable);
                stmt.execute(settingsTable);
                stmt.execute(namesTable);
            }
        }
    }

    public boolean isConnected() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    public void disconnect() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.logger.info("Disconnected from MySQL database");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean addFriendship(UUID player, UUID friend) {
        String sql = "INSERT IGNORE INTO " + this.tablePrefix + "friendships (player_uuid, friend_uuid) VALUES (?, ?), (?, ?)";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, player.toString());
                    stmt.setString(2, friend.toString());
                    stmt.setString(3, friend.toString());
                    stmt.setString(4, player.toString());
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to add friendship", e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean removeFriendship(UUID player, UUID friend) {
        String sql = "DELETE FROM " + this.tablePrefix + "friendships WHERE (player_uuid = ? AND friend_uuid = ?) OR (player_uuid = ? AND friend_uuid = ?)";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, player.toString());
                    stmt.setString(2, friend.toString());
                    stmt.setString(3, friend.toString());
                    stmt.setString(4, player.toString());
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to remove friendship", e);
            return false;
        }
    }

    public Set<UUID> getFriends(UUID player) {
        HashSet<UUID> friends = new HashSet<UUID>();
        String sql = "SELECT friend_uuid FROM " + this.tablePrefix + "friendships WHERE player_uuid = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, player.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    friends.add(UUID.fromString(rs.getString("friend_uuid")));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to get friends", e);
        }
        return friends;
    }

    /*
     * Exception decompiling
     */
    public boolean areFriends(UUID player1, UUID player2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean addPendingRequest(UUID sender, UUID receiver) {
        String sql = "INSERT IGNORE INTO " + this.tablePrefix + "pending_requests (sender_uuid, receiver_uuid) VALUES (?, ?)";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, sender.toString());
                    stmt.setString(2, receiver.toString());
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to add pending request", e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean removePendingRequest(UUID sender, UUID receiver) {
        String sql = "DELETE FROM " + this.tablePrefix + "pending_requests WHERE sender_uuid = ? AND receiver_uuid = ?";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, sender.toString());
                    stmt.setString(2, receiver.toString());
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to remove pending request", e);
            return false;
        }
    }

    public Set<UUID> getPendingRequests(UUID receiver) {
        HashSet<UUID> senders = new HashSet<UUID>();
        String sql = "SELECT sender_uuid FROM " + this.tablePrefix + "pending_requests WHERE receiver_uuid = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, receiver.toString());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    senders.add(UUID.fromString(rs.getString("sender_uuid")));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to get pending requests", e);
        }
        return senders;
    }

    /*
     * Exception decompiling
     */
    public boolean hasPendingRequest(UUID sender, UUID receiver) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setRequestsEnabled(UUID player, boolean enabled) {
        String sql = "INSERT INTO " + this.tablePrefix + "player_settings (player_uuid, requests_enabled) VALUES (?, ?) ON DUPLICATE KEY UPDATE requests_enabled = ?";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, player.toString());
                    stmt.setBoolean(2, enabled);
                    stmt.setBoolean(3, enabled);
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to set requests enabled", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean areRequestsEnabled(UUID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setNotificationsEnabled(UUID player, boolean enabled) {
        String sql = "INSERT INTO " + this.tablePrefix + "player_settings (player_uuid, notifications_enabled) VALUES (?, ?) ON DUPLICATE KEY UPDATE notifications_enabled = ?";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, player.toString());
                    stmt.setBoolean(2, enabled);
                    stmt.setBoolean(3, enabled);
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to set notifications enabled", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean areNotificationsEnabled(UUID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setMessagesEnabled(UUID player, boolean enabled) {
        String sql = "INSERT INTO " + this.tablePrefix + "player_settings (player_uuid, messages_enabled) VALUES (?, ?) ON DUPLICATE KEY UPDATE messages_enabled = ?";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, player.toString());
                    stmt.setBoolean(2, enabled);
                    stmt.setBoolean(3, enabled);
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to set messages enabled", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean areMessagesEnabled(UUID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setStatusMessage(UUID player, String status) {
        String sql = "INSERT INTO " + this.tablePrefix + "player_settings (player_uuid, status_message) VALUES (?, ?) ON DUPLICATE KEY UPDATE status_message = ?";
        try (Connection conn = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    stmt.setString(1, player.toString());
                    stmt.setString(2, status);
                    stmt.setString(3, status);
                    boolean bl2 = bl = stmt.executeUpdate() > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to set status message", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public String getStatusMessage(UUID player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void updatePlayerName(UUID uuid, String username) {
        String sql = "INSERT INTO " + this.tablePrefix + "player_names (player_uuid, username) VALUES (?, ?) ON DUPLICATE KEY UPDATE username = ?, last_seen = CURRENT_TIMESTAMP";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.setString(2, username);
            stmt.setString(3, username);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("Failed to update player name", e);
        }
    }

    /*
     * Exception decompiling
     */
    public String getPlayerName(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

