/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.messaging;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import de.simonspeedy.friends.manager.FriendsManager;
import de.simonspeedy.friends.manager.PlayerSettingsManager;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;

public class PluginMessageHandler {
    public static final MinecraftChannelIdentifier CHANNEL = MinecraftChannelIdentifier.from((String)"friends:main");
    private final ProxyServer server;
    private final FriendsManager friendsManager;
    private final PlayerSettingsManager settingsManager;
    private final Logger logger;

    public PluginMessageHandler(ProxyServer server, FriendsManager friendsManager, PlayerSettingsManager settingsManager, Logger logger) {
        this.server = server;
        this.friendsManager = friendsManager;
        this.settingsManager = settingsManager;
        this.logger = logger;
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().equals((Object)CHANNEL)) {
            return;
        }
        Player player = null;
        if (event.getSource() instanceof Player) {
            player = (Player)event.getSource();
        } else if (event.getTarget() instanceof Player) {
            player = (Player)event.getTarget();
        }
        if (player == null) {
            this.logger.warn("[Friends Plugin Message] Received message but no player found. Source: {}, Target: {}", (Object)event.getSource().getClass().getSimpleName(), (Object)event.getTarget().getClass().getSimpleName());
            return;
        }
        event.setResult(PluginMessageEvent.ForwardResult.handled());
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])event.getData());
        String message = in.readUTF();
        String[] parts = message.split("\\|");
        if (parts.length == 0) {
            return;
        }
        String action = parts[0];
        try {
            switch (action) {
                case "GET_FRIENDS": {
                    this.handleGetFriends(player, parts);
                    break;
                }
                case "GET_ONLINE_FRIENDS": {
                    this.handleGetOnlineFriends(player, parts);
                    break;
                }
                case "GET_SETTINGS": {
                    this.handleGetSettings(player, parts);
                    break;
                }
                case "UPDATE_SETTING": {
                    this.handleUpdateSetting(player, parts);
                    break;
                }
                case "GET_PENDING_REQUESTS": {
                    this.handleGetPendingRequests(player, parts);
                    break;
                }
                case "ARE_FRIENDS": {
                    this.handleAreFriends(player, parts);
                    break;
                }
                default: {
                    this.logger.warn("Unknown plugin message action: {}", (Object)action);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error handling plugin message: {}", (Object)message, (Object)e);
        }
    }

    private void handleGetFriends(Player player, String[] parts) {
        if (parts.length < 2) {
            return;
        }
        UUID playerUUID = UUID.fromString(parts[1]);
        Set<UUID> friends = this.friendsManager.getFriends(playerUUID);
        StringBuilder response = new StringBuilder("FRIENDS_LIST|").append(playerUUID).append("|");
        for (UUID friendUUID : friends) {
            String friendName = this.friendsManager.getPlayerName(friendUUID);
            boolean online = this.server.getPlayer(friendUUID).isPresent();
            response.append(friendUUID).append(":").append(friendName).append(":").append(online).append("|");
        }
        this.sendMessage(player, response.toString());
    }

    private void handleGetOnlineFriends(Player player, String[] parts) {
        if (parts.length < 2) {
            return;
        }
        UUID playerUUID = UUID.fromString(parts[1]);
        Set<UUID> friends = this.friendsManager.getFriends(playerUUID);
        StringBuilder response = new StringBuilder("ONLINE_FRIENDS|").append(playerUUID).append("|");
        for (UUID friendUUID : friends) {
            Optional friendOpt = this.server.getPlayer(friendUUID);
            if (!friendOpt.isPresent()) continue;
            response.append(friendUUID).append(":").append(((Player)friendOpt.get()).getUsername()).append("|");
        }
        this.sendMessage(player, response.toString());
    }

    private void handleGetSettings(Player player, String[] parts) {
        if (parts.length < 2) {
            return;
        }
        UUID playerUUID = UUID.fromString(parts[1]);
        boolean requestsEnabled = this.settingsManager.areRequestsEnabled(playerUUID);
        boolean notificationsEnabled = this.settingsManager.areNotificationsEnabled(playerUUID);
        boolean messagesEnabled = this.settingsManager.areMessagesEnabled(playerUUID);
        String statusMessage = this.settingsManager.getStatusMessage(playerUUID);
        if (statusMessage == null) {
            statusMessage = "";
        }
        String response = String.format("SETTINGS|%s|%s|%s|%s|%s", playerUUID, requestsEnabled, notificationsEnabled, messagesEnabled, statusMessage);
        this.sendMessage(player, response);
    }

    private void handleUpdateSetting(Player player, String[] parts) {
        if (parts.length < 4) {
            return;
        }
        UUID playerUUID = UUID.fromString(parts[1]);
        String settingType = parts[2];
        String value = parts[3];
        boolean success = true;
        try {
            switch (settingType) {
                case "REQUESTS": {
                    this.settingsManager.setRequestsEnabled(playerUUID, Boolean.parseBoolean(value));
                    break;
                }
                case "NOTIFICATIONS": {
                    this.settingsManager.setNotificationsEnabled(playerUUID, Boolean.parseBoolean(value));
                    break;
                }
                case "MESSAGES": {
                    this.settingsManager.setMessagesEnabled(playerUUID, Boolean.parseBoolean(value));
                    break;
                }
                case "STATUS": {
                    this.settingsManager.setStatusMessage(playerUUID, value.isEmpty() ? null : value);
                    break;
                }
                default: {
                    success = false;
                    break;
                }
            }
        }
        catch (Exception e) {
            success = false;
            this.logger.error("Error updating setting", e);
        }
        String response = String.format("SETTING_UPDATED|%s|%s|%s", playerUUID, settingType, success);
        this.sendMessage(player, response);
        if (success) {
            this.server.getPlayer(playerUUID).ifPresent(p -> this.broadcastToPlayer((Player)p, String.format("SETTING_CHANGED|%s|%s|%s", playerUUID, settingType, value)));
        }
    }

    private void handleGetPendingRequests(Player player, String[] parts) {
        if (parts.length < 2) {
            return;
        }
        UUID playerUUID = UUID.fromString(parts[1]);
        Set<UUID> pendingRequests = this.friendsManager.getPendingRequests(playerUUID);
        StringBuilder response = new StringBuilder("PENDING_REQUESTS|").append(playerUUID).append("|");
        for (UUID senderUUID : pendingRequests) {
            String senderName = this.friendsManager.getPlayerName(senderUUID);
            response.append(senderUUID).append(":").append(senderName).append("|");
        }
        this.sendMessage(player, response.toString());
    }

    private void handleAreFriends(Player player, String[] parts) {
        if (parts.length < 3) {
            return;
        }
        UUID player1UUID = UUID.fromString(parts[1]);
        UUID player2UUID = UUID.fromString(parts[2]);
        boolean areFriends = this.friendsManager.areFriends(player1UUID, player2UUID);
        String response = String.format("FRIENDS_STATUS|%s|%s|%s", player1UUID, player2UUID, areFriends);
        this.sendMessage(player, response);
    }

    private void sendMessage(Player player, String message) {
        if (player.getCurrentServer().isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(message);
        ((ServerConnection)player.getCurrentServer().get()).sendPluginMessage((ChannelIdentifier)CHANNEL, out.toByteArray());
    }

    private void broadcastToPlayer(Player player, String message) {
        if (player.getCurrentServer().isEmpty()) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF(message);
        ((ServerConnection)player.getCurrentServer().get()).sendPluginMessage((ChannelIdentifier)CHANNEL, out.toByteArray());
    }

    public void notifyFriendOnline(UUID playerUUID, UUID friendUUID, String friendName) {
        this.server.getPlayer(playerUUID).ifPresent(player -> {
            String message = String.format("FRIEND_ONLINE|%s|%s|%s", playerUUID, friendUUID, friendName);
            this.sendMessage((Player)player, message);
        });
    }

    public void notifyFriendOffline(UUID playerUUID, UUID friendUUID, String friendName) {
        this.server.getPlayer(playerUUID).ifPresent(player -> {
            String message = String.format("FRIEND_OFFLINE|%s|%s|%s", playerUUID, friendUUID, friendName);
            this.sendMessage((Player)player, message);
        });
    }

    public void notifyFriendRequest(UUID receiverUUID, UUID senderUUID, String senderName) {
        this.server.getPlayer(receiverUUID).ifPresent(player -> {
            String message = String.format("FRIEND_REQUEST|%s|%s|%s", receiverUUID, senderUUID, senderName);
            this.sendMessage((Player)player, message);
        });
    }

    public void notifyFriendServerSwitch(UUID playerUUID, UUID friendUUID, String friendName, String serverName) {
        this.server.getPlayer(playerUUID).ifPresent(player -> {
            String message = String.format("FRIEND_SERVER_SWITCH|%s|%s|%s|%s", playerUUID, friendUUID, friendName, serverName);
            this.sendMessage((Player)player, message);
        });
    }
}

