/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.manager.FriendsManager;
import de.simonspeedy.friends.manager.MessageManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class MessageCommand
implements SimpleCommand {
    private final FriendsManager friendsManager;
    private final MessageManager messageManager;
    private final ProxyServer server;
    private final ConfigManager config;

    public MessageCommand(FriendsManager friendsManager, MessageManager messageManager, ProxyServer server, ConfigManager config) {
        this.friendsManager = friendsManager;
        this.messageManager = messageManager;
        this.server = server;
        this.config = config;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage(this.msg("console_cannot_use"));
            return;
        }
        Player sender = (Player)commandSource;
        String[] args = (String[])invocation.arguments();
        if (args.length < 2) {
            sender.sendMessage(this.msg("msg_usage"));
            return;
        }
        String targetName = args[0];
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        Optional targetOpt = this.server.getPlayer(targetName);
        if (targetOpt.isEmpty()) {
            sender.sendMessage(this.msg("player_not_online", Map.of("player", targetName)));
            return;
        }
        Player target = (Player)targetOpt.get();
        if (sender.getUniqueId().equals(target.getUniqueId())) {
            sender.sendMessage(this.msg("msg_cannot_message_self"));
            return;
        }
        if (this.config.getSetting("only_friends_can_message", true) && !this.friendsManager.areFriends(sender.getUniqueId(), target.getUniqueId())) {
            sender.sendMessage(this.msg("msg_not_friends", Map.of("player", target.getUsername())));
            return;
        }
        String senderFormat = this.config.getMessage("msg_format_sender", Map.of("player", target.getUsername(), "message", message));
        String receiverFormat = this.config.getMessage("msg_format_receiver", Map.of("player", sender.getUsername(), "message", message));
        sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(senderFormat));
        target.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(receiverFormat));
        this.messageManager.setLastSender(target.getUniqueId(), sender.getUniqueId());
        this.messageManager.setLastSender(sender.getUniqueId(), target.getUniqueId());
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0 || args.length == 1) {
            CommandSource commandSource = invocation.source();
            if (!(commandSource instanceof Player)) {
                return List.of();
            }
            Player player = (Player)commandSource;
            Set<UUID> friends = this.friendsManager.getFriends(player.getUniqueId());
            return friends.stream().map(uuid -> this.server.getPlayer(uuid)).filter(Optional::isPresent).map(opt -> ((Player)opt.get()).getUsername()).filter(name -> args.length == 0 || name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
        }
        return List.of();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return true;
    }

    private Component msg(String key) {
        return this.msg(key, new HashMap<String, String>());
    }

    private Component msg(String key, Map<String, String> replacements) {
        String message = this.config.getMessage(key, replacements);
        return LegacyComponentSerializer.legacySection().deserialize(message);
    }
}

