/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.storage.DatabaseManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;

public class PlayerSettingsManager {
    private final Path dataDirectory;
    private final Logger logger;
    private final Gson gson;
    private final Map<UUID, PlayerSettings> settings;
    private File dataFile;
    private final boolean useMySql;
    private final DatabaseManager databaseManager;

    public PlayerSettingsManager(Path dataDirectory, Logger logger, ConfigManager configManager, DatabaseManager databaseManager) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.settings = new ConcurrentHashMap<UUID, PlayerSettings>();
        String storageType = configManager.getSetting("storage_type", "json");
        this.useMySql = "mysql".equalsIgnoreCase(storageType);
        this.databaseManager = databaseManager;
    }

    public void load() {
        block11: {
            if (this.useMySql) {
                this.logger.info("Player settings will be stored in MySQL database");
                return;
            }
            try {
                File dir = this.dataDirectory.toFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                this.dataFile = new File(dir, "player_settings.json");
                if (this.dataFile.exists()) {
                    try (FileReader reader = new FileReader(this.dataFile);){
                        Type type = new TypeToken<Map<String, PlayerSettings>>(){}.getType();
                        Map data = (Map)this.gson.fromJson((Reader)reader, type);
                        if (data != null) {
                            data.forEach((key, value) -> {
                                UUID playerUUID = UUID.fromString(key);
                                this.settings.put(playerUUID, (PlayerSettings)value);
                            });
                        }
                        this.logger.info("Loaded player settings: {} players", (Object)this.settings.size());
                        break block11;
                    }
                }
                this.dataFile.createNewFile();
                this.logger.info("Created new player settings file");
            }
            catch (IOException e) {
                this.logger.error("Failed to load player settings", e);
            }
        }
    }

    public void save() {
        if (this.useMySql) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.dataFile);){
            HashMap data = new HashMap();
            this.settings.forEach((key, value) -> data.put(key.toString(), value));
            this.gson.toJson(data, (Appendable)writer);
        }
        catch (IOException e) {
            this.logger.error("Failed to save player settings", e);
        }
    }

    public boolean areRequestsEnabled(UUID player) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.areRequestsEnabled(player);
        }
        return this.settings.getOrDefault((Object)player, (PlayerSettings)new PlayerSettings()).requestsEnabled;
    }

    public void setRequestsEnabled(UUID player, boolean enabled) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            this.databaseManager.setRequestsEnabled(player, enabled);
        } else {
            this.settings.computeIfAbsent((UUID)player, (Function<UUID, PlayerSettings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setRequestsEnabled$2(java.util.UUID ), (Ljava/util/UUID;)Lde/simonspeedy/friends/manager/PlayerSettingsManager$PlayerSettings;)()).requestsEnabled = enabled;
            this.save();
        }
    }

    public boolean areNotificationsEnabled(UUID player) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.areNotificationsEnabled(player);
        }
        return this.settings.getOrDefault((Object)player, (PlayerSettings)new PlayerSettings()).notificationsEnabled;
    }

    public void setNotificationsEnabled(UUID player, boolean enabled) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            this.databaseManager.setNotificationsEnabled(player, enabled);
        } else {
            this.settings.computeIfAbsent((UUID)player, (Function<UUID, PlayerSettings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setNotificationsEnabled$3(java.util.UUID ), (Ljava/util/UUID;)Lde/simonspeedy/friends/manager/PlayerSettingsManager$PlayerSettings;)()).notificationsEnabled = enabled;
            this.save();
        }
    }

    public boolean areMessagesEnabled(UUID player) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.areMessagesEnabled(player);
        }
        return this.settings.getOrDefault((Object)player, (PlayerSettings)new PlayerSettings()).messagesEnabled;
    }

    public void setMessagesEnabled(UUID player, boolean enabled) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            this.databaseManager.setMessagesEnabled(player, enabled);
        } else {
            this.settings.computeIfAbsent((UUID)player, (Function<UUID, PlayerSettings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setMessagesEnabled$4(java.util.UUID ), (Ljava/util/UUID;)Lde/simonspeedy/friends/manager/PlayerSettingsManager$PlayerSettings;)()).messagesEnabled = enabled;
            this.save();
        }
    }

    public String getStatusMessage(UUID player) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.getStatusMessage(player);
        }
        PlayerSettings ps = this.settings.get(player);
        return ps != null ? ps.statusMessage : null;
    }

    public void setStatusMessage(UUID player, String status) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            this.databaseManager.setStatusMessage(player, status);
        } else {
            this.settings.computeIfAbsent((UUID)player, (Function<UUID, PlayerSettings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setStatusMessage$5(java.util.UUID ), (Ljava/util/UUID;)Lde/simonspeedy/friends/manager/PlayerSettingsManager$PlayerSettings;)()).statusMessage = status;
            this.save();
        }
    }

    private static /* synthetic */ PlayerSettings lambda$setStatusMessage$5(UUID k) {
        return new PlayerSettings();
    }

    private static /* synthetic */ PlayerSettings lambda$setMessagesEnabled$4(UUID k) {
        return new PlayerSettings();
    }

    private static /* synthetic */ PlayerSettings lambda$setNotificationsEnabled$3(UUID k) {
        return new PlayerSettings();
    }

    private static /* synthetic */ PlayerSettings lambda$setRequestsEnabled$2(UUID k) {
        return new PlayerSettings();
    }

    public static class PlayerSettings {
        public boolean requestsEnabled = true;
        public boolean notificationsEnabled = true;
        public boolean messagesEnabled = true;
        public String statusMessage = null;
    }
}

