/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private final Path dataDirectory;
    private final Logger logger;
    private Map<String, Object> config;
    private File configFile;

    public ConfigManager(Path dataDirectory, Logger logger) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.config = new HashMap<String, Object>();
    }

    public void load() {
        try {
            Map<String, Object> defaults;
            boolean configUpdated;
            boolean isNewConfig;
            File dir = this.dataDirectory.toFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.configFile = new File(dir, "config.yml");
            boolean bl = isNewConfig = !this.configFile.exists();
            if (isNewConfig) {
                this.createDefaultConfig();
            }
            Yaml yaml = new Yaml();
            try (FileInputStream fis = new FileInputStream(this.configFile);){
                this.config = (Map)yaml.load(fis);
                if (this.config == null) {
                    this.config = new HashMap<String, Object>();
                }
            }
            if (!isNewConfig && (configUpdated = this.mergeConfigs(this.config, defaults = this.getDefaultConfig()))) {
                this.saveConfig();
                this.logger.info("Configuration updated with new keys");
            }
            this.logger.info("Configuration loaded successfully");
        }
        catch (IOException e) {
            this.logger.error("Failed to load configuration", e);
            this.config = new HashMap<String, Object>();
        }
    }

    private boolean mergeConfigs(Map<String, Object> current, Map<String, Object> defaults) {
        boolean updated = false;
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            boolean nestedUpdated;
            String key = entry.getKey();
            Object defaultValue = entry.getValue();
            if (!current.containsKey(key)) {
                current.put(key, defaultValue);
                updated = true;
                continue;
            }
            if (!(defaultValue instanceof Map) || !(current.get(key) instanceof Map) || !(nestedUpdated = this.mergeConfigs((Map)current.get(key), (Map)defaultValue))) continue;
            updated = true;
        }
        return updated;
    }

    private void saveConfig() {
        try {
            String defaultStructure = this.getDefaultConfigStructure();
            String updatedConfig = this.updateConfigValues(defaultStructure);
            try (FileWriter writer = new FileWriter(this.configFile);){
                writer.write(updatedConfig);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save configuration", e);
        }
    }

    private String getDefaultConfigStructure() {
        StringBuilder defaultConfig = new StringBuilder();
        defaultConfig.append("# Friends Plugin Configuration\n");
        defaultConfig.append("# Author: SimolZimol\n\n");
        defaultConfig.append("# Message Settings\n");
        defaultConfig.append("messages:\n");
        defaultConfig.append("  prefix: \"&6[Friends] &r\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Friend Request Messages\n");
        defaultConfig.append("  request_sent: \"Friend request sent to {player}!\"\n");
        defaultConfig.append("  request_received: \"&6{player} &ewants to be your friend!\"\n");
        defaultConfig.append("  request_accepted: \"You are now friends with {player}!\"\n");
        defaultConfig.append("  request_accepted_sender: \"&a{player} accepted your friend request!\"\n");
        defaultConfig.append("  request_denied: \"Friend request from {player} denied.\"\n");
        defaultConfig.append("  request_denied_sender: \"&c{player} denied your friend request.\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Friend Management\n");
        defaultConfig.append("  friend_removed: \"You removed {player} from your friends list.\"\n");
        defaultConfig.append("  friend_removed_target: \"&c{player} removed you from their friends list.\"\n");
        defaultConfig.append("  friend_online: \"&a\u25c6 &6{player} &ais now online!\"\n");
        defaultConfig.append("  friend_offline: \"&c\u25c6 &6{player} &cis now offline.\"\n");
        defaultConfig.append("  friend_server_switch: \"&e\u25c6 &6{player} &ejoined &b{server}\"\n");
        defaultConfig.append("  friend_server_info: \"&7(&b{server}&7)\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Status Messages\n");
        defaultConfig.append("  no_friends: \"You have no friends :(\"\n");
        defaultConfig.append("  friends_list_header: \"&6&lYour Friends ({count}):\"\n");
        defaultConfig.append("  friends_online: \"&a\u25cf Online ({count}):\"\n");
        defaultConfig.append("  friends_offline: \"&7\u25cf Offline ({count}):\"\n");
        defaultConfig.append("  pending_requests_header: \"&6&lPending Requests ({count}):\"\n");
        defaultConfig.append("  no_pending_requests: \"You have no pending friend requests.\"\n");
        defaultConfig.append("  pending_requests_notification: \"You have &6{count} &epending friend request(s)!\\n&7Use &6/friend requests &7to view them.\"\n");
        defaultConfig.append("  friends_online_count: \"&a\u25c6 &6{online} &7of &6{total} &7friends are online!\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Error Messages\n");
        defaultConfig.append("  player_not_online: \"Player {player} is not online!\"\n");
        defaultConfig.append("  cannot_add_self: \"You cannot add yourself as a friend!\"\n");
        defaultConfig.append("  already_friends: \"You are already friends with {player}!\"\n");
        defaultConfig.append("  already_sent_request: \"&e{player} already sent you a friend request! Use /friend accept {player}\"\n");
        defaultConfig.append("  not_friends: \"You are not friends with {player}!\"\n");
        defaultConfig.append("  no_pending_request: \"No pending request from {player}!\"\n");
        defaultConfig.append("  console_cannot_use: \"This command can only be used by players!\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Help Messages\n");
        defaultConfig.append("  help_header: \"&6&lFriends Plugin Help\"\n");
        defaultConfig.append("  help_add: \"&e/friend add <player> &7- Send a friend request\"\n");
        defaultConfig.append("  help_accept: \"&e/friend accept <player> &7- Accept a request\"\n");
        defaultConfig.append("  help_deny: \"&e/friend deny <player> &7- Deny a request\"\n");
        defaultConfig.append("  help_remove: \"&e/friend remove <player> &7- Remove a friend\"\n");
        defaultConfig.append("  help_list: \"&e/friend list &7- Show your friends list\"\n");
        defaultConfig.append("  help_requests: \"&e/friend requests &7- Show pending requests\"\n");
        defaultConfig.append("  help_msg: \"&e/friend msg <player> <message> &7- Send a private message\"\n");
        defaultConfig.append("  help_reply: \"&e/friend reply <message> &7- Reply to last message\"\n");
        defaultConfig.append("  help_settings: \"&e/friend settings &7- Configure your settings\"\n");
        defaultConfig.append("  help_status: \"&e/friend status <message> &7- Set your status message\"\n");
        defaultConfig.append("  help_broadcast: \"&e/friend broadcast <msg> &7- Send message to all friends\"\n");
        defaultConfig.append("  help_reload: \"&e/friend reload &7- Reload the plugin configuration\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Usage Messages\n");
        defaultConfig.append("  usage_add: \"Usage: /friend add <player>\"\n");
        defaultConfig.append("  usage_accept: \"Usage: /friend accept <player>\"\n");
        defaultConfig.append("  usage_deny: \"Usage: /friend deny <player>\"\n");
        defaultConfig.append("  usage_remove: \"Usage: /friend remove <player>\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Button Labels\n");
        defaultConfig.append("  button_accept: \"&a&l[Accept]\"\n");
        defaultConfig.append("  button_deny: \"&c&l[Deny]\"\n");
        defaultConfig.append("  button_checkmark: \"&a[\u2713]\"\n");
        defaultConfig.append("  button_cross: \"&c[\u2717]\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Decorations\n");
        defaultConfig.append("  separator: \"&7\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Messaging System\n");
        defaultConfig.append("  msg_format_sender: \"&d&l[MSG] &7To &6{player}&7: &f{message}\"\n");
        defaultConfig.append("  msg_format_receiver: \"&d&l[MSG] &7From &6{player}&7: &f{message}\"\n");
        defaultConfig.append("  msg_usage: \"Usage: /friend msg <player> <message>\"\n");
        defaultConfig.append("  msg_cannot_message_self: \"You cannot message yourself!\"\n");
        defaultConfig.append("  msg_not_friends: \"You can only message friends! Add {player} as a friend first.\"\n");
        defaultConfig.append("  msg_not_friends_hover: \"Click to send a friend request to {player}\"\n");
        defaultConfig.append("  reply_usage: \"Usage: /friend reply <message>\"\n");
        defaultConfig.append("  reply_no_one: \"You have no one to reply to!\"\n");
        defaultConfig.append("  reply_player_offline: \"That player is no longer online!\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Settings & Toggle\n");
        defaultConfig.append("  toggle_requests_enabled: \"&aFriend requests enabled!\"\n");
        defaultConfig.append("  toggle_requests_disabled: \"&cFriend requests disabled!\"\n");
        defaultConfig.append("  toggle_notifications_enabled: \"&aFriend notifications enabled!\"\n");
        defaultConfig.append("  toggle_notifications_disabled: \"&cFriend notifications disabled!\"\n");
        defaultConfig.append("  toggle_messages_enabled: \"&aPrivate messages enabled!\"\n");
        defaultConfig.append("  toggle_messages_disabled: \"&cPrivate messages disabled!\"\n");
        defaultConfig.append("  requests_disabled_target: \"&c{player} has friend requests disabled!\"\n");
        defaultConfig.append("  messages_disabled_target: \"&c{player} has private messages disabled!\"\n");
        defaultConfig.append("  status_set: \"Status set to: &e{status}\"\n");
        defaultConfig.append("  status_cleared: \"Status message cleared!\"\n");
        defaultConfig.append("  status_display: \"&7Status: &e{status}\"\n");
        defaultConfig.append("  broadcast_usage: \"Usage: /friend broadcast <message>\"\n");
        defaultConfig.append("  broadcast_sent: \"&aBroadcast sent to {count} friend(s)!\"\n");
        defaultConfig.append("  broadcast_format: \"&6&l[BROADCAST] &6{player}&7: &f{message}\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Settings Menu\n");
        defaultConfig.append("  settings_header: \"&6&lFriend Settings\"\n");
        defaultConfig.append("  settings_requests: \"  {icon} &eFriend Requests: {status}\"\n");
        defaultConfig.append("  settings_notifications: \"  {icon} &eJoin/Leave Notifications: {status}\"\n");
        defaultConfig.append("  settings_messages: \"  {icon} &ePrivate Messages: {status}\"\n");
        defaultConfig.append("  settings_usage: \"&7Use &e/friend settings <requests|notifications|messages> &7to toggle\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Status Translations\n");
        defaultConfig.append("  status_enabled: \"&aEnabled\"\n");
        defaultConfig.append("  status_disabled: \"&cDisabled\"\n");
        defaultConfig.append("\n");
        defaultConfig.append("# Feature Settings\n");
        defaultConfig.append("settings:\n");
        defaultConfig.append("  # Show join/leave notifications\n");
        defaultConfig.append("  notify_on_join: true\n");
        defaultConfig.append("  notify_on_leave: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show notifications when friends switch servers\n");
        defaultConfig.append("  notify_on_server_switch: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show online friends count on login\n");
        defaultConfig.append("  show_online_count: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show pending requests notification on login\n");
        defaultConfig.append("  notify_pending_requests: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Maximum number of friends per player (0 = unlimited)\n");
        defaultConfig.append("  max_friends: 0\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Only friends can message each other\n");
        defaultConfig.append("  only_friends_can_message: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show prefix for help menus, lists, and separators\n");
        defaultConfig.append("  use_prefix_for_lists: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Storage type: 'json' or 'mysql'\n");
        defaultConfig.append("  storage_type: 'json'\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable additional command aliases\n");
        defaultConfig.append("  enable_msg_alias: false\n");
        defaultConfig.append("  enable_tell_alias: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable reply command aliases\n");
        defaultConfig.append("  enable_r_alias: false\n");
        defaultConfig.append("  enable_reply_alias: false\n");
        defaultConfig.append("  enable_respond_alias: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable friend message command aliases\n");
        defaultConfig.append("  enable_message_alias: false\n");
        defaultConfig.append("  enable_whisper_alias: false\n");
        defaultConfig.append("  enable_pm_alias: false\n");
        defaultConfig.append("\n");
        defaultConfig.append("# MySQL Settings (only used if storage_type is 'mysql')\n");
        defaultConfig.append("mysql:\n");
        defaultConfig.append("  host: 'localhost'\n");
        defaultConfig.append("  port: 3306\n");
        defaultConfig.append("  database: 'friends'\n");
        defaultConfig.append("  username: 'root'\n");
        defaultConfig.append("  password: 'password'\n");
        defaultConfig.append("  # Connection pool settings\n");
        defaultConfig.append("  pool_size: 10\n");
        defaultConfig.append("  # Table prefix\n");
        defaultConfig.append("  table_prefix: 'friends_'\n");
        return defaultConfig.toString();
    }

    private String updateConfigValues(String template) {
        Map map;
        Map settings;
        String result = template;
        Map messages = (Map)this.config.get("messages");
        if (messages != null) {
            for (Map.Entry entry : messages.entrySet()) {
                String string = (String)entry.getKey();
                String value = entry.getValue().toString();
                value = value.replace("\\", "\\\\").replace("$", "\\$");
                result = result.replaceFirst("(?m)^(\\s*" + string + ":\\s*)['\"].*['\"]", "$1\"" + value + "\"");
            }
        }
        if ((settings = (Map)this.config.get("settings")) != null) {
            for (Map.Entry entry : settings.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Object valueStr = value instanceof String ? "'" + String.valueOf(value) + "'" : value.toString();
                result = result.replaceFirst("(?m)^(\\s*" + key + ":\\s*).*$", "$1" + (String)valueStr);
            }
        }
        if ((map = (Map)this.config.get("mysql")) != null) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Object valueStr = value instanceof String ? "'" + String.valueOf(value) + "'" : value.toString();
                result = result.replaceFirst("(?m)^(\\s*" + key + ":\\s*).*$", "$1" + (String)valueStr);
            }
        }
        return result;
    }

    private Map<String, Object> getDefaultConfig() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put("prefix", "&6[Friends] &r");
        messages.put("request_sent", "Friend request sent to {player}!");
        messages.put("request_received", "&6{player} &ewants to be your friend!");
        messages.put("request_accepted", "You are now friends with {player}!");
        messages.put("request_accepted_sender", "&a{player} accepted your friend request!");
        messages.put("request_denied", "Friend request from {player} denied.");
        messages.put("request_denied_sender", "&c{player} denied your friend request.");
        messages.put("friend_removed", "You removed {player} from your friends list.");
        messages.put("friend_removed_target", "&c{player} removed you from their friends list.");
        messages.put("friend_online", "&a\u25c6 &6{player} &ais now online!");
        messages.put("friend_offline", "&c\u25c6 &6{player} &cis now offline.");
        messages.put("friend_server_switch", "&e\u25c6 &6{player} &ejoined &b{server}");
        messages.put("friend_server_info", "&7(&b{server}&7)");
        messages.put("no_friends", "You have no friends :(");
        messages.put("friends_list_header", "&6&lYour Friends ({count}):");
        messages.put("friends_online", "&a\u25cf Online ({count}):");
        messages.put("friends_offline", "&7\u25cf Offline ({count}):");
        messages.put("pending_requests_header", "&6&lPending Requests ({count}):");
        messages.put("no_pending_requests", "You have no pending friend requests.");
        messages.put("pending_requests_notification", "You have &6{count} &epending friend request(s)!\\n&7Use &6/friend requests &7to view them.");
        messages.put("friends_online_count", "&a\u25c6 &6{online} &7of &6{total} &7friends are online!");
        messages.put("player_not_online", "Player {player} is not online!");
        messages.put("cannot_add_self", "You cannot add yourself as a friend!");
        messages.put("already_friends", "You are already friends with {player}!");
        messages.put("already_sent_request", "&e{player} already sent you a friend request! Use /friend accept {player}");
        messages.put("not_friends", "You are not friends with {player}!");
        messages.put("no_pending_request", "No pending request from {player}!");
        messages.put("console_cannot_use", "This command can only be used by players!");
        messages.put("help_header", "&6&lFriends Plugin Help");
        messages.put("help_add", "&e/friend add <player> &7- Send a friend request");
        messages.put("help_accept", "&e/friend accept <player> &7- Accept a request");
        messages.put("help_deny", "&e/friend deny <player> &7- Deny a request");
        messages.put("help_remove", "&e/friend remove <player> &7- Remove a friend");
        messages.put("help_list", "&e/friend list &7- Show your friends list");
        messages.put("help_requests", "&e/friend requests &7- Show pending requests");
        messages.put("help_msg", "&e/friend msg <player> <message> &7- Send a private message");
        messages.put("help_reply", "&e/friend reply <message> &7- Reply to last message");
        messages.put("help_settings", "&e/friend settings &7- Configure your settings");
        messages.put("help_status", "&e/friend status <message> &7- Set your status message");
        messages.put("help_broadcast", "&e/friend broadcast <msg> &7- Send message to all friends");
        messages.put("help_reload", "&e/friend reload &7- Reload the plugin configuration");
        messages.put("usage_add", "Usage: /friend add <player>");
        messages.put("usage_accept", "Usage: /friend accept <player>");
        messages.put("usage_deny", "Usage: /friend deny <player>");
        messages.put("usage_remove", "Usage: /friend remove <player>");
        messages.put("button_accept", "&a&l[Accept]");
        messages.put("button_deny", "&c&l[Deny]");
        messages.put("button_checkmark", "&a[\u2713]");
        messages.put("button_cross", "&c[\u2717]");
        messages.put("separator", "&7\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        messages.put("msg_format_sender", "&d&l[MSG] &7To &6{player}&7: &f{message}");
        messages.put("msg_format_receiver", "&d&l[MSG] &7From &6{player}&7: &f{message}");
        messages.put("msg_usage", "Usage: /friend msg <player> <message>");
        messages.put("msg_cannot_message_self", "You cannot message yourself!");
        messages.put("msg_not_friends", "You can only message friends! Add {player} as a friend first.");
        messages.put("msg_not_friends_hover", "Click to send a friend request to {player}");
        messages.put("reply_usage", "Usage: /friend reply <message>");
        messages.put("reply_no_one", "You have no one to reply to!");
        messages.put("reply_player_offline", "That player is no longer online!");
        messages.put("toggle_requests_enabled", "&aFriend requests enabled!");
        messages.put("toggle_requests_disabled", "&cFriend requests disabled!");
        messages.put("toggle_notifications_enabled", "&aFriend notifications enabled!");
        messages.put("toggle_notifications_disabled", "&cFriend notifications disabled!");
        messages.put("toggle_messages_enabled", "&aPrivate messages enabled!");
        messages.put("toggle_messages_disabled", "&cPrivate messages disabled!");
        messages.put("requests_disabled_target", "&c{player} has friend requests disabled!");
        messages.put("messages_disabled_target", "&c{player} has private messages disabled!");
        messages.put("status_set", "Status set to: &e{status}");
        messages.put("status_cleared", "Status message cleared!");
        messages.put("status_display", "&7Status: &e{status}");
        messages.put("broadcast_usage", "Usage: /friend broadcast <message>");
        messages.put("broadcast_sent", "&aBroadcast sent to {count} friend(s)!");
        messages.put("broadcast_format", "&6&l[BROADCAST] &6{player}&7: &f{message}");
        messages.put("settings_header", "&6&lFriend Settings");
        messages.put("settings_requests", "  {icon} &eFriend Requests: {status}");
        messages.put("settings_notifications", "  {icon} &eJoin/Leave Notifications: {status}");
        messages.put("settings_messages", "  {icon} &ePrivate Messages: {status}");
        messages.put("settings_usage", "&7Use &e/friend settings <requests|notifications|messages> &7to toggle");
        messages.put("status_enabled", "&aEnabled");
        messages.put("status_disabled", "&cDisabled");
        defaults.put("messages", messages);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("notify_on_join", true);
        settings.put("notify_on_leave", true);
        settings.put("notify_on_server_switch", false);
        settings.put("show_online_count", true);
        settings.put("notify_pending_requests", true);
        settings.put("max_friends", 0);
        settings.put("only_friends_can_message", true);
        settings.put("use_prefix_for_lists", false);
        settings.put("storage_type", "json");
        settings.put("enable_msg_alias", false);
        settings.put("enable_tell_alias", false);
        settings.put("enable_r_alias", false);
        settings.put("enable_reply_alias", false);
        settings.put("enable_respond_alias", false);
        settings.put("enable_message_alias", false);
        settings.put("enable_whisper_alias", false);
        settings.put("enable_pm_alias", false);
        settings.put("enable_f_alias", true);
        defaults.put("settings", settings);
        HashMap<String, Object> mysql = new HashMap<String, Object>();
        mysql.put("host", "localhost");
        mysql.put("port", 3306);
        mysql.put("database", "friends");
        mysql.put("username", "root");
        mysql.put("password", "password");
        mysql.put("pool_size", 10);
        mysql.put("table_prefix", "friends_");
        defaults.put("mysql", mysql);
        return defaults;
    }

    private void createDefaultConfig() throws IOException {
        this.configFile.createNewFile();
        StringBuilder defaultConfig = new StringBuilder();
        defaultConfig.append("# Friends Plugin Configuration\n");
        defaultConfig.append("# Author: SimolZimol\n\n");
        defaultConfig.append("# Message Settings\n");
        defaultConfig.append("messages:\n");
        defaultConfig.append("  prefix: \"&6[Friends] &r\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Friend Request Messages\n");
        defaultConfig.append("  request_sent: \"Friend request sent to {player}!\"\n");
        defaultConfig.append("  request_received: \"&6{player} &ewants to be your friend!\"\n");
        defaultConfig.append("  request_accepted: \"You are now friends with {player}!\"\n");
        defaultConfig.append("  request_accepted_sender: \"&a{player} accepted your friend request!\"\n");
        defaultConfig.append("  request_denied: \"Friend request from {player} denied.\"\n");
        defaultConfig.append("  request_denied_sender: \"&c{player} denied your friend request.\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Friend Management\n");
        defaultConfig.append("  friend_removed: \"You removed {player} from your friends list.\"\n");
        defaultConfig.append("  friend_removed_target: \"&c{player} removed you from their friends list.\"\n");
        defaultConfig.append("  friend_online: \"&a\u25c6 &6{player} &ais now online!\"\n");
        defaultConfig.append("  friend_offline: \"&c\u25c6 &6{player} &cis now offline.\"\n");
        defaultConfig.append("  friend_server_switch: \"&e\u25c6 &6{player} &ejoined &b{server}\"\n");
        defaultConfig.append("  friend_server_info: \"&7(&b{server}&7)\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Status Messages\n");
        defaultConfig.append("  no_friends: \"You have no friends :(\"\n");
        defaultConfig.append("  friends_list_header: \"&6&lYour Friends ({count}):\"\n");
        defaultConfig.append("  friends_online: \"&a\u25cf Online ({count}):\"\n");
        defaultConfig.append("  friends_offline: \"&7\u25cf Offline ({count}):\"\n");
        defaultConfig.append("  pending_requests_header: \"&6&lPending Requests ({count}):\"\n");
        defaultConfig.append("  no_pending_requests: \"You have no pending friend requests.\"\n");
        defaultConfig.append("  pending_requests_notification: \"You have &6{count} &epending friend request(s)!\\n&7Use &6/friend requests &7to view them.\"\n");
        defaultConfig.append("  friends_online_count: \"&a\u25c6 &6{online} &7of &6{total} &7friends are online!\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Error Messages\n");
        defaultConfig.append("  player_not_online: \"Player {player} is not online!\"\n");
        defaultConfig.append("  cannot_add_self: \"You cannot add yourself as a friend!\"\n");
        defaultConfig.append("  already_friends: \"You are already friends with {player}!\"\n");
        defaultConfig.append("  already_sent_request: \"&e{player} already sent you a friend request! Use /friend accept {player}\"\n");
        defaultConfig.append("  not_friends: \"You are not friends with {player}!\"\n");
        defaultConfig.append("  no_pending_request: \"No pending request from {player}!\"\n");
        defaultConfig.append("  console_cannot_use: \"This command can only be used by players!\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Help Messages\n");
        defaultConfig.append("  help_header: \"&6&lFriends Plugin Help\"\n");
        defaultConfig.append("  help_add: \"&e/friend add <player> &7- Send a friend request\"\n");
        defaultConfig.append("  help_accept: \"&e/friend accept <player> &7- Accept a request\"\n");
        defaultConfig.append("  help_deny: \"&e/friend deny <player> &7- Deny a request\"\n");
        defaultConfig.append("  help_remove: \"&e/friend remove <player> &7- Remove a friend\"\n");
        defaultConfig.append("  help_list: \"&e/friend list &7- Show your friends list\"\n");
        defaultConfig.append("  help_requests: \"&e/friend requests &7- Show pending requests\"\n");
        defaultConfig.append("  help_msg: \"&e/friend msg <player> <message> &7- Send a private message\"\n");
        defaultConfig.append("  help_reply: \"&e/friend reply <message> &7- Reply to last message\"\n");
        defaultConfig.append("  help_settings: \"&e/friend settings &7- Configure your settings\"\n");
        defaultConfig.append("  help_status: \"&e/friend status <message> &7- Set your status message\"\n");
        defaultConfig.append("  help_broadcast: \"&e/friend broadcast <msg> &7- Send message to all friends\"\n");
        defaultConfig.append("  help_reload: \"&e/friend reload &7- Reload the plugin configuration\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Usage Messages\n");
        defaultConfig.append("  usage_add: \"Usage: /friend add <player>\"\n");
        defaultConfig.append("  usage_accept: \"Usage: /friend accept <player>\"\n");
        defaultConfig.append("  usage_deny: \"Usage: /friend deny <player>\"\n");
        defaultConfig.append("  usage_remove: \"Usage: /friend remove <player>\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Button Labels\n");
        defaultConfig.append("  button_accept: \"&a&l[Accept]\"\n");
        defaultConfig.append("  button_deny: \"&c&l[Deny]\"\n");
        defaultConfig.append("  button_checkmark: \"&a[\u2713]\"\n");
        defaultConfig.append("  button_cross: \"&c[\u2717]\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Decorations\n");
        defaultConfig.append("  separator: \"&7\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Messaging System\n");
        defaultConfig.append("  msg_format_sender: \"&d&l[MSG] &7To &6{player}&7: &f{message}\"\n");
        defaultConfig.append("  msg_format_receiver: \"&d&l[MSG] &7From &6{player}&7: &f{message}\"\n");
        defaultConfig.append("  msg_usage: \"Usage: /friend msg <player> <message>\"\n");
        defaultConfig.append("  msg_cannot_message_self: \"You cannot message yourself!\"\n");
        defaultConfig.append("  msg_not_friends: \"You can only message friends! Add {player} as a friend first.\"\n");
        defaultConfig.append("  msg_not_friends_hover: \"Click to send a friend request to {player}\"\n");
        defaultConfig.append("  reply_usage: \"Usage: /friend reply <message>\"\n");
        defaultConfig.append("  reply_no_one: \"You have no one to reply to!\"\n");
        defaultConfig.append("  reply_player_offline: \"That player is no longer online!\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Settings & Toggle\n");
        defaultConfig.append("  toggle_requests_enabled: \"&aFriend requests enabled!\"\n");
        defaultConfig.append("  toggle_requests_disabled: \"&cFriend requests disabled!\"\n");
        defaultConfig.append("  toggle_notifications_enabled: \"&aFriend notifications enabled!\"\n");
        defaultConfig.append("  toggle_notifications_disabled: \"&cFriend notifications disabled!\"\n");
        defaultConfig.append("  toggle_messages_enabled: \"&aPrivate messages enabled!\"\n");
        defaultConfig.append("  toggle_messages_disabled: \"&cPrivate messages disabled!\"\n");
        defaultConfig.append("  requests_disabled_target: \"&c{player} has friend requests disabled!\"\n");
        defaultConfig.append("  messages_disabled_target: \"&c{player} has private messages disabled!\"\n");
        defaultConfig.append("  status_set: \"Status set to: &e{status}\"\n");
        defaultConfig.append("  status_cleared: \"Status message cleared!\"\n");
        defaultConfig.append("  status_display: \"&7Status: &e{status}\"\n");
        defaultConfig.append("  broadcast_usage: \"Usage: /friend broadcast <message>\"\n");
        defaultConfig.append("  broadcast_sent: \"&aBroadcast sent to {count} friend(s)!\"\n");
        defaultConfig.append("  broadcast_format: \"&6&l[BROADCAST] &6{player}&7: &f{message}\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Settings Menu\n");
        defaultConfig.append("  settings_header: \"&6&lFriend Settings\"\n");
        defaultConfig.append("  settings_requests: \"  {icon} &eFriend Requests: {status}\"\n");
        defaultConfig.append("  settings_notifications: \"  {icon} &eJoin/Leave Notifications: {status}\"\n");
        defaultConfig.append("  settings_messages: \"  {icon} &ePrivate Messages: {status}\"\n");
        defaultConfig.append("  settings_usage: \"&7Use &e/friend settings <requests|notifications|messages> &7to toggle\"\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Status Translations\n");
        defaultConfig.append("  status_enabled: \"&aEnabled\"\n");
        defaultConfig.append("  status_disabled: \"&cDisabled\"\n");
        defaultConfig.append("\n");
        defaultConfig.append("# Feature Settings\n");
        defaultConfig.append("settings:\n");
        defaultConfig.append("  # Show join/leave notifications\n");
        defaultConfig.append("  notify_on_join: true\n");
        defaultConfig.append("  notify_on_leave: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show notifications when friends switch servers\n");
        defaultConfig.append("  notify_on_server_switch: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show online friends count on login\n");
        defaultConfig.append("  show_online_count: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show pending requests notification on login\n");
        defaultConfig.append("  notify_pending_requests: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Maximum number of friends per player (0 = unlimited)\n");
        defaultConfig.append("  max_friends: 0\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Only friends can message each other\n");
        defaultConfig.append("  only_friends_can_message: true\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Show prefix for help menus, lists, and separators\n");
        defaultConfig.append("  use_prefix_for_lists: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Storage type: 'json' or 'mysql'\n");
        defaultConfig.append("  storage_type: 'json'\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable additional command aliases\n");
        defaultConfig.append("  enable_msg_alias: false\n");
        defaultConfig.append("  enable_tell_alias: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable reply command aliases\n");
        defaultConfig.append("  enable_r_alias: false\n");
        defaultConfig.append("  enable_reply_alias: false\n");
        defaultConfig.append("  enable_respond_alias: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable friend message command aliases\n");
        defaultConfig.append("  enable_message_alias: false\n");
        defaultConfig.append("  enable_whisper_alias: false\n");
        defaultConfig.append("  enable_pm_alias: false\n");
        defaultConfig.append("  \n");
        defaultConfig.append("  # Enable /f as alias for /friend\n");
        defaultConfig.append("  enable_f_alias: true\n");
        defaultConfig.append("\n");
        defaultConfig.append("# MySQL Settings (only used if storage_type is 'mysql')\n");
        defaultConfig.append("mysql:\n");
        defaultConfig.append("  host: 'localhost'\n");
        defaultConfig.append("  port: 3306\n");
        defaultConfig.append("  database: 'friends'\n");
        defaultConfig.append("  username: 'root'\n");
        defaultConfig.append("  password: 'password'\n");
        defaultConfig.append("  # Connection pool settings\n");
        defaultConfig.append("  pool_size: 10\n");
        defaultConfig.append("  # Table prefix\n");
        defaultConfig.append("  table_prefix: 'friends_'\n");
        try (FileWriter writer = new FileWriter(this.configFile);){
            writer.write(defaultConfig.toString());
        }
        this.logger.info("Default configuration created");
    }

    public String getMessage(String key) {
        return this.getMessage(key, new HashMap<String, String>());
    }

    public String getMessage(String key, Map<String, String> replacements) {
        Object messagesObj = this.config.get("messages");
        if (!(messagesObj instanceof Map)) {
            return key;
        }
        Map messages = (Map)messagesObj;
        Object messageObj = messages.get(key);
        if (messageObj == null) {
            return key;
        }
        String message = messageObj.toString();
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        message = message.replace("&0", "\u00a70").replace("&1", "\u00a71").replace("&2", "\u00a72").replace("&3", "\u00a73").replace("&4", "\u00a74").replace("&5", "\u00a75").replace("&6", "\u00a76").replace("&7", "\u00a77").replace("&8", "\u00a78").replace("&9", "\u00a79").replace("&a", "\u00a7a").replace("&b", "\u00a7b").replace("&c", "\u00a7c").replace("&d", "\u00a7d").replace("&e", "\u00a7e").replace("&f", "\u00a7f").replace("&l", "\u00a7l").replace("&m", "\u00a7m").replace("&n", "\u00a7n").replace("&o", "\u00a7o").replace("&r", "\u00a7r").replace("\\n", "\n");
        return message;
    }

    public boolean getSetting(String key, boolean defaultValue) {
        Object settingsObj = this.config.get("settings");
        if (!(settingsObj instanceof Map)) {
            return defaultValue;
        }
        Map settings = (Map)settingsObj;
        Object value = settings.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public int getSetting(String key, int defaultValue) {
        Object settingsObj = this.config.get("settings");
        if (!(settingsObj instanceof Map)) {
            return defaultValue;
        }
        Map settings = (Map)settingsObj;
        Object value = settings.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    public String getSetting(String key, String defaultValue) {
        Object settingsObj = this.config.get("settings");
        if (!(settingsObj instanceof Map)) {
            return defaultValue;
        }
        Map settings = (Map)settingsObj;
        Object value = settings.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public String getMySQLSetting(String key, String defaultValue) {
        Object mysqlObj = this.config.get("mysql");
        if (!(mysqlObj instanceof Map)) {
            return defaultValue;
        }
        Map mysql = (Map)mysqlObj;
        Object value = mysql.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public int getMySQLSetting(String key, int defaultValue) {
        Object mysqlObj = this.config.get("mysql");
        if (!(mysqlObj instanceof Map)) {
            return defaultValue;
        }
        Map mysql = (Map)mysqlObj;
        Object value = mysql.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }
}

