/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.manager.FriendsManager;
import de.simonspeedy.friends.manager.MessageManager;
import de.simonspeedy.friends.manager.PlayerSettingsManager;
import de.simonspeedy.friends.messaging.PluginMessageHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.slf4j.Logger;

public class FriendCommand
implements SimpleCommand {
    private final FriendsManager friendsManager;
    private final ProxyServer server;
    private final ConfigManager config;
    private final MessageManager messageManager;
    private final PlayerSettingsManager settingsManager;
    private final Logger logger;
    private final PluginMessageHandler messageHandler;

    public FriendCommand(FriendsManager friendsManager, ProxyServer server, ConfigManager config, MessageManager messageManager, PlayerSettingsManager settingsManager, Logger logger, PluginMessageHandler messageHandler) {
        this.friendsManager = friendsManager;
        this.server = server;
        this.config = config;
        this.messageManager = messageManager;
        this.settingsManager = settingsManager;
        this.logger = logger;
        this.messageHandler = messageHandler;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            CommandSource commandSource = invocation.source();
            if (!(commandSource instanceof Player)) {
                invocation.source().sendMessage(this.msg("console_cannot_use"));
                return;
            }
            Player player = (Player)commandSource;
            this.sendHelp(player);
            return;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("reload")) {
            this.handleReload(invocation);
            return;
        }
        Object object = invocation.source();
        if (!(object instanceof Player)) {
            invocation.source().sendMessage(this.msg("console_cannot_use"));
            return;
        }
        Player player = (Player)object;
        switch (subCommand) {
            case "add": 
            case "request": {
                this.handleAdd(player, args);
                break;
            }
            case "accept": {
                this.handleAccept(player, args);
                break;
            }
            case "deny": 
            case "decline": {
                this.handleDeny(player, args);
                break;
            }
            case "remove": 
            case "delete": {
                this.handleRemove(player, args);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "requests": 
            case "pending": {
                this.handleRequests(player);
                break;
            }
            case "msg": 
            case "message": {
                this.handleMessage(player, args);
                break;
            }
            case "r": 
            case "reply": {
                this.handleReply(player, args);
                break;
            }
            case "settings": {
                this.handleSettings(player, args);
                break;
            }
            case "status": {
                this.handleStatus(player, args);
                break;
            }
            case "broadcast": 
            case "bc": {
                this.handleBroadcast(player, args);
                break;
            }
            default: {
                this.sendHelp(player);
            }
        }
    }

    private void handleAdd(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.msg("usage_add"));
            return;
        }
        String targetName = args[1];
        Optional targetOpt = this.server.getPlayer(targetName);
        if (targetOpt.isEmpty()) {
            player.sendMessage(this.msg("player_not_online", Map.of("player", targetName)));
            return;
        }
        Player target = (Player)targetOpt.get();
        if (player.getUniqueId().equals(target.getUniqueId())) {
            player.sendMessage(this.msg("cannot_add_self"));
            return;
        }
        if (this.friendsManager.areFriends(player.getUniqueId(), target.getUniqueId())) {
            player.sendMessage(this.msg("already_friends", Map.of("player", target.getUsername())));
            return;
        }
        if (this.friendsManager.hasPendingRequest(player.getUniqueId(), target.getUniqueId())) {
            player.sendMessage(this.msg("already_sent_request", Map.of("player", target.getUsername())));
            return;
        }
        if (!this.settingsManager.areRequestsEnabled(target.getUniqueId())) {
            player.sendMessage(this.msg("requests_disabled_target", Map.of("player", target.getUsername())));
            return;
        }
        int maxFriends = this.config.getSetting("max_friends", 0);
        if (maxFriends > 0 && this.friendsManager.getFriends(player.getUniqueId()).size() >= maxFriends) {
            player.sendMessage((Component)Component.text((String)"\u00a7cYou have reached the maximum number of friends!"));
            return;
        }
        if (this.friendsManager.sendFriendRequest(player.getUniqueId(), target.getUniqueId())) {
            this.friendsManager.updatePlayerName(player.getUniqueId(), player.getUsername());
            this.friendsManager.updatePlayerName(target.getUniqueId(), target.getUsername());
            player.sendMessage(this.msg("request_sent", Map.of("player", target.getUsername())));
            String acceptBtn = this.config.getMessage("button_accept");
            String denyBtn = this.config.getMessage("button_deny");
            target.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(this.msg("request_received", Map.of("player", player.getUsername())))).append((Component)Component.newline())).append(LegacyComponentSerializer.legacySection().deserialize(acceptBtn).clickEvent(ClickEvent.runCommand((String)("/friend accept " + player.getUsername()))))).append((Component)Component.text((String)" "))).append(LegacyComponentSerializer.legacySection().deserialize(denyBtn).clickEvent(ClickEvent.runCommand((String)("/friend deny " + player.getUsername())))));
            this.messageHandler.notifyFriendRequest(target.getUniqueId(), player.getUniqueId(), player.getUsername());
        }
    }

    private void handleAccept(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.msg("usage_accept"));
            return;
        }
        String senderName = args[1];
        Optional senderOpt = this.server.getPlayer(senderName);
        if (senderOpt.isEmpty()) {
            player.sendMessage(this.msg("player_not_online", Map.of("player", senderName)));
            return;
        }
        Player sender = (Player)senderOpt.get();
        if (this.friendsManager.acceptFriendRequest(player.getUniqueId(), sender.getUniqueId())) {
            player.sendMessage(this.msg("request_accepted", Map.of("player", sender.getUsername())));
            sender.sendMessage(this.msg("request_accepted_sender", Map.of("player", player.getUsername())));
        } else {
            player.sendMessage(this.msg("no_pending_request", Map.of("player", sender.getUsername())));
        }
    }

    private void handleDeny(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.msg("usage_deny"));
            return;
        }
        String senderName = args[1];
        Optional senderOpt = this.server.getPlayer(senderName);
        if (senderOpt.isEmpty()) {
            player.sendMessage(this.msg("player_not_online", Map.of("player", senderName)));
            return;
        }
        Player sender = (Player)senderOpt.get();
        if (this.friendsManager.denyFriendRequest(player.getUniqueId(), sender.getUniqueId())) {
            player.sendMessage(this.msg("request_denied", Map.of("player", sender.getUsername())));
            sender.sendMessage(this.msg("request_denied_sender", Map.of("player", player.getUsername())));
        } else {
            player.sendMessage(this.msg("no_pending_request", Map.of("player", sender.getUsername())));
        }
    }

    private void handleRemove(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.msg("usage_remove"));
            return;
        }
        String friendName = args[1];
        Optional friendOpt = this.server.getPlayer(friendName);
        if (friendOpt.isEmpty()) {
            player.sendMessage(this.msg("player_not_online", Map.of("player", friendName)));
            return;
        }
        Player friend = (Player)friendOpt.get();
        if (this.friendsManager.removeFriend(player.getUniqueId(), friend.getUniqueId())) {
            player.sendMessage(this.msg("friend_removed", Map.of("player", friend.getUsername())));
            friend.sendMessage(this.msg("friend_removed_target", Map.of("player", player.getUsername())));
        } else {
            player.sendMessage(this.msg("not_friends", Map.of("player", friend.getUsername())));
        }
    }

    private void handleList(Player player) {
        Set<UUID> friends = this.friendsManager.getFriends(player.getUniqueId());
        if (friends.isEmpty()) {
            player.sendMessage(this.msg("no_friends"));
            return;
        }
        player.sendMessage(this.msgList("separator"));
        player.sendMessage(this.msgList("friends_list_header", Map.of("count", String.valueOf(friends.size()))));
        player.sendMessage((Component)Component.empty());
        ArrayList<Player> onlineFriends = new ArrayList<Player>();
        ArrayList<String> offlineFriends = new ArrayList<String>();
        for (UUID friendUUID : friends) {
            Optional friendOpt = this.server.getPlayer(friendUUID);
            if (friendOpt.isPresent()) {
                onlineFriends.add((Player)friendOpt.get());
                continue;
            }
            String username = this.friendsManager.getPlayerName(friendUUID);
            offlineFriends.add(username);
        }
        if (!onlineFriends.isEmpty()) {
            player.sendMessage(this.msgList("friends_online", Map.of("count", String.valueOf(onlineFriends.size()))));
            for (Player friend : onlineFriends) {
                Optional<String> serverNameOpt = friend.getCurrentServer().map(conn -> conn.getServerInfo().getName());
                if (serverNameOpt.isPresent()) {
                    String serverName = serverNameOpt.get();
                    String serverInfo = this.config.getMessage("friend_server_info", Map.of("server", serverName));
                    Component serverComponent = ((TextComponent)LegacyComponentSerializer.legacySection().deserialize(serverInfo).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("\u00a7eClick to join " + serverName))))).clickEvent(ClickEvent.callback(audience -> {
                        if (audience instanceof Player) {
                            Player p = (Player)audience;
                            this.server.getServer(serverName).ifPresent(targetServer -> p.createConnectionRequest(targetServer).fireAndForget());
                        }
                    }));
                    Component friendEntry = Component.text((String)("  \u2022 " + friend.getUsername() + " ")).append(serverComponent);
                    player.sendMessage(friendEntry);
                    continue;
                }
                player.sendMessage((Component)Component.text((String)("  \u2022 " + friend.getUsername())));
            }
        }
        if (!offlineFriends.isEmpty()) {
            player.sendMessage(this.msgList("friends_offline", Map.of("count", String.valueOf(offlineFriends.size()))));
            for (String name : offlineFriends) {
                player.sendMessage((Component)Component.text((String)("  \u2022 " + name)));
            }
        }
        player.sendMessage(this.msgList("separator"));
    }

    private void handleRequests(Player player) {
        Set<UUID> requests = this.friendsManager.getPendingRequests(player.getUniqueId());
        if (requests.isEmpty()) {
            player.sendMessage(this.msg("no_pending_requests"));
            return;
        }
        player.sendMessage(this.msgList("separator"));
        player.sendMessage(this.msgList("pending_requests_header", Map.of("count", String.valueOf(requests.size()))));
        player.sendMessage((Component)Component.empty());
        for (UUID senderUUID : requests) {
            Optional senderOpt = this.server.getPlayer(senderUUID);
            String senderName = senderOpt.map(Player::getUsername).orElse(this.friendsManager.getPlayerName(senderUUID));
            String checkmark = this.config.getMessage("button_checkmark");
            String cross = this.config.getMessage("button_cross");
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)("\u2022 " + senderName + " ")))).append(LegacyComponentSerializer.legacySection().deserialize(checkmark).clickEvent(ClickEvent.runCommand((String)("/friend accept " + senderName))))).append((Component)Component.text((String)" "))).append(LegacyComponentSerializer.legacySection().deserialize(cross).clickEvent(ClickEvent.runCommand((String)("/friend deny " + senderName)))));
        }
        player.sendMessage(this.msgList("separator"));
    }

    private void handleMessage(Player sender, String[] args) {
        if (args.length < 3) {
            sender.sendMessage(this.msg("msg_usage"));
            return;
        }
        String targetName = args[1];
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        Optional targetOpt = this.server.getPlayer(targetName);
        if (targetOpt.isEmpty()) {
            sender.sendMessage(this.msg("player_not_online", Map.of("player", targetName)));
            return;
        }
        Player target = (Player)targetOpt.get();
        if (sender.getUniqueId().equals(target.getUniqueId())) {
            sender.sendMessage(this.msg("msg_cannot_message_self"));
            return;
        }
        if (this.config.getSetting("only_friends_can_message", true) && !this.friendsManager.areFriends(sender.getUniqueId(), target.getUniqueId())) {
            String main = this.config.getMessage("msg_not_friends", Map.of("player", target.getUsername()));
            String hover = this.config.getMessage("msg_not_friends_hover", Map.of("player", target.getUsername()));
            Component msg = ((TextComponent)LegacyComponentSerializer.legacySection().deserialize(this.config.getMessage("prefix", new HashMap<String, String>()) + main).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)hover)))).clickEvent(ClickEvent.runCommand((String)("/friend add " + target.getUsername())));
            sender.sendMessage(msg);
            return;
        }
        if (!this.settingsManager.areMessagesEnabled(target.getUniqueId())) {
            sender.sendMessage(this.msg("messages_disabled_target", Map.of("player", target.getUsername())));
            return;
        }
        String senderFormat = this.config.getMessage("msg_format_sender", Map.of("player", target.getUsername(), "message", message));
        String receiverFormat = this.config.getMessage("msg_format_receiver", Map.of("player", sender.getUsername(), "message", message));
        sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(senderFormat));
        target.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(receiverFormat));
        this.messageManager.setLastSender(target.getUniqueId(), sender.getUniqueId());
        this.messageManager.setLastSender(sender.getUniqueId(), target.getUniqueId());
        this.logger.info("[Friend Message] {} -> {}: {}", sender.getUsername(), target.getUsername(), message);
    }

    private void handleReply(Player sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.msg("reply_usage"));
            return;
        }
        if (!this.messageManager.hasLastSender(sender.getUniqueId())) {
            sender.sendMessage(this.msg("reply_no_one"));
            return;
        }
        UUID targetUUID = this.messageManager.getLastSender(sender.getUniqueId());
        Optional targetOpt = this.server.getPlayer(targetUUID);
        if (targetOpt.isEmpty()) {
            sender.sendMessage(this.msg("reply_player_offline"));
            this.messageManager.removeLastSender(sender.getUniqueId());
            return;
        }
        Player target = (Player)targetOpt.get();
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String senderFormat = this.config.getMessage("msg_format_sender", Map.of("player", target.getUsername(), "message", message));
        String receiverFormat = this.config.getMessage("msg_format_receiver", Map.of("player", sender.getUsername(), "message", message));
        sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(senderFormat));
        target.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(receiverFormat));
        this.messageManager.setLastSender(target.getUniqueId(), sender.getUniqueId());
        this.messageManager.setLastSender(sender.getUniqueId(), target.getUniqueId());
        this.logger.info("[Friend Reply] {} -> {}: {}", sender.getUsername(), target.getUsername(), message);
    }

    private void handleSettings(Player player, String[] args) {
        String setting;
        if (args.length == 1) {
            this.showSettingsMenu(player);
            return;
        }
        switch (setting = args[1].toLowerCase()) {
            case "requests": 
            case "toggle": {
                boolean currentlyEnabled = this.settingsManager.areRequestsEnabled(player.getUniqueId());
                this.settingsManager.setRequestsEnabled(player.getUniqueId(), !currentlyEnabled);
                if (!currentlyEnabled) {
                    player.sendMessage(this.msg("toggle_requests_enabled"));
                } else {
                    player.sendMessage(this.msg("toggle_requests_disabled"));
                }
                this.showSettingsMenu(player);
                break;
            }
            case "notifications": 
            case "notify": {
                boolean currentlyEnabled = this.settingsManager.areNotificationsEnabled(player.getUniqueId());
                this.settingsManager.setNotificationsEnabled(player.getUniqueId(), !currentlyEnabled);
                if (!currentlyEnabled) {
                    player.sendMessage(this.msg("toggle_notifications_enabled"));
                } else {
                    player.sendMessage(this.msg("toggle_notifications_disabled"));
                }
                this.showSettingsMenu(player);
                break;
            }
            case "messages": 
            case "msg": {
                boolean currentlyEnabled = this.settingsManager.areMessagesEnabled(player.getUniqueId());
                this.settingsManager.setMessagesEnabled(player.getUniqueId(), !currentlyEnabled);
                if (!currentlyEnabled) {
                    player.sendMessage(this.msg("toggle_messages_enabled"));
                } else {
                    player.sendMessage(this.msg("toggle_messages_disabled"));
                }
                this.showSettingsMenu(player);
                break;
            }
            default: {
                this.showSettingsMenu(player);
            }
        }
    }

    private void showSettingsMenu(Player player) {
        player.sendMessage(this.msgList("separator"));
        player.sendMessage(this.msgList("settings_header"));
        player.sendMessage((Component)Component.empty());
        boolean requestsEnabled = this.settingsManager.areRequestsEnabled(player.getUniqueId());
        boolean notificationsEnabled = this.settingsManager.areNotificationsEnabled(player.getUniqueId());
        boolean messagesEnabled = this.settingsManager.areMessagesEnabled(player.getUniqueId());
        String enabledText = this.config.getMessage("status_enabled", new HashMap<String, String>());
        String disabledText = this.config.getMessage("status_disabled", new HashMap<String, String>());
        Map<String, String> requestsRepl = Map.of("status", requestsEnabled ? enabledText : disabledText, "icon", requestsEnabled ? "&a\u2713" : "&c\u2717");
        player.sendMessage(this.msgList("settings_requests", requestsRepl));
        Map<String, String> notifyRepl = Map.of("status", notificationsEnabled ? enabledText : disabledText, "icon", notificationsEnabled ? "&a\u2713" : "&c\u2717");
        player.sendMessage(this.msgList("settings_notifications", notifyRepl));
        Map<String, String> msgRepl = Map.of("status", messagesEnabled ? enabledText : disabledText, "icon", messagesEnabled ? "&a\u2713" : "&c\u2717");
        player.sendMessage(this.msgList("settings_messages", msgRepl));
        player.sendMessage((Component)Component.empty());
        player.sendMessage(this.msgList("settings_usage"));
        player.sendMessage(this.msgList("separator"));
    }

    private void handleStatus(Player player, String[] args) {
        if (args.length == 1) {
            this.settingsManager.setStatusMessage(player.getUniqueId(), null);
            player.sendMessage(this.msg("status_cleared"));
            return;
        }
        String status = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        if (status.length() > 255) {
            status = status.substring(0, 255);
        }
        this.settingsManager.setStatusMessage(player.getUniqueId(), status);
        player.sendMessage(this.msg("status_set", Map.of("status", status)));
    }

    private void handleReload(SimpleCommand.Invocation invocation) {
        if (!invocation.source().hasPermission("friends.reload")) {
            invocation.source().sendMessage((Component)Component.text((String)"\u00a7cYou don't have permission to use this command!"));
            return;
        }
        this.config.load();
        invocation.source().sendMessage((Component)Component.text((String)"\u00a7aFriends plugin configuration reloaded successfully!"));
    }

    private void handleBroadcast(Player sender, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.msg("broadcast_usage"));
            return;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        Set<UUID> friends = this.friendsManager.getFriends(sender.getUniqueId());
        int sentCount = 0;
        String broadcastFormat = this.config.getMessage("broadcast_format", Map.of("player", sender.getUsername(), "message", message));
        TextComponent broadcastMsg = LegacyComponentSerializer.legacySection().deserialize(broadcastFormat);
        for (UUID friendUUID : friends) {
            Optional friendOpt = this.server.getPlayer(friendUUID);
            if (!friendOpt.isPresent()) continue;
            ((Player)friendOpt.get()).sendMessage((Component)broadcastMsg);
            ++sentCount;
        }
        sender.sendMessage(this.msg("broadcast_sent", Map.of("count", String.valueOf(sentCount))));
        this.logger.info("[Friend Broadcast] {} sent to {} online friends: {}", sender.getUsername(), sentCount, message);
    }

    private void sendHelp(Player player) {
        player.sendMessage(this.msgList("separator"));
        player.sendMessage(this.msgList("help_header"));
        player.sendMessage((Component)Component.empty());
        player.sendMessage(this.msgList("help_add"));
        player.sendMessage(this.msgList("help_accept"));
        player.sendMessage(this.msgList("help_deny"));
        player.sendMessage(this.msgList("help_remove"));
        player.sendMessage(this.msgList("help_list"));
        player.sendMessage(this.msgList("help_requests"));
        player.sendMessage(this.msgList("help_msg"));
        player.sendMessage(this.msgList("help_reply"));
        player.sendMessage(this.msgList("help_settings"));
        player.sendMessage(this.msgList("help_status"));
        player.sendMessage(this.msgList("help_broadcast"));
        player.sendMessage(this.msgList("separator"));
        if (player.hasPermission("friends.reload")) {
            player.sendMessage((Component)Component.empty());
            player.sendMessage(this.msgList("help_reload"));
        }
    }

    private Component msg(String key) {
        return this.msg(key, new HashMap<String, String>());
    }

    private Component msg(String key, Map<String, String> replacements) {
        String prefix = this.config.getMessage("prefix", new HashMap<String, String>());
        String message = this.config.getMessage(key, replacements);
        return LegacyComponentSerializer.legacySection().deserialize(prefix + message);
    }

    private Component msgList(String key) {
        return this.msgList(key, new HashMap<String, String>());
    }

    private Component msgList(String key, Map<String, String> replacements) {
        boolean usePrefix = this.config.getSetting("use_prefix_for_lists", false);
        String message = this.config.getMessage(key, replacements);
        if (usePrefix) {
            String prefix = this.config.getMessage("prefix", new HashMap<String, String>());
            return LegacyComponentSerializer.legacySection().deserialize(prefix + message);
        }
        return LegacyComponentSerializer.legacySection().deserialize(message);
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] args = (String[])invocation.arguments();
        if (args.length == 0 || args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>(List.of("add", "accept", "deny", "remove", "list", "requests", "pending", "msg", "reply", "settings", "status", "broadcast"));
            if (invocation.source().hasPermission("friends.reload")) {
                suggestions.add("reload");
            }
            if (args.length == 1) {
                String input = args[0].toLowerCase();
                return suggestions.stream().filter(s -> s.toLowerCase().startsWith(input)).toList();
            }
            return suggestions;
        }
        if (args.length == 2) {
            String subCommand = args[0].toLowerCase();
            if (subCommand.equals("settings")) {
                return List.of("requests", "notifications", "messages");
            }
            if (subCommand.equals("add") || subCommand.equals("accept") || subCommand.equals("deny") || subCommand.equals("remove")) {
                return this.server.getAllPlayers().stream().map(Player::getUsername).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
            }
            if (subCommand.equals("msg") || subCommand.equals("message")) {
                CommandSource commandSource = invocation.source();
                if (!(commandSource instanceof Player)) {
                    return List.of();
                }
                Player player = (Player)commandSource;
                Set<UUID> friends = this.friendsManager.getFriends(player.getUniqueId());
                return friends.stream().map(uuid -> this.server.getPlayer(uuid)).filter(Optional::isPresent).map(opt -> ((Player)opt.get()).getUsername()).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
            }
        }
        return List.of();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return true;
    }
}

