/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.storage.DatabaseManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class FriendsManager {
    private final Path dataDirectory;
    private final Logger logger;
    private final Gson gson;
    private final Map<UUID, Set<UUID>> friendships;
    private final Map<UUID, Set<UUID>> pendingRequests;
    private final Map<UUID, String> playerNames;
    private File dataFile;
    private File namesFile;
    private final boolean useMySql;
    private final DatabaseManager databaseManager;

    public FriendsManager(Path dataDirectory, Logger logger, ConfigManager configManager) {
        this.dataDirectory = dataDirectory;
        this.logger = logger;
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        this.friendships = new ConcurrentHashMap<UUID, Set<UUID>>();
        this.pendingRequests = new ConcurrentHashMap<UUID, Set<UUID>>();
        this.playerNames = new ConcurrentHashMap<UUID, String>();
        String storageType = configManager.getSetting("storage_type", "json");
        this.useMySql = "mysql".equalsIgnoreCase(storageType);
        if (this.useMySql) {
            this.databaseManager = new DatabaseManager(configManager, logger);
            logger.info("Using MySQL storage backend");
        } else {
            this.databaseManager = null;
            logger.info("Using JSON file storage backend");
        }
    }

    public void load() {
        block32: {
            if (this.useMySql) {
                boolean connected = this.databaseManager.connect();
                if (connected) {
                    try {
                        this.databaseManager.createTables();
                        this.logger.info("Successfully connected to MySQL database");
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to create MySQL tables. Falling back to JSON storage.", e);
                        this.loadJsonFallback();
                    }
                } else {
                    this.logger.error("Failed to connect to MySQL database. Falling back to JSON storage.");
                    this.loadJsonFallback();
                }
            } else {
                try {
                    Map data;
                    Type type;
                    FileReader reader;
                    File dir = this.dataDirectory.toFile();
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    this.dataFile = new File(dir, "friends.json");
                    this.namesFile = new File(dir, "playernames.json");
                    if (this.dataFile.exists()) {
                        reader = new FileReader(this.dataFile);
                        try {
                            type = new TypeToken<Map<String, Set<String>>>(){}.getType();
                            data = (Map)this.gson.fromJson((Reader)reader, type);
                            if (data != null) {
                                data.forEach((key, value) -> {
                                    UUID playerUUID = UUID.fromString(key);
                                    HashSet friends = new HashSet();
                                    value.forEach(friendStr -> friends.add(UUID.fromString(friendStr)));
                                    this.friendships.put(playerUUID, friends);
                                });
                            }
                            this.logger.info("Loaded friendship data: {} players", (Object)this.friendships.size());
                        }
                        finally {
                            reader.close();
                        }
                    } else {
                        this.dataFile.createNewFile();
                        this.logger.info("Created new friendship file");
                    }
                    if (this.namesFile.exists()) {
                        reader = new FileReader(this.namesFile);
                        try {
                            type = new TypeToken<Map<String, String>>(){}.getType();
                            data = (Map)this.gson.fromJson((Reader)reader, type);
                            if (data != null) {
                                data.forEach((key, value) -> this.playerNames.put(UUID.fromString(key), (String)value));
                            }
                            this.logger.info("Loaded player names: {} entries", (Object)this.playerNames.size());
                        }
                        finally {
                            reader.close();
                        }
                    } else {
                        this.namesFile.createNewFile();
                        this.logger.info("Created new player names file");
                    }
                    this.namesFile = new File(dir, "playernames.json");
                    if (this.namesFile.exists()) {
                        reader = new FileReader(this.namesFile);
                        try {
                            type = new TypeToken<Map<String, String>>(){}.getType();
                            data = (Map)this.gson.fromJson((Reader)reader, type);
                            if (data != null) {
                                data.forEach((key, value) -> this.playerNames.put(UUID.fromString(key), (String)value));
                            }
                            this.logger.info("Loaded player names from JSON: {} entries", (Object)this.playerNames.size());
                            break block32;
                        }
                        finally {
                            reader.close();
                        }
                    }
                    this.namesFile.createNewFile();
                }
                catch (IOException e) {
                    this.logger.error("Failed to load JSON fallback data", e);
                }
            }
        }
    }

    public void save() {
        HashMap data;
        FileWriter writer;
        if (this.useMySql) {
            return;
        }
        try {
            writer = new FileWriter(this.dataFile);
            try {
                data = new HashMap();
                this.friendships.forEach((key, value) -> {
                    HashSet friends = new HashSet();
                    value.forEach(uuid -> friends.add(uuid.toString()));
                    data.put(key.toString(), friends);
                });
                this.gson.toJson(data, (Appendable)writer);
                this.logger.info("Saved friendship data");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save friendship data", e);
        }
        try {
            writer = new FileWriter(this.namesFile);
            try {
                data = new HashMap();
                this.playerNames.forEach((key, value) -> data.put(key.toString(), value));
                this.gson.toJson(data, (Appendable)writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save player names", e);
        }
    }

    private void loadJsonFallback() {
        block10: {
            try {
                File dir = this.dataDirectory.toFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                this.dataFile = new File(dir, "friends.json");
                if (this.dataFile.exists()) {
                    try (FileReader reader = new FileReader(this.dataFile);){
                        Type type = new TypeToken<Map<String, Set<String>>>(){}.getType();
                        Map data = (Map)this.gson.fromJson((Reader)reader, type);
                        if (data != null) {
                            data.forEach((key, value) -> {
                                UUID playerUUID = UUID.fromString(key);
                                HashSet friends = new HashSet();
                                value.forEach(friendStr -> friends.add(UUID.fromString(friendStr)));
                                this.friendships.put(playerUUID, friends);
                            });
                        }
                        this.logger.info("Loaded friendship data from JSON: {} players", (Object)this.friendships.size());
                        break block10;
                    }
                }
                this.dataFile.createNewFile();
                this.logger.info("Created new friendship file");
            }
            catch (IOException e) {
                this.logger.error("Failed to load JSON fallback data", e);
            }
        }
    }

    public boolean sendFriendRequest(UUID sender, UUID receiver) {
        if (sender.equals(receiver)) {
            return false;
        }
        if (this.areFriends(sender, receiver)) {
            return false;
        }
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.addPendingRequest(sender, receiver);
        }
        this.pendingRequests.computeIfAbsent(receiver, k -> new HashSet()).add(sender);
        return true;
    }

    public boolean acceptFriendRequest(UUID receiver, UUID sender) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            if (!this.databaseManager.hasPendingRequest(sender, receiver)) {
                return false;
            }
            boolean success = this.databaseManager.addFriendship(sender, receiver);
            if (success) {
                this.databaseManager.removePendingRequest(sender, receiver);
            }
            return success;
        }
        Set<UUID> requests = this.pendingRequests.get(receiver);
        if (requests == null || !requests.contains(sender)) {
            return false;
        }
        this.friendships.computeIfAbsent(sender, k -> new HashSet()).add(receiver);
        this.friendships.computeIfAbsent(receiver, k -> new HashSet()).add(sender);
        requests.remove(sender);
        if (requests.isEmpty()) {
            this.pendingRequests.remove(receiver);
        }
        this.save();
        return true;
    }

    public boolean denyFriendRequest(UUID receiver, UUID sender) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.removePendingRequest(sender, receiver);
        }
        Set<UUID> requests = this.pendingRequests.get(receiver);
        if (requests == null || !requests.contains(sender)) {
            return false;
        }
        requests.remove(sender);
        if (requests.isEmpty()) {
            this.pendingRequests.remove(receiver);
        }
        return true;
    }

    public boolean removeFriend(UUID player, UUID friend) {
        Set<UUID> friendFriends;
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.removeFriendship(player, friend);
        }
        boolean removed = false;
        Set<UUID> playerFriends = this.friendships.get(player);
        if (playerFriends != null) {
            removed = playerFriends.remove(friend);
            if (playerFriends.isEmpty()) {
                this.friendships.remove(player);
            }
        }
        if ((friendFriends = this.friendships.get(friend)) != null) {
            friendFriends.remove(player);
            if (friendFriends.isEmpty()) {
                this.friendships.remove(friend);
            }
        }
        if (removed) {
            this.save();
        }
        return removed;
    }

    public Set<UUID> getFriends(UUID player) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.getFriends(player);
        }
        return new HashSet<UUID>(this.friendships.getOrDefault(player, Collections.emptySet()));
    }

    public boolean areFriends(UUID player1, UUID player2) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.areFriends(player1, player2);
        }
        Set<UUID> friends = this.friendships.get(player1);
        return friends != null && friends.contains(player2);
    }

    public Set<UUID> getPendingRequests(UUID player) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.getPendingRequests(player);
        }
        return new HashSet<UUID>(this.pendingRequests.getOrDefault(player, Collections.emptySet()));
    }

    public boolean hasPendingRequest(UUID receiver, UUID sender) {
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            return this.databaseManager.hasPendingRequest(sender, receiver);
        }
        Set<UUID> requests = this.pendingRequests.get(receiver);
        return requests != null && requests.contains(sender);
    }

    public void shutdown() {
        if (this.useMySql && this.databaseManager != null) {
            this.databaseManager.disconnect();
            this.logger.info("Disconnected from MySQL database");
        }
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public void updatePlayerName(UUID uuid, String username) {
        this.playerNames.put(uuid, username);
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected()) {
            this.databaseManager.updatePlayerName(uuid, username);
        } else {
            this.save();
        }
    }

    public String getPlayerName(UUID uuid) {
        String name;
        if (this.useMySql && this.databaseManager != null && this.databaseManager.isConnected() && (name = this.databaseManager.getPlayerName(uuid)) != null) {
            this.playerNames.put(uuid, name);
            return name;
        }
        return this.playerNames.getOrDefault(uuid, "Unknown");
    }
}

