/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.commands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.manager.MessageManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class ReplyCommand
implements SimpleCommand {
    private final MessageManager messageManager;
    private final ProxyServer server;
    private final ConfigManager config;

    public ReplyCommand(MessageManager messageManager, ProxyServer server, ConfigManager config) {
        this.messageManager = messageManager;
        this.server = server;
        this.config = config;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        if (!(commandSource instanceof Player)) {
            invocation.source().sendMessage(this.msg("console_cannot_use"));
            return;
        }
        Player sender = (Player)commandSource;
        CharSequence[] args = (String[])invocation.arguments();
        if (args.length < 1) {
            sender.sendMessage(this.msg("reply_usage"));
            return;
        }
        if (!this.messageManager.hasLastSender(sender.getUniqueId())) {
            sender.sendMessage(this.msg("reply_no_one"));
            return;
        }
        UUID targetUUID = this.messageManager.getLastSender(sender.getUniqueId());
        Optional targetOpt = this.server.getPlayer(targetUUID);
        if (targetOpt.isEmpty()) {
            sender.sendMessage(this.msg("reply_player_offline"));
            this.messageManager.removeLastSender(sender.getUniqueId());
            return;
        }
        Player target = (Player)targetOpt.get();
        String message = String.join((CharSequence)" ", args);
        String senderFormat = this.config.getMessage("msg_format_sender", Map.of("player", target.getUsername(), "message", message));
        String receiverFormat = this.config.getMessage("msg_format_receiver", Map.of("player", sender.getUsername(), "message", message));
        sender.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(senderFormat));
        target.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(receiverFormat));
        this.messageManager.setLastSender(target.getUniqueId(), sender.getUniqueId());
        this.messageManager.setLastSender(sender.getUniqueId(), target.getUniqueId());
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return true;
    }

    private Component msg(String key) {
        return this.msg(key, new HashMap<String, String>());
    }

    private Component msg(String key, Map<String, String> replacements) {
        String message = this.config.getMessage(key, replacements);
        return LegacyComponentSerializer.legacySection().deserialize(message);
    }
}

