/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.manager.FriendsManager;
import de.simonspeedy.friends.manager.PlayerSettingsManager;
import de.simonspeedy.friends.messaging.PluginMessageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class FriendEventListener {
    private final FriendsManager friendsManager;
    private final ProxyServer server;
    private final ConfigManager config;
    private final PlayerSettingsManager settingsManager;
    private final PluginMessageHandler messageHandler;

    public FriendEventListener(FriendsManager friendsManager, ProxyServer server, ConfigManager config, PlayerSettingsManager settingsManager, PluginMessageHandler messageHandler) {
        this.friendsManager = friendsManager;
        this.server = server;
        this.config = config;
        this.settingsManager = settingsManager;
        this.messageHandler = messageHandler;
    }

    @Subscribe
    public void onPlayerJoin(PostLoginEvent event) {
        long onlineFriends;
        Set<UUID> pendingRequests;
        Set<UUID> friends;
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.friendsManager.updatePlayerName(playerUUID, player.getUsername());
        if (this.config.getSetting("notify_on_join", true)) {
            friends = this.friendsManager.getFriends(playerUUID);
            for (UUID friendUUID : friends) {
                this.server.getPlayer(friendUUID).ifPresent(friend -> {
                    if (this.settingsManager.areNotificationsEnabled(friendUUID)) {
                        friend.sendMessage(this.msg("friend_online", Map.of("player", player.getUsername())));
                        this.messageHandler.notifyFriendOnline(friendUUID, playerUUID, player.getUsername());
                    }
                });
            }
        }
        if (this.config.getSetting("notify_pending_requests", true) && !(pendingRequests = this.friendsManager.getPendingRequests(playerUUID)).isEmpty()) {
            player.sendMessage(this.msg("pending_requests_notification", Map.of("count", String.valueOf(pendingRequests.size()))));
        }
        if (this.config.getSetting("show_online_count", true) && (onlineFriends = (friends = this.friendsManager.getFriends(playerUUID)).stream().filter(uuid -> this.server.getPlayer(uuid).isPresent()).count()) > 0L) {
            player.sendMessage(this.msg("friends_online_count", Map.of("online", String.valueOf(onlineFriends), "total", String.valueOf(friends.size()))));
        }
    }

    @Subscribe
    public void onPlayerLeave(DisconnectEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (this.config.getSetting("notify_on_leave", true)) {
            Set<UUID> friends = this.friendsManager.getFriends(playerUUID);
            for (UUID friendUUID : friends) {
                this.server.getPlayer(friendUUID).ifPresent(friend -> {
                    if (this.settingsManager.areNotificationsEnabled(friendUUID)) {
                        friend.sendMessage(this.msg("friend_offline", Map.of("player", player.getUsername())));
                        this.messageHandler.notifyFriendOffline(friendUUID, playerUUID, player.getUsername());
                    }
                });
            }
        }
    }

    @Subscribe
    public void onServerSwitch(ServerConnectedEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        if (event.getPreviousServer().isEmpty()) {
            return;
        }
        if (this.config.getSetting("notify_on_server_switch", false)) {
            String serverName = event.getServer().getServerInfo().getName();
            Set<UUID> friends = this.friendsManager.getFriends(playerUUID);
            for (UUID friendUUID : friends) {
                this.server.getPlayer(friendUUID).ifPresent(friend -> {
                    if (this.settingsManager.areNotificationsEnabled(friendUUID)) {
                        friend.sendMessage(this.msg("friend_server_switch", Map.of("player", player.getUsername(), "server", serverName)));
                        this.messageHandler.notifyFriendServerSwitch(friendUUID, playerUUID, player.getUsername(), serverName);
                    }
                });
            }
        }
    }

    private Component msg(String key, Map<String, String> replacements) {
        String prefix = this.config.getMessage("prefix", new HashMap<String, String>());
        String message = this.config.getMessage(key, replacements);
        return LegacyComponentSerializer.legacySection().deserialize(prefix + message);
    }
}

