/*
 * Decompiled with CFR 0.152.
 */
package de.simonspeedy.friends;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import de.simonspeedy.friends.commands.FriendCommand;
import de.simonspeedy.friends.config.ConfigManager;
import de.simonspeedy.friends.listeners.FriendEventListener;
import de.simonspeedy.friends.manager.FriendsManager;
import de.simonspeedy.friends.manager.MessageManager;
import de.simonspeedy.friends.manager.PlayerSettingsManager;
import de.simonspeedy.friends.messaging.PluginMessageHandler;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;

@Plugin(id="friends", name="Friends", version="1.2.0", description="Friends Plugin for Velocity", url="https://simolzimol.eu", authors={"SimolZimol"})
public class FriendsPlugin {
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;
    private FriendsManager friendsManager;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private PlayerSettingsManager settingsManager;
    private PluginMessageHandler messageHandler;

    @Inject
    public FriendsPlugin(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.logger.info("Loading Friends Plugin...");
        this.configManager = new ConfigManager(this.dataDirectory, this.logger);
        this.configManager.load();
        this.friendsManager = new FriendsManager(this.dataDirectory, this.logger, this.configManager);
        this.friendsManager.load();
        this.messageManager = new MessageManager();
        this.settingsManager = new PlayerSettingsManager(this.dataDirectory, this.logger, this.configManager, this.friendsManager.getDatabaseManager());
        this.settingsManager.load();
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{PluginMessageHandler.CHANNEL});
        this.messageHandler = new PluginMessageHandler(this.server, this.friendsManager, this.settingsManager, this.logger);
        this.server.getEventManager().register((Object)this, (Object)this.messageHandler);
        final FriendCommand friendCommand = new FriendCommand(this.friendsManager, this.server, this.configManager, this.messageManager, this.settingsManager, this.logger, this.messageHandler);
        this.server.getCommandManager().register("friend", (Command)friendCommand, new String[0]);
        this.server.getCommandManager().register("friends", (Command)friendCommand, new String[0]);
        this.server.getCommandManager().register("f", (Command)friendCommand, new String[0]);
        this.server.getCommandManager().register("fmsg", (Command)new SimpleCommand(){
            final /* synthetic */ FriendsPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public void execute(final SimpleCommand.Invocation invocation) {
                String[] originalArgs = (String[])invocation.arguments();
                final String[] newArgs = new String[originalArgs.length + 1];
                newArgs[0] = "msg";
                System.arraycopy(originalArgs, 0, newArgs, 1, originalArgs.length);
                friendCommand.execute(new SimpleCommand.Invocation(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String alias() {
                        return "fmsg";
                    }

                    public String[] arguments() {
                        return newArgs;
                    }

                    public CommandSource source() {
                        return invocation.source();
                    }
                });
            }

            public List<String> suggest(final SimpleCommand.Invocation invocation) {
                String[] originalArgs = (String[])invocation.arguments();
                final String[] newArgs = new String[originalArgs.length + 1];
                newArgs[0] = "msg";
                System.arraycopy(originalArgs, 0, newArgs, 1, originalArgs.length);
                return friendCommand.suggest(new SimpleCommand.Invocation(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String alias() {
                        return "fmsg";
                    }

                    public String[] arguments() {
                        return newArgs;
                    }

                    public CommandSource source() {
                        return invocation.source();
                    }
                });
            }

            public boolean hasPermission(SimpleCommand.Invocation invocation) {
                return true;
            }
        }, new String[0]);
        this.server.getCommandManager().register("fr", (Command)new SimpleCommand(){
            final /* synthetic */ FriendsPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public void execute(final SimpleCommand.Invocation invocation) {
                String[] originalArgs = (String[])invocation.arguments();
                final String[] newArgs = new String[originalArgs.length + 1];
                newArgs[0] = "reply";
                System.arraycopy(originalArgs, 0, newArgs, 1, originalArgs.length);
                friendCommand.execute(new SimpleCommand.Invocation(){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String alias() {
                        return "fr";
                    }

                    public String[] arguments() {
                        return newArgs;
                    }

                    public CommandSource source() {
                        return invocation.source();
                    }
                });
            }

            public boolean hasPermission(SimpleCommand.Invocation invocation) {
                return true;
            }
        }, new String[0]);
        this.server.getCommandManager().register("fl", (Command)new SimpleCommand(){
            final /* synthetic */ FriendsPlugin this$0;
            {
                this.this$0 = this$0;
            }

            public void execute(final SimpleCommand.Invocation invocation) {
                friendCommand.execute(new SimpleCommand.Invocation(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public String alias() {
                        return "fl";
                    }

                    public String[] arguments() {
                        return new String[]{"list"};
                    }

                    public CommandSource source() {
                        return invocation.source();
                    }
                });
            }

            public boolean hasPermission(SimpleCommand.Invocation invocation) {
                return true;
            }
        }, new String[0]);
        this.server.getEventManager().register((Object)this, (Object)new FriendEventListener(this.friendsManager, this.server, this.configManager, this.settingsManager, this.messageHandler));
        this.logger.info("Friends Plugin loaded successfully!");
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.logger.info("Shutting down Friends Plugin...");
        if (this.friendsManager != null) {
            this.friendsManager.shutdown();
        }
        this.logger.info("Friends Plugin shut down successfully!");
    }

    public FriendsManager getFriendsManager() {
        return this.friendsManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ProxyServer getServer() {
        return this.server;
    }
}

