/*
 * Decompiled with CFR 0.152.
 */
package de.staffchat.shaded.jda.internal.requests.restaction.pagination;

import de.staffchat.shaded.jda.api.entities.Guild;
import de.staffchat.shaded.jda.api.entities.Member;
import de.staffchat.shaded.jda.api.entities.ScheduledEvent;
import de.staffchat.shaded.jda.api.exceptions.ParsingException;
import de.staffchat.shaded.jda.api.requests.Request;
import de.staffchat.shaded.jda.api.requests.Response;
import de.staffchat.shaded.jda.api.requests.Route;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.PaginationAction;
import de.staffchat.shaded.jda.api.requests.restaction.pagination.ScheduledEventMembersPaginationAction;
import de.staffchat.shaded.jda.api.utils.data.DataArray;
import de.staffchat.shaded.jda.api.utils.data.DataObject;
import de.staffchat.shaded.jda.internal.entities.EntityBuilder;
import de.staffchat.shaded.jda.internal.entities.GuildImpl;
import de.staffchat.shaded.jda.internal.entities.MemberImpl;
import de.staffchat.shaded.jda.internal.requests.restaction.pagination.PaginationActionImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ScheduledEventMembersPaginationActionImpl
extends PaginationActionImpl<Member, ScheduledEventMembersPaginationAction>
implements ScheduledEventMembersPaginationAction {
    protected final Guild guild;

    public ScheduledEventMembersPaginationActionImpl(ScheduledEvent event) {
        super(event.getGuild().getJDA(), Route.Guilds.GET_SCHEDULED_EVENT_USERS.compile(event.getGuild().getId(), event.getId()).withQueryParams("with_member", "true"), 1, 100, 100);
        this.guild = event.getGuild();
    }

    @Override
    @Nonnull
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    protected void handleSuccess(Response response, Request<List<Member>> request) {
        DataArray array = response.getArray();
        ArrayList<MemberImpl> members = new ArrayList<MemberImpl>(array.length());
        EntityBuilder builder = this.api.getEntityBuilder();
        for (int i = 0; i < array.length(); ++i) {
            try {
                DataObject object = array.getObject(i);
                if (object.isNull("member")) continue;
                DataObject userObject = object.getObject("user");
                DataObject memberObject = object.getObject("member");
                MemberImpl member = builder.createMember((GuildImpl)this.guild, memberObject.put("user", userObject));
                members.add(member);
                continue;
            }
            catch (ParsingException | NullPointerException e) {
                LOG.warn("Encountered an exception in ScheduledEventPagination", e);
            }
        }
        if (this.order == PaginationAction.PaginationOrder.BACKWARD) {
            Collections.reverse(members);
        }
        if (this.useCache) {
            this.cached.addAll(members);
        }
        if (!members.isEmpty()) {
            this.last = members.get(members.size() - 1);
            this.lastKey = ((Member)this.last).getIdLong();
        }
        request.onSuccess(members);
    }

    @Override
    protected long getKey(Member it) {
        return it.getIdLong();
    }
}

